#ifndef UDF_CONT_H
#define UDF_CONT_H
#endif

#include "ByteDefs.h"

#ifndef UDF_VAR_H
  #include "gph_str.h"
  #include "cont_str.h"
  #include "Gmenu_str.h"
#endif

struct LabInfo
{
   ByTe_1   Fmt; 
   ByTe_1   LocA; 
   ByTe_1   LocB; 
   ByTe_1   Occur; 
   ByTe_2   Size; 
   ByTe_2   Color; 
   ReaL_4   XOff; 
   ReaL_4   YOff; 
   u_ByTe_2 UDefLab;
};

struct Binning
{
   ReaL_8   R;                            /* resolution per bin            */
   ReaL_4   Start;                        /* Begin Bin Center              */
   ReaL_4   Stop;                         /* End Bin Center                */
   ReaL_4   OrigR;                        /* Original R                    */
   ByTe_2   N;                            /* Number of Bins                */
   ByTe_1   Sca;                          /* Scaling                       */
   ByTe_1   OrigSca;                      /* Original Scaling              */
   ByTe_1   Fmt;                          /* Format                        */
   ByTe_1   Empty;                        /* how to fill empty bins        */
   ByTe_1   Fill;                         /* how to insert data            */
   ByTe_1   Dir;                          /* inc or dec element            */
   ByTe_1   Pos;                          /* centers or edges              */
   ByTe_1   NewHdr;                       /* 0-old header, 1 new header    */
   ByTe_1   SType;                        /* 0-monotonic, 1-discontinuous  */
                                          /* 2-continuous non-monotonic    */
};

struct AxisInfo
{
   ReaL_4   Min;                          /* Axis Minumum Value            */
   ReaL_4   Max;                          /* Axis Maximum Value            */
   ReaL_4   PMin;                         /* Phase Axis Abs Minumum Value  */
   ReaL_4   PMax;                         /* Phase Axis Abs Maximum Value  */
   ReaL_4   NumOffset;                    /* Axis Number Offset            */
   ReaL_4   NumSpace;                     /* Axis Number Spaceing          */
   ReaL_4   NumGap;                       /* Axis Number Horizontal Gap    */
   ReaL_4   LabOffset;                    /* Axis Label Offset             */
   ReaL_4   LabSpace;                     /* Axis Label Spaceing           */
   ByTe_2   MnTLen;                       /* Axis Minor Tick Length        */
   ByTe_2   MjTLen;                       /* Axis Major Tick Length        */
   ByTe_2   LabSize;                      /* Axis Label Size               */
   ByTe_2   NumSize;                      /* Axis Numerical Label Size     */
   ByTe_1   NumFmt[15];                   /* Axis Numerical Label Format   */
   ByTe_1   Sca;                          /* Axis Scaling                  */
   ByTe_1   MjTFmt;                       /* Axis Major Tick Format        */
   ByTe_1   MnTFmt;                       /* Axis Minor Tick Format        */
   ByTe_1   MjTNum;                       /* Axis Major Tick Number        */
   ByTe_1   MnTNum;                       /* Axis Minor Tick Number        */
   ByTe_1   NumIntlv;                     /* Axis Number Interleave Flag   */
   ByTe_1   NumSkip;                      /* Axis Number Skip Value        */
   ByTe_1   DoLabs;                       /* Axis can be labeled?          */
};

struct PlotInfo
{
   ReaL_4   Lx;                           /* Left side plot X position     */
   ReaL_4   Rx;                           /* Right side plot X position    */
   ReaL_4   Ly;                           /* Lower plot Y position         */
   ReaL_4   Uy;                           /* Upper plot Y position         */
   ReaL_4   dCr;                          /* delta Cut width right         */
   ReaL_4   dCb;                          /* delta Cut width bottom        */
   ReaL_4   dX;                           /* plot width in X               */
   ReaL_4   dY;                           /* plot width in Y               */
   ReaL_4   dXp;                          /* width in X between plots      */
   ReaL_4   dYp;                          /* width in Y between plots      */
   ReaL_4   dYPd;                         /* width in Y between plot defs  */
   ReaL_4   AbsLy;                        /* width in Y between plot defs  */
   ReaL_4   ToPdY;                        /* bap between dups              */
};

struct TiMiNg
{
   ByTe_2 Yr;
   ByTe_2 Dy;
   ByTe_4 Ms;
   ByTe_4 Ns;
};

struct VSrcInfo
{
   struct TiMiNg Vb;               /* current begin vector timing          */
   struct TiMiNg Ve;               /* current end vector timing            */
   u_ByTe_2      P;                /* UDF project                          */
   u_ByTe_2      M;                /* UDF mission                          */
   u_ByTe_2      E;                /* UDF experiment                       */
   u_ByTe_2      I;                /* UDF instrument                       */
   u_ByTe_2      V;                /* UDF virtual instrument               */
   u_ByTe_4      Key;              /* This UDF KEY value                   */
   ByTe_2        Group[3];         /* Seleted Group Number                 */
   ByTe_2        SenPN[3];         /* PIDF SENSOR NUMBER                   */
   ByTe_2        SenUN[3];         /* PIDF SENSOR UNITS NUMBER             */
   ByTe_2        SenVN[3];         /* VIDF SENSOR NUMBER                   */
   ByTe_2        SenAVN[3];        /* ANC VIDF NUMBER                      */
   u_ByTe_2      SenOps[3];        /* Operations for Sensor Units          */
   u_ByTe_2      SenTbls[3];       /* Tables to apply for Sensor Units     */
   u_ByTe_2      Ver;              /* Version number                       */
   ByTe_1        SenNAS[3];        /* No. of Algorithm Step in Sen Units   */
   ReaL_4        MaxValid[3];      /* maximum Valid Value                  */
   ReaL_4        MinValid[3];      /* minimum Valid Value                  */
   ReaL_4        Data[3];          /* X, Y, Z or whatever                  */
   ByTe_1        RStat[3];         /* data status                          */
   ByTe_1        DLoc[3];          /* data location S(ensor) A(ncillary)   */
};

struct SrcInfo
{
   struct TiMiNg Bt;                /* Beg time of data                     */
   struct TiMiNg Et;                /* End time of data                     */
   struct TiMiNg Eg;                /* Last time to get data for plot       */
   u_ByTe_2      P;                 /* UDF project                          */
   u_ByTe_2      M;                 /* UDF mission                          */
   u_ByTe_2      E;                 /* UDF experiment                       */
   u_ByTe_2      I;                 /* UDF instrument                       */
   u_ByTe_2      V;                 /* UDF virtual instrument               */
   u_ByTe_4      Key;               /* UDF Key                              */
   ByTe_2        DType;             /* Selected Data Type                   */
   ByTe_2        Group;             /* Selected Group Number Type           */
   ByTe_2        LatSrc;            /* Latitude Source                      */
   ByTe_2        LngSrc;            /* Longitude Source                     */
   ByTe_2        SenPN;             /* PIDF SENSOR NUMBER                   */
   ByTe_2        SAltPN;            /* PIDF SENSOR NUMBER                   */
   ByTe_2        GetPN;             /* PIDF NUMBER of Item to Get           */
   ByTe_2        LatPN;             /* PIDF NUMBER of Latitude to Get       */
   ByTe_2        LngPN;             /* PIDF NUMBER of Longitude to Get      */
   ByTe_2        GetUN;             /* PIDF UNIT NUMBER of Item to Get      */
   ByTe_2        AltUN;             /* PIDF Secondary UNIT NUMBER (Scan)    */
   ByTe_2        SAltUN;            /* PIDF Secondary UNIT NUMBER (Scan)    */
   ByTe_2        SecPN;             /* PIDF NUMBER IF ANC is scan           */
   ByTe_2        SecUN;             /* PIDF Secondary UNIT NUMBER (Scan)    */
   ByTe_2        AltSB;             /* PIDF Secondary SCAN BLOCK (Scan)     */
   ByTe_2        LatUN;             /* PIDF UNIT NUMBER of Latitude to Get  */
   ByTe_2        LngUN;             /* PIDF UNIT NUMBER of Longitude to Get */
   ByTe_2        SenVN;             /* VIDF SENSOR NUMBER                   */
   ByTe_2        SenCN;             /* SENSOR MATRIX COL NUMBER             */
   ByTe_2        GetVN;             /* VIDF NUMBER of Item to Get           */
   ByTe_2        SecVN;             /* VIDF NUMBER of Item to Get           */
   ByTe_2        SAltVN;            /* VIDF NUMBER of Item to Get           */
   ByTe_2        LatVN;             /* VIDF NUMBER of Latitude to Get       */
   ByTe_2        LngVN;             /* VIDF NUMBER of Longitude to Get      */
   ByTe_1        GetNAS;            /* No. of Algorithm Step in Get Units   */
   ByTe_1        AltNAS;            /* No. of Algorithm Step in Alt Units   */
   ByTe_1        SAltNAS;           /* No. of Algorithm Step in Alt Units   */
   ByTe_1        SecNAS;            /* No. of Algorithm Step in Alt Units   */
   ByTe_1        LatNAS;            /* No. of Alg Step in Latitude Units    */
   ByTe_1        LngNAS;            /* No. of Alg Step in Longitude Units   */
   ByTe_1        AltSca;            /* Scale for Alternate Unit             */
   ByTe_1        SecSca;            /* Scale for Alternate Unit             */
   ByTe_1        UDFSrc;            /* Measurement source in UDF            */
   u_ByTe_2      GetOps;            /* Scan Operations for Get Units        */
   u_ByTe_2      GetTbls;           /* Tables to apply for Get Units        */
   u_ByTe_2      AltOps;            /* Scan Operations for Alt Units        */
   u_ByTe_2      SAltOps;           /* Scan Operations for Alt Units        */
   u_ByTe_2      SecOps;            /* Scan Operations for Alt Units        */
   u_ByTe_2      AltTbls;           /* Tables to apply for Alt Units        */
   u_ByTe_2      SAltTbls;           /* Tables to apply for Alt Units        */
   u_ByTe_2      SecTbls;           /* Tables to apply for Alt Units        */
   u_ByTe_2      LatOps;            /* Scan Operations for Latitude Units   */
   u_ByTe_2      LatTbls;           /* Tables to apply for Latitude Units   */
   u_ByTe_2      LngOps;            /* Scan Operations for Longitude Units  */
   u_ByTe_2      LngTbls;           /* Tables to apply for Longitude Units  */
   u_ByTe_2      Ver;               /* Version number                       */
   ByTe_1        OneAll;            /* Do one or all sensors                */
   ReaL_4        MinValid;          /* minimum valid value                  */
   ReaL_4        MaxValid;          /* maximum valid value                  */
   ByTe_2        DLen;              /* Number of samples retrieved          */
   ByTe_1        PrevRead;          /* Data Pending? 0=NO 1=YES             */
   ByTe_1        DPres;             /* Data present: 0 - no, 1 - yes        */
   ByTe_4        DSize;             /* elements in primary or alternate     */
   void          *Pri;              /* primary data                         */
   void          *Alt;              /* alternate (scan) data                */
   void          *Sec;              /* secodary or extra memory             */
   void          *Bins;             /* Alt Binning Array                    */
   ReaL_4        Mass;              /* sensor mass (if applicable)          */
   ReaL_4        ColD;              /* Collapsed data                       */
   ByTe_2        PCol;              /* line plot color                      */
   ByTe_2        ECol;              /* error bar colors                     */
   ByTe_2        TCols;             /* Total colums in matrix data          */
   u_ByTe_2      ScatSym;           /* scatter or lab line plot symbol      */
   u_ByTe_2      SymSize;           /* symbol size                          */
   ByTe_1        LpType;            /* line plot type                       */
   ByTe_1        AddErr;            /* Add error bars                       */
   ByTe_1        PAxis;             /* Plot Axis                            */
   ByTe_1        SType;             /* Plot Axis                            */
   struct        Binning Col;       /* collapse information                 */
};

struct UserDefs
{
   struct TiMiNg  TB;                /* user requested starting time         */
   struct TiMiNg  TE;                /* user requested ending time           */
   struct LabInfo Lm;                /* main label information               */
   ReaL_4         RtX;               /* base rec window X length in pixels   */
   ReaL_4         RtY;               /* base rec window Y length in pixels   */
   ReaL_4         SqX;               /* base rec window X length in pixels   */
   ReaL_4         SqY;               /* base rec window Y length in pixels   */
   ReaL_4         Xl;                /* left plot offset                     */
   ReaL_4         Xr;                /* right plot offset                    */
   ReaL_4         Yt;                /* top plot offset                      */
   ReaL_4         Yb;                /* bottom plot offset                   */
   ReaL_4         DupYb;             /* Dup Y spacing                        */
   ByTe_4         PYmin;             /* minimum Y plot position              */
   ByTe_4         PYmax;             /* maximum Y plot position              */
   ByTe_4         PXmin;             /* minimum X plot position              */
   ByTe_4         PXmax;             /* maximum X plot position              */
   ByTe_4         NPDefs;            /* number of defined sources            */
   ByTe_4         NumP;              /* total number of defined plots        */
   ByTe_2         Rows;              /* overall number of rows in figure     */
   ByTe_2         Cols;              /* overall number of columns in figure  */
   ByTe_2         Dups;              /* duplicate definition number          */
   ByTe_2         EmptyPd;           /* next empty plot definition struture  */
   u_ByTe_2       Ctable;            /* color table to use                   */
   u_ByTe_2       PSrcs;             /* offset to plot def menu win #'s      */
   ByTe_1         TimeStamp;         /* output time stamp flag               */
   ByTe_1         DefMenu;           /* output default menu flag             */
   ByTe_1         Dev;               /* the output graphics device           */
   ByTe_1         PLfmt;             /* base window fmt 0 -rectang 1-square  */
   ByTe_1         PMode;             /* landscape or portrait                */
   void           *PlotDefs;         /* pointer to line plot definitions     */
   void           *PIDF;             /* Generic pointer to PIDF Into Struct  */
   void           *UDF;              /* Generic pointer to UDF Into Struct   */
};

struct WorkArea
{
   ReaL_4 *X;
   ReaL_4 *Y;
   ReaL_4 *Z;
   ReaL_4 *V;
   ReaL_4 *N;
   void   *WorkSpace;
   void   *Scratch;
   void   *CStore;
   void   *SStore;
   ByTe_4 SizeCStore;
   ByTe_4 NextCStore;
   ByTe_4 SizeSStore;
   ByTe_4 NextSStore;
   ByTe_4 SizeWork;
   ByTe_4 SizeScr;
   ByTe_4 Num;
};

struct CutDef
{
   struct AxisInfo Ax;                  /* Cut Plot Axis Info Right        */
   struct AxisInfo Ay;                  /* Cut Plot Axis Info Right        */
   ReaL_4 CutSpace;                     /* Cut Plot Percent of whole       */
   ByTe_1 CutPlot;                      /* Number of Cut Plots Defined     */
   ByTe_1 CutPlace;                     /* Contour CutPlot                 */
   ByTe_1 CutPn;                        /* Cut plot number right           */
   ReaL_4 X1[4];
   ReaL_4 X2[4];
   ReaL_4 Y1[4];
   ReaL_4 Y2[4];
   ByTe_2 PlotCol[4];
   ByTe_1 PlotFmt[4];
   ByTe_1 ShowCut[4];
};

struct CollapseInfo
{
   ByTe_2 Nbins;
   ByTe_2 Method;
   ReaL_4 Begin[16];
   ReaL_4 End[16];
};

struct ShowVec
{
   u_ByTe_2 Head;
   u_ByTe_2 Tail;
   ByTe_2   Size;
   ByTe_2   Color;
   ByTe_4   VecPN;
   ByTe_4   VecN;
};

struct GridInfo
{
   ByTe_2 Nx;
   ByTe_2 Ny;
   ByTe_2 Nz;
   ByTe_1 ScaX;
   ByTe_1 ScaY;
   ByTe_1 ScaZ;
   ReaL_4 MinX;
   ReaL_4 MinY;
   ReaL_4 MinZ;
   ReaL_4 MaxX;
   ReaL_4 MaxY;
   ReaL_4 MaxZ;
   ReaL_4 RMinX;
   ReaL_4 RMinY;
   ReaL_4 RMinZ;
   ReaL_4 RMaxX;
   ReaL_4 RMaxY;
   ReaL_4 RMaxZ;
   ReaL_4 dX;
   ReaL_4 dY;
   ReaL_4 dZ;
};

struct PlaneInfo
{
   struct VSrcInfo Vs;
   ByTe_4 Steps;
   ReaL_4 ZTrans;
   ReaL_4 Phi;
   ReaL_4 Theta;
   ReaL_4 BRho;
   ReaL_4 Rho;
   ReaL_4 Z;
   ReaL_4 Avg[3];
   ByTe_1 RotateFmt;
   ByTe_1 RotateTo;
   ByTe_1 VecSrc;
};

struct ConTouR 
{
   ByTe_1   Format;
   ByTe_1   Method;
   ByTe_1   NewGrid;
   ByTe_1   PrMesh;
   ByTe_1   NegData;
   ByTe_1   XSca;
   ByTe_1   YSca;
   ByTe_1   XCyclic;
   ByTe_4   XBins;
   ReaL_4   XMin;
   ReaL_4   XMax;
   ReaL_4   CycDis1;
   ReaL_4   CycDis2;
   ByTe_4   YBins;
   ReaL_4   YMin;
   ReaL_4   YMax;
   ReaL_4   Weight;
   ReaL_4   Radius;
   ByTe_4   FitPts;
   ByTe_2   Order;
   ByTe_2   Quads;
   ByTe_1   OrGridPat;
   ByTe_1   RBase;
   ByTe_1   DispFmt;
   ByTe_1   ZSca;
   ByTe_4   NCells;
   ByTe_4   NContours;
   ReaL_4   MinContour;
   ReaL_4   MaxContour;
   ByTe_2   ContColor;
   ByTe_1   ShowCLabs;
   ByTe_1   ShowGrids;
   ByTe_1   ShowData;
   ByTe_2   CLabColor;
   ByTe_2   GridColor;
   ByTe_2   DataColor;
   ByTe_2   CLabSize;
   ByTe_2   CLabSkip;
   u_ByTe_2 CLabFmt;
   ByTe_2   GridSize;
   u_ByTe_2 GridFmt;
   ByTe_2   DataSize;
   u_ByTe_2 DataFmt;
};


struct MapInfo
{
   ReaL_4 DLat; 
   ReaL_4 DLong; 
   ReaL_4 LastNLat; 
   ReaL_4 LastSLat; 
   ReaL_4 RotLong; 
   ReaL_4 RotLat; 
   ByTe_2 GColor; 
   ByTe_2 MColor; 
   ByTe_2 MapRes; 
   ByTe_1 Projection; 
   ByTe_1 Grid; 
   ByTe_1 Map; 
};

struct PlotDef
{
   struct   AxisInfo Yl;                  /* Left Y Axis Info                */
   struct   AxisInfo Yr;                  /* Right Y Axis Info               */
   struct   AxisInfo Xb;                  /* Bottom X Axis Info              */
   struct   AxisInfo Xt;                  /* Top X Axis Info                 */
   struct   AxisInfo Cb;                  /* Color Bar Axis Info             */
   struct   PlotInfo P;                   /* Plot Placement Info             */
   struct   TiMiNg Pb;                    /* current beginning plot time     */
   struct   TiMiNg Pe;                    /* current ending plot time        */
   struct   Binning Bx;                   /* X axis binning                  */
   struct   Binning Byl;                  /* Y axis binning                  */
   struct   Binning Byr;                  /* Y axis binning                  */
   struct   Binning Tm;                   /* Time binning                    */
   struct   MapInfo Map;                  /* Map Info Struct                 */
   struct   LabInfo Li[6];                /* Label Info Struct               */
   ByTe_2   Rows;                         /* Number of rows of plots         */
   ByTe_2   Cols;                         /* Number of cols of plots         */
   ByTe_2   Gap;                          /* Gap size in spetro scalars      */
   ByTe_2   SrcNum;                       /* Src Number for Time by Src      */
   ByTe_2   EmptySrc;                     /* Next Empty Src Structure        */
   ByTe_2   NTools;                       /* number of defined plot tools    */
   ByTe_2   nGL;                          /* Num graphs per plot left axis   */
   ByTe_2   nGR;                          /* Num graphs per plot right axis  */
   ByTe_2   Stack;                        /* # graphs to stack in plot       */
   ByTe_2   SrcsYL;                       /* Number srcs plotted against YL  */
   ByTe_2   SrcsYR;                       /* Number srcs plotted against YR  */
   ByTe_2   FSrcYL;                       /* first YL source                 */
   ByTe_2   ExPlots;                      /* necessary blank plots           */
   ByTe_2   AlignPd;                      /* necessary blank plots           */
   u_ByTe_2 TSrcs;                        /* offset to tool def menu win #'s */
   u_ByTe_2 TDefs;                        /* offset to tool def formats      */
   u_ByTe_2 SrcPN;                        /* Source Page Numbers             */
   u_ByTe_2 SecPos;                       /* Secondary data offsets          */
   ByTe_4   NSrcs;                        /* Number of defined sources       */
   ByTe_4   PlotLen;                      /* Elements in one plot            */
   ReaL_4   CInfo[4];                     /* Color Scaling                   */
   ByTe_1   TimeDir;                      /* Begining plot number            */
   ByTe_1   SyncSrcs;                     /* Sync beginning Source times     */
   ByTe_1   Pn;                           /* Begining plot number            */
   ByTe_1   Wn;                           /* Begining window number          */
   ByTe_1   AxisDef;                      /* Axis Definitions                */
   ByTe_1   AData[3];                     /* what is plotted on X axis       */
   ByTe_1   ZeroInc;                      /* include/exclude 0 in averages   */
   ByTe_1   IgnBlank;                     /* ignore blank plots              */
   ByTe_1   DoSrcs;                       /* Individual Source Treatment     */
   ByTe_1   OutFmt;                       /* Output Format                   */
   ByTe_1   BlkOpen;                      /* Use Block Open if available     */
   ByTe_1   IncCont;                      /* contour counter                 */
   ByTe_1   PAxes;                        /* plot axes ratio                 */
   ByTe_1   NeedCbar;                     /* need to show colorbar?          */
   ByTe_1   PType;                        /* plot base type                  */
   ByTe_1   NegYr;                        /* how to bin X values             */
   ByTe_1   YSet;                         /* how to bin Y values             */
   ByTe_1   More;                         /* continue with plots?            */
   ByTe_1   XLabs;                        /* Do what with X labels           */
   ByTe_1   YLLabs;                       /* Do what with Left Y labels      */
   ByTe_1   YRLabs;                       /* Do what with Right Y labels     */
   ByTe_1   XLabStyle;                    /* X label style                   */
   ByTe_1   YLLabStyle;                   /* Left Y label style              */
   ByTe_1   YRLabStyle;                   /* Right Y label style             */
   ByTe_1   PStat;                        /* Plot Status                     */
   void     *CCut;                        /* Contour Cut Plot Definition     */
   void     *LSCut;                       /* LShell Cut Plot Definition      */
   void     *Plane;                       /* 3D Plane Info Struct            */
   void     *Cont;                        /* Contour Info Struct             */
   void     *Src;                         /* Source Information structures   */
   void     *Tools;                       /* Source Information structures   */
   void     *SOrder;                      /* Source Key Order Index          */
   void     *Times;                       /* plot times                      */
};

struct ToolInfo
{
   struct VSrcInfo Vs;
   struct VSrcInfo Vs1;
   struct VSrcInfo Vs2;
   u_ByTe_2        Head;
   u_ByTe_2        Tail;
   ByTe_2          Size;
   ByTe_2          Color1;
   ByTe_2          Color2;
   ByTe_2          Color3;
   ByTe_2          Color4;
   ReaL_4          Avg[3];
   ReaL_4          Avg1[3];
   ReaL_4          Avg2[3];
   ReaL_4          LRng[3];
   ReaL_4          DeltaLong;
   ReaL_4          DeltaLat;
   ReaL_4          LatEnds;
   ByTe_1          Type;
   ByTe_1          Src;
   ByTe_1          Src1;
   ByTe_1          Src2;
   ByTe_1          GlobeFmt;
   ByTe_1          MapFmt;
   ByTe_1          DisplayFmt;
   ByTe_1          Terminator;
   ByTe_1          LShell;
};
