#include <stdio.h>

#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void TimeTicks (ByTe_4 PN, ByTe_1 pn, ByTe_1 NeedNum)
{
   extern struct UserDefs InFo;

   struct PlotDef *Pd;

   register ByTe_4 *T, *TEnD;

   ReaL_4 TotTm;
   ReaL_4 FracTm;

   ByTe_4 BaseTm;
   ByTe_4 Tdy, Tms, EndY;
   ByTe_4 dT[8];
   ByTe_4 TotP;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;      /* the plot def struct    */

   TotP = Pd->Xb.Max - Pd->Xb.Min - 1;             /* useable pixs along X   */
   TotTm  = Pd->Bx.R * TotP;                       /* float pixel number     */

   TEnD = dT + 8;                                  /* end of dT array        */
   for (T = dT; T < TEnD;)                         /* loop over delta times  */
       *T++ = 0;                                   /* initialize to 0        */

   BaseTm = (ByTe_4)TotTm;                         /* integer time           */
   FracTm = TotTm - (ReaL_4)BaseTm;                /* fractional time        */
   switch (Pd->Bx.Sca)                             /* switch by time base    */
   {                                               /* BEG TIME BASE SWITCH   */
      case 1:                                      /* START DAY BASE TIME    */
         T = dT;                                   /* reset dT pointer       */
         Tms = Pd->Pb.Ms + FracTm * 86400000.0;    /* milliseconds           */
         Tdy = Pd->Pb.Dy + BaseTm;                 /* total days             */
         if (Tms > 86400000)                       /* > 1 day in msec?       */
            ++Tdy;                                 /* add a day              */

         EndY = Pd->Pb.Yr;                         /* initialize last year   */
         while (Tdy > 364)                         /* loop til days < 1 yr   */ 
         {                                         /* BEG COUNT YR LOOP      */
            Tdy -= LeaP(EndY);                     /* decrement 1 year       */
            if (Tdy >= 0)                          /* had enough days?       */
               ++EndY;                             /* increment end year     */
         }                                         /* BEG COUNT YR LOOP      */

         if (Pd->Pb.Dy == 0 && Pd->Pb.Ms == 0)     /* plot starts on year    */
            *T = EndY - Pd->Pb.Yr + 1;             /* # years to output      */
         else                                      /* otherwise              */
            *T = EndY - Pd->Pb.Yr;                 /* this is # years        */
      break;                                       /* STOP DAY BASE TIME     */

      case 4:                                      /* START SEC BASE TIME    */
         T = dT + 1;                               /* reset dT pointer       */
         *T++ = BaseTm / 86400;                    /* delta days             */
         *T++ = BaseTm / 3600;                     /* delta hours            */
         *T++ = BaseTm / 60;                       /* delta minutes          */
         *T = BaseTm;                              /* delta seconds          */
         *(T + 1) = (*T < 50) ? TotTm * 1000 : 0;  /* delta milliseconds     */
         T = dT;                                   /* reset dT pointer       */
         if (*(T + 1) > 364)                       /* check years            */
         {                                         /* BEG DELTA YEARS        */
            Tdy = *(T + 1) + Pd->Pb.Dy;            /* days from yr begin     */
            EndY = Pd->Pb.Yr;                      /* initialize last year   */
            while (Tdy > 364)                      /* loop til days < 1 yr   */ 
            {                                      /* BEG COUNT YR LOOP      */
               Tdy -= LeaP(EndY);                  /* decrement 1 year       */
               if (Tdy >= 0)                       /* had enough days?       */
                  ++EndY;                          /* increment end year     */
            }                                      /* BEG COUNT YR LOOP      */

            if (Pd->Pb.Dy == 0 && Pd->Pb.Ms == 0)  /* plot starts on year    */
               *T = EndY - Pd->Pb.Yr + 1;          /* # years to output      */
            else                                   /* otherwise              */
               *T = EndY - Pd->Pb.Yr;              /* this is # years        */
         }                                         /* BEG DELTA YEARS        */
      break;                                       /* STOP SEC BASE TIME     */

      case 5:                                      /* START MSEC BASE TIME   */
         T = dT;                                   /* reset dT pointer       */
         *T++ = 0;                                 /* no dY with msec base   */
         *T++ = BaseTm / 86400000;                 /* delta days             */
         *T++ = BaseTm / 3600000;                  /* delta hours            */
         *T++ = BaseTm / 60000;                    /* delta minutes          */
         *T++ = BaseTm / 1000;                     /* delta seconds          */
         *T = BaseTm;                              /* delta milliseconds     */
         *(T + 1) = (*T < 50) ? TotTm * 1000 : 0;  /* delta micro secs       */
      break;                                       /* STOP MSEC BASE TIME    */
   }                                               /* END TIME BASE SWITCH   */

   DrTmTicks (PN, pn, NeedNum, dT);                /* output the time labs   */
}
