#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "libbase_udf.h"
#include "UDFpltAnsi.h"

ByTe_2 RowCol (struct PlotDef *Pd)
{
   struct SrcInfo  *S, *SEnD;

   ByTe_4 Np = 0, Tp = 1, TotP;

   if (Pd->Cols <= 0 || Pd->Rows <= 0)             /* need to defined stuff  */
   {                                               /* BEG PLOT DEFINES       */ 
      S = (struct SrcInfo *) Pd->Src;              /* source structure       */
      SEnD = S + Pd->EmptySrc;                     /* end source structure   */

      if (Pd->DoSrcs == 1)                         /* sources not merged?    */
      {                                            /* BEG SEPARATE SOURCES   */
         for ( ; S < SEnD; ++S )                   /* loop over sources      */
            Np += (S->Col.Fmt < 0) ? 1 : S->Col.N; /* graphs per plot        */
      }                                            /* END SEPARATE SOURCES   */
      else                                         /* plots are merged       */
         Np += S->Col.N;                           /* 1 plot/collapse        */

      Tp = Np / Pd->Stack;                         /* gross number plots     */ 
      if (Np % Pd->Stack > 0)                      /* fractional plots       */
         Tp += 1;                                  /* total plot panels      */

      if (Pd->DoSrcs == 1)                         /* separate sources       */
      {                                            /* BEG ASSIGN SEP PLOTS   */
         if (Pd->Rows <= 0 && Pd->Cols <= 0)       /* assign all?            */
         {                                         /* BEG ASSIGN ALL         */
            Pd->Cols = 1;                          /* one column             */
            Pd->Rows = Tp;                         /* lots of rows           */
         }                                         /* END ASSIGN ALL         */
         else                                      /* something was assigned */
         {                                         /* BEG COL/ROW ASSIGNED   */
            if (Pd->Cols <= 0)                     /* need columns           */
            {
               Pd->Cols = Tp / Pd->Rows;           /* compute needed Cols    */
               if (Tp % Pd->Rows != 0) ++Pd->Cols; /* compute needed Cols    */
            }
            else                                   /* must be rows           */
            {
               Pd->Rows = Tp / Pd->Cols;           /* compute needed Rows    */
               if (Tp % Pd->Cols != 0) ++Pd->Rows; /* compute needed Cols    */
            }
         }                                         /* END COL/ROW ASSIGNED   */
      }                                            /* END ASSIGN SEP PLOTS   */
      else                                         /* merged collapsed plots */
      {                                            /* BEG MERGED COLLAPSED   */
         if (Pd->Rows <= 0 && Pd->Cols <= 0)       /* assign all?            */
         {                                         /* BEG ASSIGN ALL         */
            Pd->Cols = Tp;                         /* lots of columns        */
            Pd->Rows = 1;                          /* one row                */
         }                                         /* END ASSIGN ALL         */
         else                                      /* something was assigned */
         {                                         /* BEG COL/ROW ASSIGNED   */
            if (Pd->Cols <= 0)                     /* need columns           */
            {
               Pd->Cols = Tp / Pd->Rows;           /* compute needed Cols    */
               if (Tp % Pd->Rows != 0) ++Pd->Cols; /* compute needed Cols    */
            }
            else                                   /* must be rows           */
            {
               Pd->Rows = Tp / Pd->Cols;           /* compute needed Rows    */
               if (Tp % Pd->Cols != 0) ++Pd->Rows; /* compute needed Cols    */
            }
         }                                         /* END COL/ROW ASSIGNED   */
      }                                            /* END MERGED COLLAPSED   */
   }                                               /* BEG PLOT DEFINES       */ 

   TotP = Pd->Rows * Pd->Cols;                     /* total plots            */
   return (TotP % Tp);                             /* perfect match          */
}
