#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void PlotInits (ByTe_4 N)
{
   extern struct UserDefs InFo;

   struct PlotDef *Pd;
   struct SrcInfo *S;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;
   S = (struct SrcInfo *)Pd->Src;                  /* pntr to first src      */

   switch (Pd->PType)                              /* base plot type switch  */
   {                                               /* BEG PLOT TYPE SWITCH   */
      case 0:                                      /* START TIME BASED       */
         Pd->Xb.Min = 0.0;                         /* left edge is zero      */
         Pd->Xb.Max = Pd->P.dX;                    /* right edge rel left    */
         Pd->Xt.Min = Pd->Xb.Min;                  /* same top & bot sca     */
         Pd->Xt.Max = Pd->Xb.Max;                  /* same top & bot sca     */
         if (Pd->AData[1] == 1 && S->LpType == 10) /* spec scalar?           */
         {                                         /* BEG SPEC SCALAR SETS   */
             Pd->Yl.Min = 0;                       /* Left Y axis min is 0   */
             Pd->Yr.Min = 0;                       /* Right Y axis min is 0  */
             Pd->Yl.Max = Pd->P.dY;                /* Left Y axis # of pixs  */
             Pd->Yr.Max = Pd->Yl.Max;              /* Right Y Axis Same      */
             Pd->Yl.Sca = 0;                       /* Always Linear scaling  */
             Pd->Yr.Sca = 0;                       /* Always Linear scaling  */
         }                                         /* END SPEC SCALAR SETS   */
      break;                                       /* STOP TIME BASED        */
   }                                               /* END PLOT TYPE SWITCH   */
}
