#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void MidTime (struct TiMiNg *Tb, struct TiMiNg *Te, struct TiMiNg *Mt) 
{
   ByTe_4 dY, eD, eM, Dys;
   ByTe_4 aD, aM, Y;
   ByTe_1 Go;

   dY = Te->Yr - Tb->Yr;                         /* delta year              */
   eD = Te->Dy;                                  /* base days from beg Yr   */
   if (dY > 0)                                   /* multiple years          */
   {                                             /* BEG MULTIPLE YEARS      */
      Y = Tb->Yr;                                /* beg year                */
      while (Y < Te->Dy)                         /* loop until end year     */
         eD += LeaP(Y++);                        /* 1 year in days          */
   }                                             /* BEG MULTIPLE YEARS      */
   aD = (eD - Tb->Dy)/2;                         /* average days            */

   eM = Te->Ms;                                  /* ending millisec         */ 
   if (((eD - Tb->Dy) % 2) == 1)                 /* odd day difference      */ 
      eM += 86400000;                            /* increment msec          */
   aM = (eM + Tb->Ms)/2;                         /* average msec            */
   
   Go = 1;
   Mt->Yr = Tb->Yr;                              /* beg year                */
   Mt->Ns = 0;                                   /* we don't do nsecs       */
   Dys = LeaP(Tb->Yr);                           /* 1 year in days          */
   while (aD > Dys)                              /* while too many days     */
   {                                             /* BEG ROLL DAYS           */
      ++Mt->Yr;                                  /* increment end year      */
      aD -= Dys;                                 /* decrement days          */
      Dys = LeaP(Mt->Yr);                        /* 1 year in days          */
   }                                             /* BEG COUNT YR LOOP       */
   Mt->Dy = eD;

   Mt->Dy += aM/86400000;                        /* inc days                */
   Mt->Ms = aM % 86400000;                       /* increment msec          */

   Dys = LeaP(Tb->Yr);                           /* 1 year in days          */
   while (Mt->Dy > Dys)                          /* while too many days     */
   {                                             /* BEG ROLL DAYS           */
      ++Mt->Yr;                                  /* increment end year      */
      Mt->Dy -= Dys;                             /* decrement days          */
      Dys = LeaP(Mt->Yr);                        /* 1 year in days          */
   }                                             /* BEG COUNT YR LOOP       */
}
