#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void MenuLabels (struct PlotDef *Pd, ByTe_2 N)
{
   extern struct MeNuS Ms;

   struct PaGe *Pg;
   struct QuEsTiOnS *Qs, *QsEnd;

   ByTe_4 J;

 /****************************************************************************/
 /*                          LABEL INFO MENU                                 */
 /*                                                                          */
 /*  ID[00] TIME LABEL FORMAT                                                */
 /*  ID[01] TIME LABEL LOCATION                                              */
 /*  ID[02] TIME LABEL OUTPUT                                                */
 /*  ID[03] TIME LABEL OCCURANCE                                             */
 /*  ID[04] TIME LABEL X OFFSET                                              */
 /*  ID[05] TIME LABEL Y OFFSET                                              */
 /*  ID[06] TIME LABEL SIZE                                                  */
 /*  ID[07] TIME LABEL COLOR                                                 */
 /*  ID[08] SOURCE LABEL FORMAT                                              */
 /*  ID[09] SOURCE LABEL LOCATION                                            */
 /*  ID[10] SOURCE LABEL OUTPUT                                              */
 /*  ID[11] SOURCE LABEL OCCURANCE                                           */
 /*  ID[12] SOURCE LABEL X OFFSET                                            */
 /*  ID[13] SOURCE LABEL Y OFFSET                                            */
 /*  ID[14] SOURCE LABEL SIZE                                                */
 /*  ID[15] SOURCE LABEL COLOR                                               */
 /*  ID[16] COLLAPSE LABEL FORMAT                                            */
 /*  ID[17] COLLAPSE LABEL LOCATION                                          */
 /*  ID[18] COLLAPSE LABEL OUTPUT                                            */
 /*  ID[19] COLLAPSE LABEL OCCURANCE                                         */
 /*  ID[20] COLLAPSE LABEL X OFFSET                                          */
 /*  ID[21] COLLAPSE LABEL Y OFFSET                                          */
 /*  ID[22] COLLAPSE LABEL SIZE                                              */
 /*  ID[23] COLLAPSE LABEL COLOR                                             */
 /*  ID[24] PLOT DX SPACING                                                  */
 /*  ID[25] PLOT DY SPACING                                                  */
 /*  ID[26] EXTRA PLOT BLOCK TOP SPACE                                       */
/*****************************************************************************/

   Pg = (struct PaGe *) Ms.page + N;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ; 

   for ( ; Qs < QsEnd; ++Qs)
   {
      J = (Qs->ID < 40) ? Qs->ID/8 : (Qs->ID > 42) ? (Qs->ID - 3)/8 : Qs->ID;
      switch (Qs->ID)
      {
         case 0:
         case 8:
         case 16:
         case 24:
         case 32:
         case 43:
            Pd->Li[J].Fmt = Qs->OpReply;
            if (Qs->ID == 0 && Pd->AData[0] == 0 && Qs->OpReply == 2) 
               Pd->Li[J].Fmt = 0;
         break;
         case 1:
         case 9:
         case 17:
         case 25:
         case 33:
         case 44:
            Pd->Li[J].LocA = Qs->OpReply;
         break;
         case 2:
         case 10:
         case 18:
         case 26:
         case 34:
         case 45:
            Pd->Li[J].LocB = Qs->OpReply;
         break;
         case 3:
         case 11:
         case 19:
         case 27:
         case 35:
         case 46:
            Pd->Li[J].Occur = Qs->OpReply;
         break;
         case 4:
         case 12:
         case 20:
         case 28:
         case 36:
         case 47:
            sscanf (Qs->CReply, "%f", &Pd->Li[J].XOff); 
         break;
         case 5:
         case 13:
         case 21:
         case 29:
         case 37:
         case 48:
            sscanf (Qs->CReply, "%f", &Pd->Li[J].YOff); 
         break;
         case 6:
         case 14:
         case 22:
         case 30:
         case 38:
         case 49:
            sscanf (Qs->CReply, "%hd", &Pd->Li[J].Size); 
            if (Qs->ID == 22 && Pd->Li[J].Size < 0)
            {
                Pd->Li[J].Size = -Pd->Li[J].Size;
                Pd->Li[J-1].Fmt = -1;
            }
         break;
         case 7:
         case 15:
         case 23:
         case 31:
         case 39:
         case 50:
            Pd->Li[J].Color = Qs->OpReply;
         break;
         case 40:
            sscanf (Qs->CReply, "%f", &Pd->P.dXp); 
         break;
         case 41:
            sscanf (Qs->CReply, "%f", &Pd->P.dYp); 
         break;
         case 42:
            sscanf (Qs->CReply, "%f", &Pd->P.dYPd); 
         break;
         case 60:
            Pd->XLabs = Qs->OpReply;
         break;
         case 61:
            Pd->YLLabs = Qs->OpReply;
         break;
         case 62:
            Pd->YRLabs = Qs->OpReply;
         break;
         case 63:
            Pd->XLabStyle = Qs->OpReply;
         break;
         case 64:
            Pd->YLLabStyle = Qs->OpReply;
         break;
         case 65:
            Pd->YRLabStyle = Qs->OpReply;
         break;
      }
   }
}
