#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void Menu3DPlane (struct PlotDef *Pd, ByTe_2 N)
{
   extern struct MeNuS Ms;

   struct PaGe *Pg;
   struct QuEsTiOnS *Qs, *QsEnd;
   struct PlaneInfo *Pn;

   size_t B;
   ByTe_2 Mn;

   /**************************************************************************/
   /* ID[00]:   NORMAL VECTOR     [0-USER DEFINED; 1-UDF SOURCE            ] */
   /* ID[01]:   VECTOR DEFINITION                                            */
   /* ID[02]:   INITIAL Z TRANSLATION                                        */
   /* ID[03]:   NUMBER OF ROTATION STEPS                                     */
   /* ID[04]:   ROTATION VECTOR TO  [ 0-  X-axis; 1-  Y-axis;  2-  Z-axis;   */
   /*                                 3- -X-axis; 4- -Y-axis;  5- -Z-axis  ] */
   /* ID[06]:   ROTATION STEPS                                               */
   /* ID[07]:   X TRANSLATION STEP                                           */
   /* ID[08]:   INITIAL RHO ROTATION                                         */
   /**************************************************************************/

   Pg = (struct PaGe *) Ms.page + N;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ; 

   B = sizeof (struct PlaneInfo);
   if ((Pd->Plane = malloc (B)) == 0)
       exit(-1); 

   Pn = (struct PlaneInfo *)Pd->Plane;
   Pn->Phi = 0.0;
   Pn->Theta = 0.0;
   Pn->Rho = 0.0;
   Pn->RotateFmt = 0;
   Pn->Z = 0;
   for ( ; Qs < QsEnd; ++Qs)
   {
      switch (Qs->ID)
      {
         case 0:
            Pn->VecSrc = Qs->OpReply; 
            if (Pn->VecSrc == 1)
            {
               sscanf (Qs->Wins, "%hd", &Mn);
               MenuVUDF (&Pn->Vs, Mn);
            }
         break;
         case 1:
            if (Qs->state == 1)
            {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply, "%f %f", &Pn->Avg[1], &Pn->Avg[2]); 
            }
         break;
         case 2:
            sscanf (Qs->CReply, "%f", &Pn->ZTrans); 
         break;
         case 3:
            sscanf (Qs->CReply,"%d", &Pn->Steps); 
            if (Pn->Steps <= 0)
               Pn->Steps = 1;
         break;
         case 4:
            if (Qs->state == 1)
               Pn->RotateTo = Qs->OpReply;
         break;
         case 5:
            if (Qs->state == 1)
               Pn->RotateFmt = Qs->OpReply;
         break;
         case 6:
            if (Qs->state == 1)
            {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply, "%f %f %f", &Pn->Phi, &Pn->Theta, &Pn->Rho); 
            }
         break;
         case 7:
            if (Qs->state == 1)
               sscanf (Qs->CReply,"%f", &Pn->Z); 
         break;
         case 8:
            sscanf (Qs->CReply, "%f", &Pn->BRho); 
         break;
      }
   }
}
