#include <stdio.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include "OpSySInD.h"
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"

/*****************************************************************************/
/*  This program puts up all src labels associated with a given line plot    */
/*  need to be put up immediately after the plot is put up on the screen     */
/*  least they be lost.                                                      */
/*****************************************************************************/

void MainLab (ByTe_1 *DFName)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern struct config parm;

   struct PlotDef *Pd, *PdEnD;
   struct SrcInfo *S, *SEnD;

   time_t tloc = 1;

   register ByTe_1 *c1, *c2, *cEnD;
   ReaL_4 X, Y, Sz[2], R, XL, XR, Sn, Lv, dX, dY; 
   ByTe_2 LabN = 0, Lev;
   ByTe_2 C;
   ByTe_1 L[400], Tlab[50], LT[240]; 
   ByTe_1 J, *Wc;

   if (InFo.Lm.Fmt < 0)
       return;

   window (2, "MAINLABEL");
   Wc = (ByTe_1 *)Wa.CStore;

   if (InFo.Lm.Fmt > 0)                             /* we form label(s)     */
   {                                                /* BEG MAKE LABEL       */
      Pd = (struct PlotDef *)InFo.PlotDefs;         /* beg plot def structs */
      PdEnD = Pd + InFo.NPDefs;                     /* end plot def structs */
      for ( ; Pd < PdEnD; ++Pd)                     /* plot def loop        */
      {                                             /* BEG PLOT DEF LOOP    */
         S = (struct SrcInfo *)Pd->Src;             /* beg src ptr in plot  */
         SEnD = S + Pd->EmptySrc;                   /* end src ptr in plot  */
         for ( ; S < SEnD; ++S)                     /* source loop          */
         {                                          /* BEG SOURCE LOOP      */
             strcpy (Tlab, Wc + S->P);              /* Always project label */ 
             switch (InFo.Lm.Fmt)                   /* form label           */
             {                                      /* BEG LABEL ADDS       */
                case 2:                             /* START P.M            */
                  strcat (Tlab, ".");               /* add . separator      */
                  strcat (Tlab, Wc + S->M);         /* Add mission label    */ 
                break;                              /* STOP P.M             */
                case 3:                             /* START P.M.E          */
                  strcat (Tlab, ".");               /* add . separator      */
                  strcat (Tlab, Wc + S->M);         /* Add mission label    */ 
                  strcat (Tlab, ".");               /* add . separator      */
                  strcat (Tlab, Wc + S->E);         /* Add experiment label */ 
                break;                              /* STOP P.M.E           */
                case 4:                             /* START P.E            */
                  strcat (Tlab, ".");               /* add . separator      */
                  strcat (Tlab, Wc + S->E);         /* Add experiment label */ 
                break;                              /* STOP P.E             */
             }                                      /* END LABEL ADDS       */

             if (LabN == 0)                         /* no labels            */
             {                                      /* BEG ADD 1ST LABEL    */
                ++LabN;                             /* increment label cntr */
                strcpy (L, Tlab);                   /* xfer only one        */
             }                                      /* END ADD 1ST LABEL    */
             else                                   /* multiple labels      */
             {                                      /* BEG MULTI LABELS     */
                c1 = L;                             /* pointer to 1st label */
                cEnD = c1 + 40 * LabN;              /* end of labels        */
                for ( ; c1 < cEnD; c1 += 40)        /* label compare loop   */
                   if (strcmp (c1, Tlab) == 0)      /* duplicate label?     */
                      break;                        /* done                 */
                if (c1 == cEnD)                     /* did whole loop       */
                {                                   /* BEG NEW LABEL        */
                   strcpy (cEnD, Tlab);             /* add new label        */
                   ++LabN;                          /* increment label cntr */
                }                                   /* END NEW LABEL        */
             }                                      /* END MULTI LABELS     */
         }                                          /* END SOURCE LOOP      */
      }                                             /* END PLOT DEF LOOP    */
   }                                                /* EMD MAKE LABEL       */
   else                                             /* user supplied label  */
   {                                                /* BEG CUSTOM LABEL     */
      LabN = 1;                                     /* One Label            */
      strcpy (LT, Wc + InFo.Lm.UDefLab);            /* and here it is       */ 
      c1 = LT;                                      /* input pointer        */
      c2 = L;                                       /* output pointer       */
      cEnD = c1 + strlen (LT);                      /* end of input         */
      for ( ; c1 < cEnD; )
      {
          if (*c1 != '<')
             *c2++ = *c1++;
          else
          {
             if (*(c1+1) == 'B' && *(c1+2) == 'R' && *(c1+3) == '>')
             {
                c1 += 4;
                *c2 = 0;
                c2 = L + 40 * LabN++;
             }
             else
                *c2++ = *c1++;
          }
      } 
      *c2 = 0;
   }                                                /* END CUSTOM LABEL     */

   clip (2, 0);                                     /* turn off clipping    */
   chr_size (InFo.Lm.Size);                         /* label size           */
   get_chsz (Sz);                                   /* character size       */

   C = *(&parm.white + InFo.Lm.Color);              /* label color          */
   if (parm.ostyle == 0)                            /* landscape            */
   {                                                /* BEG LANDSCAPE SETS   */
      XL = 0.0;                                     /* Left X Coordinate    */
      XR = InFo.RtX;                                /* Right X Coordinate   */
      Sn = 1.0;                                     /* no reversal          */
   }                                                /* END LANDSCAPE SETS   */
   else                                             /* portrait             */
   {                                                /* BEG PORTRAIT SETS    */
      XL = InFo.RtX;                                /* Left X Coordinate    */
      XR = 0.0;                                     /* Right X Coordinate   */
      Sn = -1.0;                                    /* reversal             */
   }                                                /* END PORTRAIT SETS    */
   R = 0.0;                                         /* non-rotated labels   */

   c1 = L;                                          /* pointer to 1st label */
   cEnD = c1 + 40 * LabN;                           /* end of labels        */
   for (Lev = 0; c1 < cEnD; c1 += 40, ++Lev)        /* label compare loop   */
   {                                                /* BEG LAB OUTPUT LOOP  */
      if (InFo.Lm.LocB == 0)                        /* spread               */
         Lev /= 2;                                  /* label level          */

      Y = InFo.RtY + InFo.Lm.YOff * Sz[1];          /* corrected L0 Y pos   */
      Lv = -1.25 * Lev * Sz[1];                     /* Y displacement       */
      Y =  Y + Lv; 

      dX = Sn * InFo.Lm.XOff * Sz[0];               /* X offset             */
      switch (InFo.Lm.LocB)                         /* lab pos switch       */
      {                                             /* BEG LAB POS SWITCH   */
         case 0:                                    /* START SPREAD         */
           if (Lev % 2 == 0)                        /* left or right lab    */
           {                                        /* BEG LEFT SETS        */
              X = XL + dX;                          /* pos at left axis     */
              J = -1;                               /* and left justify     */
           }                                        /* END LEFT SETS        */
           else                                     /* on the right         */
           {                                        /* BEG RIGHT SETS       */
              X = XR - dX;                          /* pos at right axis    */
              J = 1;                                /* and right justify    */
           }                                        /* END RIGHT SETS       */
         break;                                     /* STOP SPREAD          */
         case 1:                                    /* START MINIMUM        */
           X = XL + dX;                             /* pos at left axis     */
           J = -1;                                  /* and left justify     */
         break;                                     /* STOP MINIMUM         */
         case 2:                                    /* START CENTER         */
           X = 0.5 * InFo.RtX + dX;                 /* pos at center axis   */
           J = 0;                                   /* and center justify   */
         break;                                     /* STOP CENTER          */
         case 3:                                    /* START MAXIMUM        */
           X = XR + dX;                             /* pos at right axis    */
           J = 1;                                   /* and right justify    */
         break;                                     /* STOP MAXIMUM         */
      }                                             /* END LAB POS SWITCH   */

      chr_dspl (1, X, Y, 0., R, 0., 0., 0, J, c1, -1, C);
   }                                                /* BEG LAB OUTPUT LOOP  */

   window (1, "MAINLABEL");
   chr_size (10);             
   get_chsz (Sz);
   X = InFo.RtX + 1 - 1.5 * Sz[0];
   if (InFo.TimeStamp)
   {
      time(&tloc);
      c1 = ctime(&tloc);

      C = strlen(c1) -1;
      if (c1[C] == '\n')
          c1[C] = 0;

      dY = (InFo.DefMenu == 1) ? 2.75 : 1.5;
      Y = dY * Sz[1];
      chr_dspl (1, X, Y, 0., 0., 90., 0., 0, 1, c1, -1, parm.white);
   }

   if (InFo.DefMenu)
   {
      Y = 1.5 * Sz[1];
      chr_dspl (1, X, Y, 0., 0., 90., 0., 0, 1, DFName, -1, parm.white);
   }
}

