#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void IncTm (struct TiMiNg *Tb, struct TiMiNg *Te, ByTe_4 dT, ByTe_1 Base, 
   ByTe_1 SetEnd)
{

   extern struct UserDefs InFo;

   ByTe_4 Y;
   ByTe_1 Go;

   if (Base != 9)
   {
      if (SetEnd == 1)                            /* Set End from beg        */
      {                                           /* BEG INITIALIZE END      */
         Te->Yr = Tb->Yr;                         /* end is beg year         */
         Te->Dy = Tb->Dy;                         /* day is beg day          */
         Te->Ms = Tb->Ms;                         /* msec is beg msec        */
         Te->Ns = Tb->Ns;                         /* nsec is beg nsec        */
      }                                           /* END INITIALIZE END      */
      else                                        /* next plot time          */
      {                                           /* BEG SET BEG TO END      */
         Tb->Yr = Te->Yr;                         /* end is beg year         */
         Tb->Dy = Te->Dy;                         /* day is beg day          */
         Tb->Ms = Te->Ms;                         /* msec is beg msec        */
         Tb->Ns = Te->Ns;                         /* nsec is beg nsec        */
      }                                           /* END SET BEG TO END      */
   }

   switch (Base)                                  /* switch on units         */
   {                                              /* BEG UNITS SWITCH        */
      case 0:                                     /* START YEARS             */
         Te->Dy += dT;                            /* inc days                */
      break;                                      /* STOP YEARS              */
      case 4:                                     /* START SECONDS           */
         Te->Dy += dT/86400;                      /* inc days                */
         Te->Ms += (dT % 86400) * 1000;           /* increment msec          */
      break;                                      /* STOP HOURS              */
      case 5:                                     /* START MINUTES           */
         Te->Ms += dT;                            /* inc msec                */
      break;                                      /* STOP MINUTES            */
      case 9:                                     /* START MINUTES           */
         Tb->Yr = -1;                             /* end is beg year         */
         Te->Yr = InFo.TE.Yr;                     /* end is beg year         */
         Te->Dy = InFo.TE.Dy;                     /* day is beg day          */
         Te->Ms = InFo.TE.Ms;                     /* msec is beg msec        */
         Te->Ns = InFo.TE.Ns;                     /* nsec is beg nsec        */
      break;                                      /* STOP MINUTES            */
   }                                              /* END UNITS SWITCH        */

   if (Te->Ms > 86400000)                         /* roll over msec?         */
   {                                              /* BEG ROLL MSEC           */
      Te->Dy += Te->Ms/86400000;                  /* inc days                */
      Te->Ms = Te->Ms % 86400000;                 /* remaining msec          */
   }                                              /* END ROLL MSEC           */

   Go = 1;
   while (Te->Dy > 365 && Go)                     /* while too many days     */
   {                                              /* BEG ROLL DAYS           */
      Y = LeaP(Te->Yr);                           /* 1 year in days          */
      if (Y < Te->Dy)                             /* had enough days?        */
      {                                           /* BEG INC YEAR            */
         ++Te->Yr;                                /* increment end year      */
         Te->Dy -= Y;                             /* decrement days          */
      }                                           /* BEG INC YEAR            */
      else                                        /* check leap-no-leap      */
         if (Te->Dy > 365)                        /* under a leap year       */
            Go = 0;                               /* terminate while         */
   }                                              /* BEG COUNT YR LOOP       */
}
