#include <math.h>
#include <stdlib.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void GetBin (ByTe_4 N, ByTe_1 Axis, ReaL_4 D1, ByTe_4 *Bn, ReaL_4 *Fb, 
             ByTe_1 L)
{
   extern struct UserDefs InFo;

   struct PlotDef *Pd;
   struct Binning *B;

   ReaL_8 dV, Bin;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;         /* plot info struct     */

   B = (Axis < 4) ? &Pd->Bx : (Axis < 6) ? &Pd->Byl : &Pd->Byr;  

   if (B->Sca == 1)                                  /* log binning          */
   {                                                 /* BEG TAKE LOG OF DATA */
      if (D1 <= 0.0)                                 /* illegal data?        */
      {                                              /* BEG ILLEGAL DATA     */
         *Bn = -3;                                   /* bin out of bounds    */
         *Fb = -1.0;                                 /* frac bin out of bnds */
         return;                                     /* outta here           */
      }                                              /* END ILLEGAL DATA     */
      D1 = log(D1);                                  /* log of start         */
   }                                                 /* END TAKE LOG OF DATA */

   dV = D1 - B->Start;                               /* dis from first bin   */

   Bin = dV / B->R;                                  /* float pixel number   */
   if (Bin < 0.0)                                    /* bad bin?             */
   {                                                 /* BEG VALS TO DEFAULT  */
      *Bn = -1;                                      /* bin to -1            */
      *Fb = 0.0;                                     /* no frac              */
   }                                                 /* END VALS TO DEFAULT  */
   else                                              /* time outside rng     */
   {                                                 /* BEG VALID BIN        */
      *Bn = (ByTe_4)Bin;                             /* int pixel number     */
      if (B->Dir == 1)                               /* increasing values    */
         *Fb = (L == 0) ? 1.0 - Bin + *Bn : Bin - *Bn;
      else                                           /* must be decreasing   */
         *Fb = (L == 0) ? Bin - *Bn : 1.0 - Bin + *Bn;
   }                                                 /* END VALID BIN        */
}
