#include <stdlib.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void FormPlots (void)
{
   extern struct UserDefs InFo;

   register struct PlotDef *Pd, *PdEnd, *Pe;
   register ReaL_4 *Rx, *Ry, *Tg;

   struct CutDef *cDc, *cDs;

   void *TmPMem;
   ReaL_4 R, dX, dY, Px = 1.0, Py = 0.0; 
   ReaL_4 dPy, dPx, rX, rY, cS[2];
   ReaL_4 LenX, LenY;
   ReaL_4 eX, eY;
   ReaL_4 effXl, effXr, effYt, effYb;
   ReaL_4 Xe = 0.0, Ye = 0.0;
   ReaL_4 Xleft, Ytop;
   ReaL_4 Xs, Ys, Xt;
   ReaL_4 ExTra;
   ReaL_4 BCutSp = 0.0, RCutSp = 0.0;
   ReaL_4 TotdY = 0.0;

   size_t Bytes;
   ByTe_4 TmP, Nr = 0, Nc = -1, Ncp = 0, dR, dC, Rows;
   ByTe_1 pN = 4;
   ByTe_1 wN = 4;
   ByTe_1 BCut = 0, RCut = 0;

   window (2, "FORMPLOTS");
   chr_size (15);
   get_chsz(cS);

   InFo.NumP = 0;
   Pd = (struct PlotDef *)InFo.PlotDefs;             /* plot info structs    */
   Pe = Pd + 1;                                      /* next plot info struc */
   PdEnd = Pd + InFo.NPDefs;                         /* end of plot infos    */

   Bytes = 3 * InFo.NPDefs * sizeof(ReaL_4); 
   if ((TmPMem = malloc(Bytes)) == 0)
       exit (-2);

   Rx = (ReaL_4 *)TmPMem;                            /* pntr to X ratios     */
   Ry = Rx + InFo.NPDefs;                            /* pntr to Y ratios     */
   Tg = Ry + InFo.NPDefs;                            /* pntr to total gaps   */

   *Tg = Pd->P.dYPd;
   for ( ; Pe < PdEnd; ++Pd, ++Pe)                   /* loop over plots defs */
   {
      *Tg++ += Pe->P.dYPd / 2.0;
      *Tg = Pe->P.dYPd / 2.0;
      Pe->P.dYPd /= 2.0;
   }
  
   Tg = Ry + InFo.NPDefs;                            /* pntr to total gaps   */

   Pd = (struct PlotDef *)InFo.PlotDefs;             /* plot info structs    */
   PdEnd = Pd + InFo.NPDefs;                         /* end of plot infos    */
   for (; Pd < PdEnd; ++Pd, ++Rx, ++Ry, ++Tg)        /* plots defs loop      */
   {                                                 /* BEG PLOT DEF LOOP    */
      if (Pd->CCut != 0) {                           /* Contour Cut Plot     */ 
         cDc = (struct CutDef *) Pd->CCut;
         if (cDc->CutPlot > 0) {
            if (cDc->CutPlace == 0) {
               BCut = 1;
               BCutSp = cDc->CutSpace;
            } else {
               RCutSp = cDc->CutSpace;
               RCut = 1;
            }
         }
      }
      if (Pd->LSCut != 0) {                          /* LShell Cut Plot      */ 
         cDs = (struct CutDef *) Pd->LSCut;
         if (cDs->CutPlot > 0) {
            if (cDs->CutPlace == 0) {
               BCut = 1;
               BCutSp = cDs->CutSpace;
            } else {
               RCutSp = cDs->CutSpace;
               RCut = 1;
            }
         }
      }

      Pd->P.ToPdY = InFo.DupYb * cS[1] / InFo.SqY;
      Rows = Pd->Rows * InFo.Dups;
      dC = (Pd->Cols > 1) ? Pd->Cols - 1 : 1;
      dR = (Rows > 1) ? Rows - 1 : 1;
      Pd->P.dXp *= (Pd->Cols == 1) ? 0.0 : dC * cS[0] / InFo.SqX;
      Pd->P.dYp *= (Rows == 1) ? 0.0 : dR * cS[1] / InFo.SqY;
      Pd->P.dYPd *= cS[1] / InFo.SqY;
      *Tg *= cS[1] / InFo.SqY;

      InFo.NumP += Rows * Pd->Cols;                  /* total # of plots     */
      Nr += Rows;                                    /* total rows of plots  */
      if (Pd->Cols > Nc)                             /* max columns defined? */
         Nc = Pd->Cols;                              /* record it here       */

      if (Pd->PAxes == 1)                            /* needs square plot    */
      {                                              /* BEG SQUARE DELTAS    */
          dX = 1.0;                                  /* X side is unit len   */
          dY = 1.0;                                  /* so is the Y side     */
      }                                              /* END SQUARE DELTAS    */
      else                                           /* not square           */
      {                                              /* BEG NOT SQUARE       */
         if (Pd->PAxes == 2)                         /* ratio by axes        */
         {                                           /* BEG PLOT DELTAS      */
            dX = Pd->Xb.Max - Pd->Xb.Min;            /* range in X           */
            if (dX < 0)
               dX = -dX;
            dY = Pd->Yl.Max - Pd->Yl.Min;            /* range in Y           */
            if (dY < 0)
               dY = -dY;
         }                                           /* END PLOT DELTAS      */
         else                                        /* pack 'em close       */
         {                                           /* BEG CLOSEST PACKING  */
            dX = -1.0;                               /* dummy range in X     */
            dY = 1.0;                                /* dummy range in Y     */
            Ncp += Rows;                             /* incr close pack cnt  */
         }                                           /* END CLOSEST PACKING  */
      }                                              /* END PLOT FMT SWITCH  */

      /*  COMPUTE EXTRA SPACE NEEDED OVER AND ABOVE THE PLOT SPACE           */

      eX = (RCut) ? Pd->P.dXp/dC + RCutSp : Pd->P.dXp/dR;
      eY = *Tg / dR;
      eY += (BCut) ? Pd->P.dYp/dC + BCutSp : Pd->P.dYp/dR;

      dX *= (1.0 + eX);                              /* total X pixels       */
      dY *= (1.0 + eY);                              /* total Y pixels       */
      *Rx = dX/dY;                                   /* ratio of X-Y ranges  */
      *Ry = dY/dX;                                   /* ratio of Y-X ranges  */

      if (dX < 0.0)                                  /* arbitrary scaling    */
      {                                              /* BEG ARBITARY SIZE    */
         *Rx = 1;                                    /* set dX/dY to one     */
         *Ry = 1;                                    /* set dY/dX to one     */
         Py += Rows;                                 /* only count rows      */
      }                                              /* END ARBITARY SIZE    */
      else                                           /* specific size plot   */
      {                                              /* BEG FIXED XY RATIO   */
         if (*Ry > 1.0)                              /* is Y range largest?  */
            *Rx = 1.0;                               /* set X-Y ratio to 1   */
         else                                        /* X range is largest   */
            *Ry = 1.0;                               /* set Y-X ratio to 1   */

         Py += *Ry * Rows;                           /* total rel Y range    */
         Xt = *Rx * Pd->Cols;                        /* total rel X range    */
         if (Xt > Px)                                /* biggest X extent?    */
            Px = Xt;                                 /* if so then save it   */
      }                                              /* END FIXED XY RATIO   */
   }                                                 /* END PLOT DEF LOOP    */

   InFo.Cols = Nc;                                   /* total columns        */
   InFo.Rows = Nr;                                   /* total rows           */

   LenX = InFo.SqX;
   LenY = InFo.SqY;

   Pd = (struct PlotDef *)InFo.PlotDefs;             /* plot info structs    */
   if (InFo.RtX > InFo.SqX)                          /* extra pixels in X    */ 
   {                                                 /* BEG USEABLE X        */
      dX = (InFo.RtX - InFo.SqX) / 2;                /* extra left/right pix */
      ExTra = LenX * InFo.Xl - dX;                   /* extra pixels         */
      effXl = (ExTra <= 0.0) ? 0.0 : ExTra / LenX;   /* left gap needed      */
      ExTra = LenX * InFo.Xr - dX;                   /* extra pixels         */
      effXr = (ExTra <= 0.0) ? 0.0 : ExTra / LenX;   /* left gap needed      */
      effYt = InFo.Yt;                               /* effective Y top      */
      effYb = InFo.Yb;                               /* effective Y bottom   */
   }                                                 /* BEG USEABLE X        */
   else                                              /* Y is larger          */
   {                                                 /* BEG USEABLE Y        */
      dY = (InFo.RtY - InFo.SqY) / 2;                /* extra left/right pix */
      ExTra = LenY * InFo.Yt - dY;                   /* extra pixels         */
      effYt = (ExTra <= 0.0) ? 0.0 : ExTra / LenY;   /* left gap needed      */
      ExTra = LenY * InFo.Yb - dY;                   /* extra pixels         */
      effYb = (ExTra <= 0.0) ? 0.0 : ExTra / LenY;   /* left gap needed      */
      effXr = InFo.Xr;                               /* effective X right    */
      effXl = InFo.Xl;                               /* effective X left     */
   }                                                 /* BEG USEABLE Y        */

   Ytop = Pd->P.ToPdY * (InFo.Dups - 1);             /* Inter Grp Space      */
   Xs = LenX * (1.0 - effXl - effXr);                /* useable X screen len */
   Ys = LenY * (1.0 - effYb - effYt - Ytop);         /* useable Y screen len */

   rX = Xs/Px;                                       /* ratio of X plot lens */
   rY = Ys/Py;                                       /* ratio of Y plot lens */
   R = (rX > rY) ? rY : rX;                          /* correct ratio        */

   if (rX > rY)                                      /* too much X?          */
      Xe = 1.0 - rY * Px / LenX - effXr -effXl;      /* excess X             */ 
   else                                              /* too much Y           */
      Ye = 1.0 - rX * Py / LenY - effYt - effYb;     /* excess Y             */ 

   Pd = (struct PlotDef *)InFo.PlotDefs;             /* plot info structs    */
   PdEnd = Pd + InFo.NPDefs;                         /* end of plot infos    */
   Rx = (ReaL_4 *)TmPMem;                            /* pntr to X ratios     */
   Ry = Rx + InFo.NPDefs;                            /* pntr to Y ratios     */
   Tg = Ry + InFo.NPDefs;                            /* pntr to total gaps   */

   for ( ; Pd < PdEnd; ++Pd, ++Rx, ++Ry, ++Tg)       /* loop over plots defs */
   {                                                 /* BEG PLOT DEF LOOP    */
      if (Pd->PAxes == 0)                            /* closest packing      */
      {                                              /* BEG CLOSE PACKING    */
         Pd->P.dX = Xs/Pd->Cols;                     /* range in X           */
         Pd->P.dY = R * *Ry + (Ye * LenY) / Ncp;     /* range in Y           */
      }                                              /* END CLOSE PACKING    */
      else                                           /* ordered ratio        */
      {                                              /* BEG SPEC RATIOS      */
         Pd->P.dX = R * *Rx;                         /* range in X           */
         Pd->P.dY = R * *Ry;                         /* range in Y           */
      }                                              /* END SPEC RATIOS      */
   }                                                 /* END PLOT DEF LOOP    */

   Xleft = LenX * effXl;                             /* plot left side       */
   if (Ncp > 0)                                      /* spectro or histos?   */
     Ytop = LenY * ( 1.0 - effYt);                   /* absolute plot top    */
   else                                              /* no spectro or histo  */
     Ytop = LenY * ( 1.0 - (effYt + Ye/2.0));        /* absolute plot top    */
   Ytop = (ByTe_4)(Ytop + 0.5);                      /* round to nearest int */

   Pd = (struct PlotDef *)InFo.PlotDefs;             /* plot info structs    */
   PdEnd = Pd + InFo.NPDefs;                         /* end of plot infos    */
   Tg = (ReaL_4 *)TmPMem + 2 * InFo.NPDefs;          /* pntr to X ratios     */
   for ( ; Pd < PdEnd; ++Pd, ++Tg)  {                /* BEG PLOT DEF LOOP    */
      if (Pd->OutFmt == 0) {                         /* BEG PLOT OUTPUT      */
         Pd->Pn = pN++;                              /* plot num for display */
         Pd->Wn = -1;                                /* no window number     */
      } else {                                       /* BEG WINDOW OUTPUT    */
         Pd->Wn = wN++;                              /* win num for display  */
         Pd->Pn = -1;                                /* no plot number       */
      }                                              /* END WINDOW OUTPUT    */

      dPy = Pd->P.dY;                                /* total Y length       */
      dPx = Pd->P.dX;                                /* total X length       */

      if (Pd->CCut != 0) {                           /* BEG CONTOUR CUT      */
         cDc = (struct CutDef *) Pd->CCut;           /* set struct pointer   */
         cDc->CutPn = pN++;                          /* set cut plot number  */
      }                                              /* END CONTOUR CUT      */
      if (Pd->LSCut != 0) {                          /* BEG LSHELL CUT       */
         cDs = (struct CutDef *) Pd->LSCut;          /* set struct pointer   */
         cDs->CutPn = pN++;                          /* set cut plot number  */
      }                                              /* END LSHELL CUT       */

      Pd->P.ToPdY *= LenY;                           /* pixels in Y gap      */
      Pd->P.dXp = LenX * Pd->P.dXp / dC;             /* pixels in X gap      */
      Pd->P.dYp = LenY * Pd->P.dYp / dR;             /* pixels in Y gap      */
      Pd->P.dYPd = LenY * Pd->P.dYPd;                /* pixels in top gap    */
      *Tg = LenY * *Tg;                              /* pixels in top gap    */

      Pd->P.dY = Pd->P.dY * Pd->Rows;                /* all plots Y length   */
      TotdY += (ByTe_4)(Pd->P.dY + .5);              /* all plots Y length   */
      Pd->P.dY -= *Tg;                               /* less top gap         */
      Pd->P.dY -= (Pd->Rows - 1) * Pd->P.dYp;        /* less interplot gaps  */
      Pd->P.dY /= Pd->Rows;                          /* per plot             */

      Pd->P.dX = Pd->P.dX * Pd->Cols;                /* all plots X length   */
      Pd->P.dX -= (Pd->Cols - 1) * Pd->P.dXp;        /* less interplot gaps  */
      Pd->P.dX /= Pd->Cols;                          /* per plot             */

      if (BCut)                                      /* cutplot below        */
          Pd->P.dY /= (1.0 + BCutSp);                /* plot dY              */
      else                                           /* cutplot to right     */
          Pd->P.dX /= (1.0 + RCutSp);                /* plot dX              */
 
      Pd->P.dCr = RCutSp * Pd->P.dX;                 /* right cut length     */
      Pd->P.dCb = BCutSp * Pd->P.dY;                 /* bottom cut length    */
      Pd->P.dX -= Pd->P.dXp;                         /* actual plot length   */

      Pd->P.dY = (ByTe_4)(Pd->P.dY + 0.5);           /* to nearest integer   */
      Pd->P.dX = (ByTe_4)(Pd->P.dX + 0.5);           /* round to nearest int */
      Pd->P.dCr = (ByTe_4)(Pd->P.dCr + 0.5);         /* to nearest integer   */
      Pd->P.dCb = (ByTe_4)(Pd->P.dCb + 0.5);         /* to nearest integer   */
      Pd->P.dXp = (ByTe_4)(Pd->P.dXp + 0.5);         /* to nearest integer   */
      Pd->P.dYp = (ByTe_4)(Pd->P.dYp + 0.5);         /* to nearest integer   */
      Pd->P.dYPd = (ByTe_4)(Pd->P.dYPd + 0.5);       /* to nearest integer   */
      Pd->P.ToPdY = (ByTe_4)(Pd->P.ToPdY + 0.5);     /* to nearest integer   */

      Pd->P.Lx = Xleft + (Xs - dPx * Pd->Cols)/2.0;  /* left edge            */ 
      Pd->P.Lx = (ByTe_4)(Pd->P.Lx + 0.5);           /* round to nearest int */
      Pd->P.Rx = Pd->P.Lx + Pd->P.dX;                /* right side of plot   */
      Pd->P.Uy = Ytop - Pd->P.dYPd;                  /* top of plot          */
      Pd->P.Uy = (ByTe_4)(Pd->P.Uy + 0.5);           /* round to nearest int */
      Pd->P.Ly = Pd->P.Uy - Pd->P.dY;                /* bottom of plot       */ 

      Ytop -= *Tg + Pd->Rows * (Pd->P.dY + Pd->P.dYp) - Pd->P.dYp;

      if (InFo.PXmin > Pd->P.Lx )                    /* new absolute X min?  */
          InFo.PXmin = Pd->P.Lx;                     /* establish new X min  */
      if (InFo.PYmax < Pd->P.Uy)                     /* new absolute Y max?  */
          InFo.PYmax = Pd->P.Uy;                     /* establish new Y max  */

      TmP = Pd->P.Uy - dPy * Pd->Rows;               /* minimum Y            */
      if (InFo.PYmin > TmP )                         /* new absolute Y min?  */
          InFo.PYmin = TmP;                          /* establish new Y min  */
      TmP = Pd->P.Lx + dPx * Pd->Cols;               /* maximum X            */
      if (InFo.PXmax < TmP )                         /* new absolute X max?  */
          InFo.PXmax = TmP;                          /* establish new X max  */
   }

   Pd = (struct PlotDef *)InFo.PlotDefs;             /* plot info structs    */
   PdEnd = Pd + InFo.NPDefs;                         /* end of plot infos    */
   for ( ; Pd < PdEnd; ++Pd)                         /* loop over plots defs */
       Pd->P.AbsLy = TotdY;     

   free (TmPMem);

   Pd = (struct PlotDef *)InFo.PlotDefs;             /* plot info structs    */
   for ( ; Pd < PdEnd; ++Pd ) {                     /* loop over plots defs */
      Bytes = 2 * Pd->Rows * Pd->Cols * sizeof(struct TiMiNg); 
      if ((Pd->Times = malloc(Bytes)) == 0)
          exit (-2);
   }
}
