#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "libCfg.h"

#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void FetchAlt (ByTe_4 PN, ByTe_4 SrcN)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct SrcInfo *S, *Sc;
   struct idf_data  *ExDa;

   ReaL_4 *f1, *f2, *fEnD;
   ByTe_4 *l1, *lEnD, up = 0, down = 0, bP, I;
   ByTe_2 *Ss, R;
   ByTe_1 *Cs;
   ByTe_1 *X = "";
   ByTe_1 GetIndex = 0;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;
   S = (struct SrcInfo *)Pd->Src + SrcN;

   Cs = (ByTe_1 *)Wa.CStore;
   Ss = (ByTe_2 *)Wa.SStore;
   ExDa = (struct idf_data *) InFo.UDF;

   if (S->SAltUN >= 0) {
      GetIndex = 1;
      f1 = (ReaL_4 *)S->Alt + 4 * S->DLen;
      R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, ANCILLARY, 
                           (ByTe_1)S->SAltVN, S->SAltNAS, Cs + S->SAltTbls,
                           Ss + S->SAltOps, f1, 0, 0L);
      ErrorRpt ("CONVERT_TO_UNITS", R, 1);
   }

   if (S->AltUN >= 0) {
      GetIndex = 1;
      f1 = (ReaL_4 *)S->Alt;
      R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, SCAN_INDEX, 0, 
                            S->AltNAS, Cs + S->AltTbls, Ss + S->AltOps, 
                            f1, 0, 0L);
      ErrorRpt ("CONVERT_TO_UNITS", R, 1);

      if (S->AltSca == 'V') {
         f1 = (ReaL_4 *)S->Alt + 2 * S->DLen;
         R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, SCAN_INDEX, 0, 
                               S->SecNAS, Cs + S->SecTbls, Ss + S->SecOps, 
                               f1, 0, 0L);
         ErrorRpt ("CONVERT_TO_UNITS", R, 1);
      }

      if (ExDa->hdr_change) {
         Sc = (struct SrcInfo *)Pd->Src;
         for (I=0; I < Pd->EmptySrc; ++I, ++Sc) {
            if (Sc->Key == S->Key) { Sc->Col.NewHdr = 1; }
         }
      }

      if (S->Col.NewHdr) {
          S->Col.NewHdr = 0;
          f1 = S->Alt;
          f2  = f1 + 1;
          fEnD  = f1 + S->DLen - 1;

          for ( ; f2 <= fEnD; ++f1, ++f2) {
             if (*f1 != *f2) {
                if ((*f1 - *f2) > 0 ) {
                   ++down;
                } else { ++up; }
             }
          }

          S->Col.SType = ((up == 0) && (down == 0)) ? 0 : 
                         ((up > 0)  && (down > 1)) ? 1 : 2; 

          bP = S->DLen + 100;
          if (S->Col.SType ==1) {
             f1 = S->Alt;
             f2  = f1 + 1;
             fEnD  = f1 + S->DLen - 1;

             I = 0;
             if ((*f1 - *f2) > 0 ) {
                for ( ; f2 <= fEnD; ++f1, ++f2, ++I) {
                   if ((*f1 - *f2) > 0.0 ) { bP = I; }
                }
             } else { 
                for ( ; f2 <= fEnD; ++f1, ++f2, ++I) {
                   if ((*f1 - *f2) < 0.0 ) { bP = I; }
                }
             }
          }

          GiveEdges ((ReaL_4 *)S->Alt, (ReaL_4 *)0, (ReaL_4 *)S->Bins, 
                       S->DLen, --bP, S->Col.Sca, 'N');
      }
   }

   if (GetIndex) {
        S->DLen  = ExDa->num_sample;
        f1 = (ReaL_4 *)S->Alt + S->DLen;
        l1 = ExDa->swp_data;
        lEnD = l1 + S->DLen;
        for ( ; l1 < lEnD; )
           *f1++ = *l1++; 
   }
}
