#include <stdio.h>
#include <string.h>
#include <math.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "gph_shortcut_defs.h"

ReaL_4 Minors[24] =  {  0.1,  0.2,  0.25,  0.5,  
                        1.0,  2.0,  4.0,   6.0,   8.0,  12.0,
                        1.0,  2.0,  5.0,  10.0,  15.0,  20.0,  30.0,
                        10.0, 25.0, 50.0, 100.0, 200.0, 250.0, 500.0};
ByTe_2 MBeg[8] = { 0,  4, 10, 10, 17, 17, 17, 17};
ByTe_2 MEnd[8] = { 4, 10, 17, 17, 24, 24, 24, 24};
ByTe_2 UConV[8] = { 1, 24, 60, 60, 1000, 1, 1, 1};
ByTe_2 MnBig[5] = { 10, 5, 4, 3, 2};
ByTe_1 *Unit[8] = {"Year", "Day", "Hr", "Min", "Sec", "MSec", "USec", "NSec"};
ByTe_1 *UFmt[8] = {"%4d", "%03d", "%02d", "%02d", "%02d", "%03d", 
                   "%03d", "%03d"};

void DrTmTicks (ByTe_4 PN, ByTe_1 pn, ByTe_1 DoNums, ByTe_4 *T)
{
   extern struct UserDefs InFo;
   extern struct config parm;

   struct PlotDef *Pd;
   struct TiMiNg  Tm;
   struct window  *wN;
   struct AxisInfo *Axb;
   
   register ReaL_4 *f1, *fEnD;
   register ByTe_2 *s1, *sEnD;

   ReaL_4 dMn, Xf, Ax, Ay, Xpos, Ypos, Sz[2];
   ReaL_4 TMin, TMax;
   ByTe_4 I, X;
   ByTe_4 dT, dMj, LTm[8];
   ByTe_4 Min, Rmd, NMnTics, NextMj;
   ByTe_2 S, NLabs, W, BaseTm, BestMj, P, Ax1, Ax2;
   ByTe_1 NoSolution, Lab[40], Lab2[40], Tf, Sep[2];
   ByTe_1 TSca = -1;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;      /* the plot def struct    */
   Axb = &Pd->Xb;                                  /* Bot X axis             */
   W = parm.white;                                 /* all labels in white    */
   Sep[1] = 0;                                     /* separator terminator   */
   
   for (I = 0; I < 8; ++I)                         /* loop over time diffs   */
   {                                               /* BEG BASE SEARCH LOOP   */
       if (T[I] > 1)                               /* got a time diff        */
       {                                           /* BEG SET BASE VALS      */
          dT = T[I];                               /* this is time diff      */
          BaseTm = I;                              /* this is time base      */
          break;                                   /* quit search            */
       }                                           /* END SET BASE VALS      */
   }                                               /* END BASE SEARCH LOOP   */

   Min = 1000000;                                  /* dummy minimum value    */
   for (I = 2; I < 5; ++I)                         /* num mj tick search     */
   {                                               /* BEG BEST MJ TIC LOOP   */
       Rmd = dT % I;                               /* left over range        */ 
       if (Rmd <= Min)                             /* minimize left over     */
       {                                           /* BEG FOUND MIN          */
          BestMj = I;                              /* best is minimum        */
          Min = Rmd;                               /* reset minimum          */
       }                                           /* END FOUND MIN          */
   }                                               /* END BEST MJ TIC LOOP   */

   dMj = dT/BestMj;                                /* delta Tm between Mjs   */

   f1 = Minors + MBeg[BaseTm];                     /* beg of minor tick vals */
   fEnD = Minors + MEnd[BaseTm];                   /* end of minor tick vals */
   dT = dMj * UConV[BaseTm];                       /* time base for mn ticks */

   dMn = -1.0;                                     /* init best minor diff   */
   for (; f1 < fEnD; ++f1)                         /* loop over minor ticks  */
   {                                               /* BEG MINOR TICK LOOP    */
      NMnTics = (dT / *f1) * (BestMj + 1);         /* proj max ticks along X */
      if (NMnTics < 40)                            /* use anything < 40 tics */
      {                                            /* BEG LESS THAN 40 TICKS */
         dMn = (BaseTm == 0) ? *f1 * 365.0 : *f1;  /* best minor tick sep    */
         NLabs = 2;                                /* requires two labels    */
         break;                                    /* got it and done        */
      }                                            /* END LESS THAN 40 TICKS */
   }                                               /* END MINOR TICK LOOP    */
  
   if (dMn < 0.0)                                  /* found no value         */
   {                                               /* BEG 2ND TRY MINOR SEP  */
      if (dT < 30.0)                               /* can we tick all?       */
      {                                            /* BEG TICK ALL           */
         NoSolution = 0;                           /* set solution found     */
         dMn = 1;
      }                                            /* END TICK ALL           */

      NoSolution = 1;                              /* no initial solution    */
      while (NoSolution)                           /* best minor sep search  */
      {                                            /* BEG SOLUTION SEARCH    */
          sEnD = MnBig + 5;                        /* end of mn tick array   */
          for (s1 = MnBig; s1 < sEnD; ++s1)        /* loop over minor ticks  */
          {                                        /* BEG MINOR TICK LOOP    */
             if ((dMj % *s1) == 0)                 /* even ticks is solution */
             {                                     /* BEG FOUND SOLUTION     */
                dMn = dMj / *s1;                   /* this is minor tick sep */
                NoSolution = 0;                    /* solution               */
                break;                             /* got it and done        */
             }                                     /* END FOUND SOLUTION     */
          }                                        /* END MINOR TICK LOOP    */

          if (NoSolution)                          /* still no solution?     */
             --dMj;                                /* decrement mj sep       */
      }                                            /* END SOLUTION SEARCH    */
      NLabs = 1;                                   /* requires only 1 label  */
      dMn *= UConV[BaseTm];                        /* same mj and mn units   */
   }                                               /* BEG 2ND TRY MINOR SEP  */

   if (BaseTm > 0 && T[BaseTm - 1] > 0)            /* need leading unit      */
   {                                               /* BEG EXTRA LABEL LOCS   */
      P = BaseTm - 1;                              /* time position          */
      NLabs = 2;                                   /* put in two labels      */
   }                                               /* BEG EXTRA LABEL LOCS   */
   else                                            /* take what we computed  */
      P = BaseTm;                                  /* begin at previous time */

   Sep[0] = (P >= 4) ? '.' : (P < 2) ? ' ' : ':';  /* time elem separator    */
   Tm.Yr = Pd->Pb.Yr;                              /* plot starts this Year  */
   Tm.Dy = Pd->Pb.Dy;                              /* plot starts this Day   */
   Tm.Ms = Pd->Pb.Ms;                              /* plot starts this Msec  */
   Tm.Ns = Pd->Pb.Ns;                              /* plot starts this Nsec  */
   Tf = BegTmTick (BaseTm, &NextMj, dMj, dMn, &Tm);  /* time of 1st tick     */
   GetPiXeL (PN, &Tm, 0, 0, &X, &Xf);              /* Pixel of first tick    */
   while (X < Pd->Xb.Max)                          /* ouput time ticks       */
   {                                               /* BEG TIME TICK LOOP     */
      dr_tic(pn, 0, Tf, (ReaL_4)X);                /* show ticks on lower X  */
      dr_tic(pn, 2, Tf, (ReaL_4)X);                /* show ticks on upper X  */
      if (Tf == 2 && DoNums > 0)                   /* this is a major tick   */
      {                                            /* BEG ANNOTATION         */
         TmBrkOut (&Tm, LTm);                      /* brk out time comps     */ 

         sprintf (Lab, UFmt[P], LTm[P]);           /* 1st time label         */
         if (NLabs == 2)                           /* need second?           */
         {                                         /* BEG ADD SECOND         */
            strcat (Lab, Sep);                     /* add separator          */
            sprintf (Lab2, UFmt[P+1], LTm[P+1]);   /* 2nd time label         */
            strcat (Lab, Lab2);                    /* join labels            */
         }
         num_lab (pn, 0, (ReaL_4)X, 0, Lab, "", 0, 1, 0., 0., W);
      }                                            /* END ANNOTATION         */
      Tf = AdvTickTm (BaseTm, dMj, &NextMj, dMn, &Tm);   /* tm of next tick  */
      GetPiXeL (PN, &Tm, 0, 0, &X, &Xf);           /* Pixel of first tick    */
   }                                               /* END TIME TICK LOOP     */

   if (DoNums > 0)                                   /* can label bot X?     */
   {                                                 /* BEG BOT X LABEL      */
      if (DoNums == 2)                               /* put up side time     */
      {                                              /* BEG SIDE TIME        */
         if (parm.ostyle == 0)                         /* landscape output   */
         {                                             /* BEG LANDSCAPE      */
            Ax1 = 0;                                   /* left X             */
            Ax2 = 3;                                   /* right X            */
         }                                             /* END LANDSCAPE      */
         else                                          /* portrait           */
         {                                             /* BEG PORTRAIT       */
            Ax2 = 0;                                   /* left X             */
            Ax1 = 3;                                   /* right X            */
         }                                             /* END PORTRAIT       */

         if (Pd->Li[0].Fmt < 0)                      /* default label?       */
         {                                           /* BEGIN DEFAULT LABEL  */
            wN = parm.win;                           /* pointer to window    */
            if (wN->axis[1] == 1)                    /* log scaled axis      */
            {                                        /* BEG SAVES            */
               TSca = wN->axis[1];                   /* save scale           */
               TMin = wN->plot[1];                   /* save min Y           */
               TMax = wN->plot[4];                   /* save max Y           */
               wN->axis[1] = 0;                      /* set scale            */
               wN->plot[1] = 0.0;                    /* set min Y            */
               wN->plot[4] = 1.0;                    /* set max Y            */
               scale_win(0);                         /* rescale              */
            }                                        /* BEG SAVES            */

            S = 0;                                   /* zero out counter     */
            Ax = parm.win->plot[Ax1];                /* lower X axis         */
            Ay = parm.win->plot[1];                  /* lower Y axis         */
            chr_size (Pd->Xb.NumSize);               /* set char size        */
            get_chsz(Sz);                            /* get character size   */
            Xpos = Ax - 4.5 * Sz[0];                 /* 4 spaces from axis   */ 
            Xf = Sz[1] * (.5 + Pd->Xb.NumOffset);    /* loc of num text      */
            sprintf (Lab2, UFmt[S], LTm[S]);         /* initial time label   */
            Lab[0] = 0;                              /* zero out label       */
            while (S < P && S < 2)                   /* unlabel time loop    */
            {                                        /* BEG UNLABELED TIME   */
               ++S;                                  /* advance counter      */
               strcat (Lab, Lab2);                   /* add time comp        */
               if (S < P && S < 2)                   /* if first of 2        */
               {                                     /* BEG NOT LAST VALUE   */
                  Sep[0] = ' ';                      /* separator            */
                  strcat (Lab, Sep);                 /* add separator        */
               }                                     /* END NOT LAST VALUE   */
               sprintf (Lab2, UFmt[S], LTm[S]);      /* next time label      */
            }                                        /* END UNLABELED TIME   */
            Ypos = (S < P) ? Ay - Xf - 1.25 * Sz[1] : Ay - Xf; 
            RTEXT(Pd->Wn, Xpos, Ypos, Lab, W);       /* spit out label       */
            sprintf (Lab2, UFmt[S], LTm[S]);         /* initial time label   */
            Lab[0] = 0;                              /* zero out label       */
            while (S < P)                            /* unlabel time loop    */
            {                                        /* BEG UNLABELED TIME   */
               strcat (Lab, Lab2);                   /* add time comp        */
               ++S;                                  /* advance counter      */
               if (S < P && S < 6)                   /* more to follow       */
               {                                     /* BEG ADD SEPARATOR    */
                  Sep[0] = (S < 5) ? ':' : '.';      /* separator            */
                  strcat (Lab, Sep);                 /* add separator        */
               }                                     /* END ADD SEPARATOR    */
               sprintf (Lab2, UFmt[S], LTm[S]);      /* next time label      */
            }                                        /* END UNLABELED TIME   */
            Ypos = Ay - Xf;
            RTEXT(Pd->Wn, Xpos, Ypos, Lab, W);       /* spit out label       */
   
            if (TSca >= 0)                           /* did rescale          */
            {                                        /* BEG RESETS           */
               wN->axis[1] = TSca;                   /* set scale            */
               wN->plot[1] = TMin;                   /* set min Y            */
               wN->plot[4] = TMax;                   /* set max Y            */
               scale_win(0);                         /* rescale              */
            }                                        /* END RESETS           */
         }                                           /* BEGIN DEFAULT LABEL  */
      }                                              /* BEG SIDE TIME        */

      if (Axb->DoLabs == 1)                          /* need unit label      */
      {                                              /* BEG UNIT LABEL       */
         lab_size (pn, Pd->Xb.LabSize);                 /* text label size   */
         lab_offset (pn, Pd->Xb.LabOffset);             /* text lab offsets  */
         lab_spacing (pn, Pd->Xb.LabSpace);             /* text lab spacings */
         Xpos = (Pd->Cols % 2 == 0) ? Pd->Xb.Min : centertxt (pn, 0);
         sprintf (Lab, "Universal Time  ");             /* beg time label    */
         if (NLabs == 1)                                /* need second?      */
            sprintf (Lab2, "[%s]", Unit[P]);            /* beg units label   */
         else
            sprintf (Lab2, "[%s%s%s]", Unit[P],Sep, Unit[P+1]);
         
         if (Pd->XLabStyle == 0)
         {
            strcat (Lab, Lab2);                         /* join labels       */
            text_lab(pn, 0, Xpos, 0, Lab, 0, 0, 1, 0., 0., W); 
         }
         else
         {
            text_lab(pn, 0, Xpos, 0, Lab, 0, 0, 1, 0., 0., W);
            text_lab(pn, 0, Xpos, 1, Lab2, 0, 0, 1, 0., 0., W);
         }
      }                                              /* END UNIT LABEL       */

   }                                                 /* END BOT X LABEL      */
}
