/*****************************************************************************/
/*  This routine takes the given sweep units description label and tries to  */
/*  construct a new data units description label indicating that the         */
/*  quantity has been integrated over.  Note that if any form of the word    */
/*  differential heads the original label it is stripped off.                */
/*                                                                           */
/*  The input array *fmt has the following definitions for its elements      */
/*                                                                           */
/*     fmt[0] - if 0 then word integral is preappended to new label          */
/*     fmt[0] - if 1 then word intg is preappended to new label              */
/*     fmt[1] - if -1 routine will guess at integral label format            */
/*     fmt[1] - if 0 only 1st letter in preappended word is caps             */
/*     fmt[1] - if 1 preappended word is all caps                            */
/*     fmt[1] - if 2 preappended word all lower case                         */
/*                                                                           */
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Util1Ansi.h"

#define NLAB 7

ByTe_1 *DF_V[NLAB] = {"DIF", "DIFF", "DIFFERENTIAL", "DF", "DF.", 
                      "DIF.", "DIFF."};
ByTe_1 *IN_T[6] = {"Integral", "Intg", "INTEGRAL", "INTG", "integral", "intg"};

static ByTe_1 rcsid[] = "$Id: int_label.c,v 1.1 1999/11/11 10:15:20 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 int_label (ByTe_1 *unit_lab, ByTe_1 *fmt, ByTe_1 *new_label)
{
   register ByTe_1 *c1, *c2, *c3, *c4, *c5, *c6; 

   ByTe_4  j, offset;

   ByTe_4  ucase_1 = 0, lcase_1 = 0; 
   ByTe_4  ucase_w = 0, lcase_w = 0;
   ByTe_4  lead_c = 0;

   ByTe_1  del = 0;
   ByTe_1  new = 1;
   ByTe_1  FMT;

   void  *Tstr;
   void  *ZP;

   Tstr = 0;                                      /* init ucase string ptr   */
   ZP = 0;                                        /* init bad ptr variable   */

   /**************************************************************************/
   /*  Units Label is converted to uppercase first                           */
   /**************************************************************************/

   if ((Tstr = Ucase (unit_lab, "")) > ZP)        /* convert new_unit to UC  */
      c2 = (ByTe_1 *)Tstr;                        /* ptr to ucase sweep lab  */
   else
      return (-1);                                /* return error            */

   /**************************************************************************/
   /*  Look for word differential and any of its forms as leading word in    */
   /*  units label.  First skip all leading blanks.  Note that the upper     */
   /*  case and original units label are kept in sync at all times.          */
   /**************************************************************************/

    c4 = unit_lab;                                /* pnter to unit_lab       */
    while (*c2 != 0 && *c2 == ' ')                /* loop till NULL          */
    {
      ++c2;                                       /* advance ucase label ptr */
      ++c4;                                       /* advance label pntr      */
    }

   if (*c2 == 'D')                                /* poss differntial lab?   */
   {                                              /* maybe ..                */
      c5 = c2;                                    /* beg match ucase lab     */
      c6 = c4;                                    /* beg match in unit_lab   */
      j = 0;                                      /* first differential lab  */
      while (j < NLAB && !del)                    /* loop over differ labs   */
      {
         c2 = c5;                                 /* reset ucase lab pointer */
         c3 = DF_V[j++];                          /* ptr to scan unit label  */
         c4 = c6;                                 /* reset unit_lab pointer  */
         while ((*c2 == *c3) && (*c3 != 0))       /* loop till lab different */
         {
            ++c2;                                 /* inc ucase unit label    */
            ++c3;                                 /* inc differential var    */
            ++c4;                                 /* inc unit label          */
         }
 
         if (*c3 == 0 && *c2 == ' ')              /* differential wd found?  */
         {                                        /* yes!                    */
            del = 1;                              /* differential deleted    */
            while (*c4 != 0 && *c4 == ' ')        /* loop till next wd       */
               ++c4;                              /* skip over space         */
         }
      }
   }
   else
      c6 = c4;                                    /* beg match in unit_lab   */
         
   c2 = (del) ? c4 : c6;                          /* set ptr to unit_lab     */

   /**************************************************************************/
   /* At this point, if we have to guess at the format of the preappended    */
   /* word "integral" to the units label - we can, using the position in the */
   /* variable unit_lab where the label to be saved begins                   */ 
   /**************************************************************************/

   FMT = fmt[1];                                  /* save label fmt          */ 

   if (fmt[1] < 0)                                /* routine gess lab fmt?   */
   {
      c4 = c2;                                    /* pointer to old label    */

      if (*c4 >= 'A' && *c4 <= 'Z')               /* beg let, 1st wd ucase?  */
      {
         ucase_1 = 1;                             /* yes - 1 ucase wd        */
         lead_c = 1;                              /* leading word is ucase   */
      }
      else
         lcase_1 = 1;                             /* no - 1 lcase wd         */

      while (*(++c4) != 0)                        /* loop over old label     */
      {
         if (*c4 == ' ' || *c4 == '-')            /* beginning of word?      */
            new = 1;                              /* yes - indicate so       */
         else                                     /* not beg of word         */
         {
            if (new)                              /* beginning of word?      */
            {                                     /* yes                     */
               new = 0;                           /* new word reset          */
               if (*c4 >= 'A' && *c4 <= 'Z')      /* beg let, 1st wd ucase?  */
                  ucase_1 += 1;                   /* yes - inc ucase wd      */
               else
                  lcase_1 += 1;                   /* no - inc lcase wd       */
            }
            else                                  /* in a word               */
            {                                     /* yes                     */
               if (*c4 >= 'A' && *c4 <= 'Z')      /* beg let, 1st wd ucase?  */
                  ucase_w += 1;                   /* yes - inc ucase wd      */
               else
                  lcase_w += 1;                   /* no - inc lcase wd       */
            }
         }
      }

   /**************************************************************************/
   /*  Make best guess.  If most words begin with upper case or the leading  */
   /*  word is begins in upper case then the label  begins upper case.       */
   /*  Furthermore - if mose of the remaining label characters are upper     */
   /*  case then all of preappended label is upper case.  If most of the     */
   /*  words start with lower case then whole of preappended label is lower  */
   /*  case.                                                                 */
   /**************************************************************************/

      if (lead_c == 1 || (ucase_1 > lcase_1))     /* most wds beg ucase?     */ 
         FMT = (ucase_w > lcase_w) ? 1 : 0;       /* yes, look at rest of wd */
      else                                        /* no!                     */
         FMT = 2;                                 /* all lower case          */
   }

   /**************************************************************************/
   /*  Preappend the word "integral" to the new_label variable               */
   /**************************************************************************/

   c1 = new_label;                                /* pointer to new label    */
   offset = fmt[0] + 2 * FMT;                     /* offset to correct lab   */ 

   c3 = IN_T[offset];                             /* ptr to integral lab     */
   while (*c3 != 0)                               /* loop over label         */
     *c1++ = *c3++;                               /* copy to new_label       */ 

   *c1++ = ' ';                                   /* add a space after intg  */

   /**************************************************************************/
   /*  Add non-stripped portion of unit_lab to new_lab                       */
   /**************************************************************************/

   while (*c2 != 0)                               /* loop over remain lab    */
      *c1++ = *c2++;                              /* copy over label         */
   *c1 = 0;                                       /* end of label            */
      
   if (Tstr != 0)                                 /* memeory been malloced?  */
      free (Tstr);                                /* yes - free it           */

   return (1);
}
