#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void XferContour (ByTe_4 N, ByTe_4 Ns, ByTe_1 New)
{
   extern struct UserDefs InFo;
   extern struct cont_info cinfo;
   extern struct cont_disp cdisp;
   extern struct cont_map c_map;
   extern struct three_d_cut cut;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct ConTouR *Ct;
   struct PlaneInfo *Pn;

   ReaL_4 Cor;
   ByTe_1 *C;

   InitContStructs();                             /* init contour structs    */ 

   Pd = (struct PlotDef *)InFo.PlotDefs + N;      /* plot info struct        */
   Ct = (struct ConTouR *)Pd->Cont;               /* contour info            */
   C = (ByTe_1 *)Wa.CStore;

   cinfo.data_type = Ct->Method; 

   if (cinfo.data_type == 2)
   {
      cinfo.X = Pd->Bx.N;
      cinfo.Y = Pd->Byl.N;
   }

   if (Pd->OutFmt != 0)                             /* need map stuff        */
   {                                                /* BEGIN ADD MAP         */
      cinfo.plot_fmt = 1;                           /* carteographic         */
      c_map.map = -1;                               /* no mapping output     */
      c_map.projection = Pd->OutFmt;                /* map projection        */
   }                                                /* END ADD MAP           */
   else                                             /* no maps               */
      cinfo.plot_fmt = 0;                           /* cartesian             */

   if (Ct->Method == 3)                             /* hollow grid           */
   {
      Cor = (Pd->Bx.Pos == 1) ? Pd->Bx.R / 2 : 0.0;
      cinfo.xmin = Pd->Bx.Start + Cor;
      cinfo.xmax = Pd->Bx.Stop - Cor;
      cinfo.nc = Pd->Bx.N;
      cinfo.xgridsca = Pd->Bx.Sca; 
      Cor = (Pd->Byl.Pos == 1) ? Pd->Byl.R / 2 : 0.0;
      cinfo.ymin = Pd->Byl.Start + Cor;
      cinfo.ymax = Pd->Byl.Stop - Cor;
      cinfo.nr = Pd->Byl.N;
      cinfo.ygridsca = Pd->Byl.Sca; 
   }
   else
   {
      cinfo.nc = Ct->XBins;
      cinfo.nr = Ct->YBins;
      cinfo.xmin = Ct->XMin;
      cinfo.xmax = Ct->XMax;
      cinfo.xgridsca = Ct->XSca; 
      cinfo.ymin = Ct->YMin;
      cinfo.ymax = Ct->YMax;
      cinfo.ygridsca = Ct->YSca; 
      
      if (Ct->Method == 0)                            /* 3D                  */
      {                                               /* BEG XFER PLANE INFO */
         Pn = (struct PlaneInfo *)Pd->Plane;          /* plane info          */ 
         cut.TransX = 0.0;                            /* X translation value */
         cut.TransY = 0.0;                            /* Y translation value */
         cut.Phi = Pn->Avg[1] + Ns * Pn->Phi;         /* phi rotation angle  */
         cut.Theta = Pn->Avg[2] + Ns * Pn->Theta;     /* theta rotation ang  */
         cut.Rho = Pn->BRho + Ns * Pn->Rho;           /* rho rotation angle  */
         cut.TransZ = Pn->ZTrans + Ns * Pn->Z;        /* Z translation value */
         cinfo.three_d = 1;                           /* its 3D time         */
      }                                               /* END XFER PLANE INFO */
   }

   cinfo.cyclic = Ct->XCyclic; 
   cinfo.MinCD = Ct->CycDis1;
   cinfo.MaxCD = Ct->CycDis2;
   cinfo.NFmt = Ct->OrGridPat; 
   cinfo.Norder = Ct->FitPts; 
   cinfo.Nbors = Ct->FitPts; 
   cinfo.NQuads = Ct->Quads; 
   cinfo.MinR = Ct->Radius; 
   cinfo.MinRFmt = Ct->RBase;
   cinfo.order = Ct->Order;
   cinfo.wgt = Ct->Weight;
   cinfo.same = Ct->NewGrid; 
   cinfo.save_grid = Ct->PrMesh; 
   cdisp.output = Ct->DispFmt; 
   cdisp.smooth = Ct->NCells;
   cdisp.IgnZero = Ct->NegData; 
   cdisp.show_grid = Ct->ShowGrids; 
   cdisp.grid_color = Ct->GridColor; 
   cdisp.clab_color = Ct->CLabColor; 
   if (Ct->ShowData == 1)
   {
      strcpy (cdisp.sh_dat_fmt, C + Ct->DataFmt); 
      cdisp.data_color = Ct->DataColor;
      cdisp.data_size = Ct->DataSize;
   }
   else
      cdisp.sh_dat_fmt[0] = 0;

   cinfo.numlevels = Ct->NContours;
   cinfo.Ubeg = Ct->MinContour;
   cinfo.Ufin = Ct->MaxContour;
   cdisp.normal = Ct->ContColor; 

   if (Ct->ShowCLabs == 1)
      strcpy (cdisp.cnt_fmt, C + Ct->CLabFmt); 
   else
      cdisp.cnt_fmt[0] = 0;

   cdisp.LnSz = Ct->CLabSize;
   cdisp.lin_inc = Ct->CLabSkip;

   cdisp.show_cbar = 0; 
   cdisp.colmin = Pd->Cb.Min;
   cdisp.colmax = Pd->Cb.Max;
   cdisp.Cs = Pd->Cb.Sca; 
   if (New == 0 && Pd->Cb.Sca == 1)
       cdisp.Cs = 2; 

   AfterGraphicsOn ();
}
