/****************************************************************************/
/*  This routine picks up one sweep of data from each of the data sources   */
/*  listed in the SOURCE file found in the variable VINFO                   */
/****************************************************************************/

#include <stdio.h>
#include <math.h>
#include "UDFpltStr.h"
#include "util_str.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "libbase_udf.h"
#include "UDFpltAnsi.h"

ByTe_2 VecData (struct VSrcInfo *V, struct TiMiNg *Tb, struct TiMiNg *Te,
                ReaL_4 *Avg)
{
   extern struct general_info ginfo;                                            
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct experiment_info *ex;
   struct ptr_rec *pTr;
   struct idf_data *ExDa;

   ReaL_4 TmP[1000];
   register ReaL_4 *f1;
   
   ReaL_4 N[3], F;
   ByTe_4 bS, eS, sS, nS;
   ByTe_2 I, rV, *S, cC = 0, cCnT;
   ByTe_1 FwD, Go = 0, *C, Loc, SnaggedOne = 0;

   ex = ginfo.expt;
   pTr = ex->info_ptr;
   ExDa = (struct idf_data *) InFo.UDF;                 /* ptr to data       */

   C = (ByTe_1 *)Wa.CStore;                             /* base string data  */
   S = (ByTe_2 *)Wa.SStore;                             /* base short data   */
   for (I = 0; I < 3; ++I) {                            /* BEG INITS LOOP    */
       Avg[I] = 0.0;                                    /* zero out avg      */
       N[I] = 0.0;                                      /* zero out norms    */
   }                                                    /* END INITS LOOP    */

   bS = Tb->Ms / 1000;                                  /* beginning seconds */
   eS = Te->Ms / 1000;                                  /* ending seconds    */
   if ((F = FracTm (Tb, Te, &V->Vb, &V->Ve, &Go)) <= 0.0) /* need new data   */
   {                                                    /* BEG RESET TIME    */
       rV = ToThisTime (V->Key, "", V->Ver, InFo.UDF,   /* reset start time  */
                       Tb->Yr, Tb->Dy, bS, Tb->Ns, 
                       Te->Yr, Te->Dy, eS, Te->Ns);
       ErrorRpt ("TOTHISTIME", rV, 0);                  /* report any errs   */
       if (rV == TIME_NOT_FOUND)                        /* can't get to time */
          return (0);                                   /* leave and report  */
       cC = ExDa->column;
       cCnT = (ExDa->TotCols > 1) ? cC - *pTr->LEAD_COL : 0;
   } else {                                             /* BEG LAST ACCESS   */
       SnaggedOne = 1;                                  /* 1 value at least  */
       for (I = 0; I < 3; ++I)  {                       /* BEG XFER LOOP     */
           if (V->RStat[I] == 1)  {                     /* BEG VALID DATA    */
              Avg[I] = V->Data[I] * F;                  /* Xfer data         */
              N[I] = F;                                 /* Xfer normal       */
           }                                            /* BEG VALID DATA    */
       }                                                /* END XFER LOOP     */
       if (Go) {                                        /* will need more    */
         rV = read_drec (V->Key, "", V->Ver, InFo.UDF, -1, 0, 1, 0);
         sS = (InFo.TE.Ms + (InFo.TE.Ns / 1000000)) / 1000;
         nS = (InFo.TE.Ms % 1000) * 1000000 + InFo.TE.Ns;
         rV = ReOpenFile (V->Key, "", V->Ver, InFo.UDF, 0, 0, 0, 0,
                          InFo.TE.Yr, InFo.TE.Dy, sS, nS, rV);
         ErrorRpt ("REOPENFILE", rV, 0);
      }
   }

   do {                                                 /* BEG GET ALL LOOP  */
      f1 = V->Data;                                     /* vec saved data    */
      for (I = 0; I < 3; ++I, ++f1) {                   /* BEGIN SOURCE LOOP */
         rV = read_drec (V->Key, "", V->Ver, InFo.UDF, V->SenVN[I], cC, 0, 0);
         ErrorRpt ("READ_DREC", rV, 0);                 /* report any errs   */
         if (ExDa->filled_data)                         /* got some data?    */
         {
             V->RStat[I] = 1;
             Loc = (V->DLoc[I] == 'A') ? ANCILLARY : SENSOR;
             rV = convert_to_units (V->Key, "", V->Ver, InFo.UDF, Loc, 
                          (ByTe_1)V->SenAVN[I], V->SenNAS[I], 
                          C + V->SenTbls[I], S + V->SenOps[I], TmP, 0, 0L); 

             ErrorRpt ("CONVERT_TO_UNITS", rV, 1);   
             *f1 = TmP[0];
         }
         else
            V->RStat[I] = 0;
      }                                                 /* END SOURCE LOOP   */

      V->Vb.Yr = ExDa->byear;                           /* ending year       */
      V->Vb.Dy = ExDa->bday;                            /* ending day        */
      V->Vb.Ms = ExDa->bmilli;                          /* ending msec       */
      V->Vb.Ns = ExDa->bnano;                           /* ending nsec       */
      V->Ve.Yr = ExDa->eyear;                           /* ending year       */
      V->Ve.Dy = ExDa->eday;                            /* ending day        */
      V->Ve.Ms = ExDa->emilli;                          /* ending msec       */
      V->Ve.Ns = ExDa->enano;                           /* ending nsec       */

      if ((F = FracTm (Tb, Te, &V->Vb, &V->Ve, &Go)) > 0.0) /* usable data? */
      {                                                 /* BEGIN ADD DATA    */
          SnaggedOne = 1;                               /* 1 value at least  */
          for (I = 0; I < 3; ++I) {                     /* BEG XFER LOOP     */
              if (V->RStat[I] == 1) {                   /* BEG VALID DATA    */
                 Avg[I] += V->Data[I] * F;              /* Xfer data         */
                 N[I] += F;                             /* Xfer normal       */
              }                                         /* BEG VALID DATA    */
          }                                             /* END XFER LOOP     */
      }                                                 /* BEGIN ADD DATA    */

      if (Go) {
         if (ExDa->TotCols > 1 && !SnaggedOne) {
            if (++cCnT >= *pTr->N_COLS) {
               cCnT = 0;
               cC = 0;
               FwD = 1;
            } else {
               cC = *pTr->LEAD_COL + cCnT;
               FwD = 0;
            }
         } else {
            cC = 0;
            FwD = 1;
         }

         if (FwD == 1) {
            rV = read_drec (V->Key, "", V->Ver, InFo.UDF, -1, cC, FwD, 0);
            sS = (InFo.TE.Ms + (InFo.TE.Ns / 1000000)) / 1000;
            nS = (InFo.TE.Ms % 1000) * 1000000 + InFo.TE.Ns;
            rV = ReOpenFile (V->Key, "", V->Ver, InFo.UDF, 0, 0, 0, 0,
                          InFo.TE.Yr, InFo.TE.Dy, sS, nS, rV);
            ErrorRpt ("REOPENFILE", rV, 0);
         }
      }
   }  while (Go);                                       /* END GET ALL LOOP  */

   for (I = 0; I < 3; ++I)                              /* loop over sensors */
      if (N[I] > 0.0)                                   /* found data?       */
         Avg[I] /= N[I];                                /* normalize it      */
      else                                              /* no data           */
         return (0);                                    /* one bad all bad   */

   return (1);
}
