#include <stdio.h>
#include <math.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "gph_shortcut_defs.h"

void Tools (ByTe_4 N, ByTe_4 SrcN, ByTe_1 TiD, ByTe_1 New, ByTe_4 pN) 
{
   extern struct UserDefs InFo;

   struct PlotDef *Pd;
   struct ToolInfo *Ti, *TiEnD;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;      /* plot info struct        */

   if (Pd->NTools == 0)                           /* no plot tools           */
      return;                                     /* no need to stay         */

   Ti = (struct ToolInfo * ) Pd->Tools;           /* Tool info               */
   TiEnD = Ti + Pd->NTools;                       /* End of Tool info        */

   for ( ; Ti < TiEnD; ++Ti)                      /* loop over tool desc's   */
   {                                              /* BEG TOOL LOOP           */
      if (Ti->Type == TiD)                        /* requested tool?         */
      {                                           /* BEG DO TOOL             */
         switch (TiD)                             /* switch on tool          */
         {                                        /* BEG TOOL SWITCH         */
            case 0:                               /* START PLOT VECTOR       */
               RmFlow (N, SrcN, Ti, New, 0);      /* plot the data           */
            break;                                /* STOP PLOT VECTOR        */
            case 1:                               /* START PLOT VECTOR       */
               PlotVecData (N, Ti, New);          /* plot the data           */
            break;                                /* STOP PLOT VECTOR        */
            case 3:                               /* START DRAW GLOBE        */
               PlotGlobe (N, Ti, New, pN);        /* plot the data           */
            break;                                /* STOP DRAW GLOBE         */
            case 4:                               /* START DRAW OBJ VEC      */
               PlotObj (N, Ti, New, pN);          /* plot the data           */
            break;                                /* STOP DRAW OBJ VEC       */
         }                                        /* END TOOL SWITCH         */
      }                                           /* END DO TOOL             */
   }                                              /* END TOOL LOOP           */
}
