#include <stdlib.h>
#include "util_str.h"
#include "idf_defs.h"
#include "user_defs.h"
#include "libbase_udf.h"

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void TmRes (struct PlotDef *Pd, ByTe_4 SrcN)
{
   extern struct UserDefs InFo;
   struct idf_data  *ExDa;

   ReaL_8 dY, dD, dM, dT, AddLeap;
   ByTe_4 Y;

   ExDa = (struct idf_data *) InFo.UDF;              /* ptr to data          */
   Pd->Tm.Dir =  1;                                  /* time always goes fwd */
   Pd->Tm.N = Pd->P.dX - 1;                          /* pixels along time    */

   if (Pd->Tm.Fmt == 0)                              /* tot time is plot tm  */
   {                                                 /* BEG TIME FROM PLOT   */
      if (Pd->Pb.Yr < 0 || Pd->NegYr)                /* need beg plot set    */
      {                                              /* BEG FROM DATA        */
         Pd->NegYr = 1;                              /* started with neg yr  */
         dY = InFo.TE.Yr - ExDa->byear;              /* diff of years        */
         dD = InFo.TE.Dy - ExDa->bday;               /* diff of days         */
         dM = InFo.TE.Ms - ExDa->bmilli;             /* diff of msec         */
      }                                              /* END FROM DATA        */
      else                                           /* use given            */
      {                                              /* BEG FROM USER SET    */
         dY = InFo.TE.Yr - InFo.TB.Yr;               /* diff of years        */
         dD = InFo.TE.Dy - InFo.TB.Dy;               /* diff of days         */
         dM = InFo.TE.Ms - InFo.TB.Ms;               /* diff of msec         */
      }                                              /* END FROM USER SET    */

      if (dY > 60)                                   /* whole lotta years?   */
      {                                              /* BEG DAY IS BASE      */
         Pd->Tm.Sca = 1;                             /* set time base flag   */
         dT = dY * 365.0 + dD;                       /* base days            */
         if (dM < 0)                                 /* neg msec?            */
         {                                           /* BEG NEG MSEC COR     */
            dT -= 1.0;                               /* borrow a day         */
            dM += 86400000.0;                        /* give it to msec      */
         }                                           /* END NEG MSEC COR     */
         dT += dM/86400000.0;                        /* add left over time   */
         AddLeap = 1;                                /* add 1 day per leap   */
      }                                              /* END DAY IS BASE      */
      else                                           /* maybe sec or msec    */
      {                                              /* BEG SMALLER BASE     */
         if (dD < 15 && dY == 0)                     /* not many days        */
         {                                           /* BEG MSEC IS BASE     */
            Pd->Tm.Sca = 5;                          /* set time base flag   */
            dT = dD * 86400000.0 + dM;               /* base msec            */
            AddLeap = 0;                             /* no change in year    */
         }                                           /* END MSEC IS BASE     */
         else                                        /* lets use seconds     */
         {                                           /* BEG SEC IS BASE      */
            Pd->Tm.Sca = 4;                          /* set time base flag   */
            dT = dY * 31536000.0 + dD * 86400.0;     /* base sec             */
            if (dM < 0)                              /* neg msec?            */
            {                                        /* BEG NEG MSEC COR     */
               dT -= 86400.0;                        /* borrow a day         */
               dM += 86400000.0;                     /* give it to msec      */
            }                                        /* END NEG MSEC COR     */
            dT += dM / 1000;                         /* add left over time   */
            AddLeap = 86400.0;                       /* day in seconds       */
         }                                           /* END SEC IS BASE      */
      }                                              /* END SMALLER BASE     */

      for (Y = InFo.TB.Yr; Y < InFo.TE.Yr; ++Y)      /* leap year loop       */
      {                                                    /* BEG LEAP LOOP  */
         if ((Y % 4 == 0 && Y % 100 != 0) || Y % 400 == 0) /* Leap Year?     */
            dT += AddLeap;                                 /* Add a day      */
      }                                                    /* END LEAP LOOP  */
  
      Pd->Tm.R = dT;                                 /* time interval        */
   }                                                 /* END TIME FROM PLOT   */
   else                                              /* user sets time base  */
   {                                                 /* BEG TIME FROM USER   */
      switch (Pd->Tm.Sca)                            /* switch on units      */
      {                                              /* BEG UNITS SWITCH     */
         case 0:                                     /* START YEARS          */
            Pd->Tm.Sca = 1;                          /* set to days          */
            Pd->Tm.R *= 365.0;                       /* base is days         */
         break;                                      /* STOP YEARS           */
         case 2:                                     /* START HOURS          */
            Pd->Tm.Sca = 4;                          /* set to seconds       */
            Pd->Tm.R *= 3600.0;                      /* base is seconds      */
         break;                                      /* STOP HOURS           */
         case 3:                                     /* START MINUTES        */
            Pd->Tm.Sca = 4;                          /* set to seconds       */
            Pd->Tm.R *= 60.0;                        /* base is seconds      */
         break;                                      /* STOP MINUTES         */
         case 8:                                     /* START MINUTES        */
            Pd->Tm.Sca = 5;                          /* set to msec          */
            Pd->Tm.R *= ExDa->spin_rate;             /* base is seconds      */
            if (Pd->Tm.R < 0.0)                      /* negative spin rate?  */
               Pd->Tm.R = - Pd->Tm.R;                /* correct that         */
         break;                                      /* STOP MINUTES         */
         case 9:                                     /* START MEASUREMENT    */
            Pd->Tm.Sca = 5;                          /* set to msec          */
            if (SrcN == 0) {
               Pd->Pb.Yr = -1;
               Pd->NegYr = 1;
            }
            Pd->Pe.Yr = InFo.TE.Yr;
            Pd->Pe.Dy = InFo.TE.Dy;
            Pd->Pe.Ms = InFo.TE.Ms;
            Pd->Pe.Ns = InFo.TE.Ns;
            dT = ExDa->data_accum_ms + ExDa->data_accum_ns/1000000.0;
            dT += ExDa->data_lat_ms + ExDa->data_lat_ns/1000000.0;
            Pd->Tm.R *= dT;
         break;                                      /* STOP MEASUREMENT     */
      }                                              /* END UNITS SWITCH     */
   }                                                 /* END TIME FROM USER   */
}
