#include <stdio.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "util_str.h"

void TimeValue (ByTe_4 PN, ByTe_2 SrcN, ByTe_4 pN, ByTe_4 RpN)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern struct config parm;
   extern char *ScatSym[];

   struct PlotDef *Pd;
   struct SrcInfo *S;

   register ReaL_4  *f1, *f2, *f3, *fEnD;

   ReaL_4   *X, *V, Y1, Y2;
   ByTe_4   dY, dYs, Rem, Pn, MaxL, TnP, LnP, cO;
   ByTe_4   Beg, M, End, Tn;
   ByTe_2   C, *Cp;
   ByTe_1   Cmd[30], *c1, *Cs;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;          /* plot def struct    */
   S = (struct SrcInfo *)Pd->Src + SrcN;               /* pntr to first src  */
   Cs = (ByTe_1 *)Wa.CStore;

   V = (ReaL_4 *)Wa.WorkSpace + 2 * pN * Pd->PlotLen;  /* data is here       */
   X = V + Pd->PlotLen;                                /* norms are here     */

   if (Pd->Bx.Empty != 0)                              /* some kind of fill  */
   {                                                   /* BEG FILL GAPS      */
      Normalize (V, X, Pd->Bx.N, 1, 0.0);              /* normalize data     */
      Tn = Pd->Byl.N;                                  /* save current Y len */
      Pd->Byl.N = 1;                                   /* set to 1           */
      FillGaps (PN, pN, 'X');                          /* fill in X blanks   */
      End = Pd->Bx.N;                                  /* this many pixels   */
      Pd->Byl.N = Tn;                                  /* restore Y length   */

      f1 = X;                                          /* normals            */
      Beg = 0;                                         /* begin here         */
      while (Beg < Pd->Bx.N && *f1++ < 0.0)            /* get to 1st data    */
         ++Beg;                                        /* increment pos      */

      if (Beg < Pd->Bx.N)                              /* something here     */
      {                                                /* BEG LAST GOOD DATA */
         End = Pd->Bx.N - 1;                           /* End of data        */
         f1 = X + End;                                 /* end normal         */
          while (End >= 0 && *f1-- < 0.0)              /* get to last data   */
            --End;                                     /* decrement pos      */
      }                                                /* END LAST GOOD DATA */

      f1 = X + Beg;                                    /* start of data      */
      for (M = Beg; M <= End; )                        /* loop over X        */
          *f1++ = M++ + 1;                             /* set X              */
   }                                                   /* END FILL GAPS      */
   else                                                /* no fill            */
   {                                                   /* BEG NO FILL        */
      Normalize (V, X, Pd->Bx.N, 0, 0.0);              /* normalize data     */
      f1 = X;                                          /* norms are here     */
      f2 = X;                                          /* X's put over norms */
      f3 = V;
      Beg = 0;                                         /* num of good data   */
      End = 0;                                         /* num of good data   */
      set_qual (Pd->Pn, 'Y', 'L', -1.0e30);
      for (M = 1; M <= Pd->Bx.N; ++M, ++f3) {          /* loop over X        */
         if (*f1++ < 0.0) { *f3 = -1.0e31; }           /* good data here?    */
         *f2++ = M;                                    /* set X              */
         ++End;                                        /* inc num data pts   */
      }
      --End;                                           /* real end           */
   }                                                   /* END NO FILL        */

   if (S->LpType < 10)                                 /* normal line plot   */ 
   {                                                   /* BEG NORMAL PLOT    */
      M = 0;                                           /* counter            */
      Cmd[M++] = S->LpType;                            /* the plot format    */
      if (S->LpType == 2 || S->LpType == 6)            /* scatter or labline */ 
      {
         if (S->ScatSym < 10)
            c1 = ScatSym[S->ScatSym];
         else
            c1 = Cs + S->ScatSym;

         while (*c1 != 0)
            Cmd[M++] = *c1++;
         Cmd[M++] = 0;                                 /* format terminator  */

         c1 = Cs + S->SymSize;
         while (*c1 != 0)
            Cmd[M++] = *c1++;
      }
      else
         Cmd[M++] = 0;                                 /* format terminator  */

      Cmd[M++] = 0;                                    /* format terminator  */
      Cmd[M] = 0;                                      /* format terminator  */
      Cp = &parm.white;                                /* ptr to color info  */
      cO = (S->PCol < 0) ? 10 + (pN % Pd->Stack) % 7 : 
                                     (S->OneAll == 3) ? pN : 0;
      C = *(Cp + S->PCol + cO);                        /* requested plot col */

      if (End >= 0) {
         plot_2d (Pd->Pn, 0, S->PAxis, 8, X, V, X, Beg, End, Cmd, C);
/*
for ( JJ = 0; JJ <= End; ++JJ)
fprintf(stderr, "%5d %.2e %.5e\n", JJ, X[JJ], V[JJ]);
*/
          set_qual (Pd->Pn, 'Y', 'O', -1.0e30);
      }
      if (S->AddErr >= 0)                              /* add error bars     */ 
      {
         Cmd[0] = 0;
         Cmd[1] = (S->AddErr == 4) ? 1 : 0;
         Cmd[2] = (S->AddErr == 4) ? 3 : S->AddErr;
         Cmd[3] = 0;
         Cmd[4] = 0;
         Cmd[5] = 0;
         C = *(Cp + S->ECol + cO);                  /* requested plot col */
         add_ebars (Pd->Pn ,0, S->PAxis, 8, X, V, X, X, V, X, Beg, End, 
                     Cmd, C, C);    
      }
   }                                                   /* END NORMAL PLOT    */
   else                                                /* spectoscalar       */
   {                                                   /* BEG SPECSCALAR     */
      Pn = pN % Pd->Stack;                             /* RpN in plot        */
      LnP = Pd->nGL - (Pd->nGL / Pd->Stack) * Pd->Stack; /* # in last plot   */
      TnP = Pd->nGL - pN;                              /* plots left         */
      MaxL = (TnP > LnP) ? Pd->Stack : LnP;            /* plots in panel     */
      dY = Pd->P.dY - 1 - Pd->Gap * (MaxL - 1);        /* pixels along Y     */
      dYs = dY / MaxL;                                 /* pixels per strip   */
      Rem = dY % MaxL;                                 /* left over pixels   */
      if (Pn > Rem)                                    /* used extra pixels  */
      {                                                /* BEG EXTRAS GONE    */
         Y1 = Pd->Yr.Min + Pn * (dYs + Pd->Gap) + Rem + 1;  /* begin Y       */
         Y2 = Y1 + dYs - 1;                                 /* end Y         */
      }                                                /* END EXTRAS GONE    */
      else                                             /* still some to use  */
      {                                                /* BEG MORE EXTRAS    */
         Y1 = Pd->Yr.Min + Pn * (dYs + Pd->Gap) + Pn + 1;   /* begin Y       */
         Y2 = Y1 + dYs;                                     /* end Y         */
      }                                                /* END MORE EXTRAS    */

      f1 = X + Beg;                                    /* starting X value   */
      f2 = V + Beg;                                    /* begin data value   */
      fEnD = X + End;                                  /* end of data        */
      for ( ; f1 <= fEnD; ++f1, ++f2)                  /* loop over data     */
      {                                                /* BEG DRAW LOOP      */ 
         C = ValToColor (*f2, Pd->Cb.Sca, Pd->CInfo);  /* get color          */
         plt_color (-1, C);                            /* set color          */
         line (Pd->Wn, *f1, Y1, 0., *f1, Y2, 0);       /* draw line          */
      }                                                /* END DRAW LOOP      */ 
   }                                                   /* END DO ALL PLOTS   */
}
