#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "gph_shortcut_defs.h"

/*****************************************************************************/
/*  This program puts up all plot boxes associated with a given plot         */
/*  definition                                                               */
/*****************************************************************************/

void SetUpMapPlot (ByTe_4 PNuM, ByTe_4 RelWn)
{
   extern struct UserDefs InFo;
   extern struct config parm;
   extern struct mapinfo map;

   struct PlotDef *Pd;
   struct CutDef  *cD;
   struct AxisInfo *Axb, *Axt, *Ayl, *Ayr;

   ReaL_4 dPy, Xr, Xl, Yt, Yb, Ty, By, GrP;
   ByTe_4 C, R, Ln, N;
   ByTe_2 Lr, Lc;
   ByTe_1 BWn, Wn;
   ByTe_1 SaveUniv;

   N = PNuM % InFo.NPDefs;
   GrP = (ByTe_4)(PNuM / InFo.NPDefs);

   Pd = (struct PlotDef *)InFo.PlotDefs + N;           /* plot define info   */
   Wn = Pd->Wn;                                        /* window number      */
   Axt = &Pd->Xt;                                      /* Top X axis         */
   Ayl = &Pd->Yl;                                      /* Left Y axis        */
   Axb = &Pd->Xb;                                      /* Bot X axis         */
   Ayr = &Pd->Yr;                                      /* Right Y axis       */
 
   BWn = 2;                                            /* set base window #  */ 
   Lc = Pd->Cols - 1;                                  /* last col number    */
   Lr = Pd->Rows - 1;                                  /* last row number    */
   Ln = InFo.EmptyPd - 1;                              /* last plot def      */
   if (Pd->TimeDir == 1) {                             /* TIME ACROSS        */
      R = RelWn / Pd->Cols;                            /* current row number */
      C = RelWn % Pd->Cols;                            /* current col number */
   } else {                                            /* TIME DOWN          */
      R = RelWn % Pd->Cols;                            /* current row number */
      C = RelWn / Pd->Cols;                            /* current col number */
   }                                                   /* END PLOT PLACEMENT */

   Axb->DoLabs = (N == Ln && R == Lr) ? 1 : 0;         /* Bot X label status */
   Ayr->DoLabs = (C == Lc) ? 1 : 0;                    /* Right Y label stat */
   Axt->DoLabs = (N == 0 && R == 0) ? 1 : 0;           /* Top X label status */
   Ayl->DoLabs = (C == 0) ? 1 : 0;                     /* Left Y label stat  */
   if (Pd->CCut != 0)                                  /* contour cut?       */
   {                                                   /* BEG NORMAL CHECKS  */
      cD = (struct CutDef *)Pd->CCut;
      if (cD->CutPlace == 0)                           /* bottom cut         */
         Ayl->DoLabs = 0;                              /* no Bot X labels    */
      else                                             /* cut on right       */
         Axb->DoLabs = 0;                              /* no Right Y labels  */
   }                                                   /* BEG NORMAL CHECKS  */

   set_wn_def (Wn, 0, 0, 1);                          /* input win param def */
   SaveUniv = parm.univ;                              /* save plotting space */
   parm.univ = Pd->OutFmt + 8;                        /* new plotting space  */
   map.rotlat = 0.0;                                  /* never latitude rot  */

   map.rotlong = Pd->Map.RotLong;                     /* long rotation       */
   map.center = Pd->Map.RotLat;                       /* lat rotation        */

   axis_scale(Wn, 0, 0, 0);                           /* always linear       */

   Ty = Pd->P.Uy - Pd->P.AbsLy * GrP;                 /* upper y plot edge   */
   By = Ty - (Pd->P.Uy - Pd->P.Ly);                   /* upper y plot edge   */

   dPy = Pd->P.dY + Pd->P.dCr;                        /* total plot length   */
   Xl = Pd->P.Lx + C * Pd->P.dX;                      /* left x plot edge    */
   Xr = Pd->P.Rx + C * Pd->P.dX;                      /* right x plot edge   */
   Yt = Ty - R * dPy;                                 /* upper y plot edge   */
   Yb = By - R * dPy;                                 /* lower y plot edge   */

   set_relwin(Wn, BWn, Xl, Yb, 0., Xr, Yt, 0.,        /* window placement    */
                  Axb->Min, Ayl->Min, 0.,             /* and scaling         */
                  Axb->Max, Ayl->Max, 0.);
   parm.univ = SaveUniv;                              /* restore plot space  */
}                                                     /* END MAP PLOT        */
