#include <stdio.h>

#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ByTe_2 RollTime (struct TiMiNg *Tm, ByTe_2 Dy, ByTe_4 Ms)
{
   ByTe_4 DiY;
   ByTe_2 UDay;

   Tm->Ms += Ms;                                   /* increment msec         */ 
   UDay = Tm->Dy;                                  /* current day            */
   while (Tm->Ms >= 86400000)                      /* over day?              */
   {                                               /* BEG MSEC/DAY CORRECT   */
      Tm->Ms -= 86400000;                          /* back off a day         */
      ++Tm->Dy;                                    /* then put it here       */
      UDay = Tm->Dy;                               /* uncorrected day        */
      DiY = LeaP(Tm->Yr);                          /* days in year           */
      if (Tm->Dy > DiY)                            /* did day go over year?  */
      {                                            /* BEG YEAR/DAY CORRECT   */
         Tm->Dy = 1;                               /* (Happy) New Year       */
         ++Tm->Yr;                                 /* another year older     */
      }                                            /* END YEAR/DAY CORRECT   */
   }                                               /* END MSEC/DAY CORRECT   */

   return (UDay);                  
}
