#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"
#include "gph_shortcut_defs.h"


/*****************************************************************************/
/*  This program puts up all plot boxes associated with a line plot          */
/*  definition                                                               */
/*****************************************************************************/

void PopUpPlot (ByTe_4 N, ByTe_1 Pass, ByTe_1 Type)
{
   extern struct UserDefs InFo;
   extern struct config parm;
   extern struct mapinfo map;
   extern ByTe_1 *MaPs[];

   struct PlotDef *Pd;
   struct CutDef *cD;

   ByTe_4 proj, res, opts = 2;
   ByTe_4 I;
   ByTe_2 *s1, C;
   ByTe_2 SVcolor;
   ByTe_1 Pn, Wn; 
   ByTe_1 *GPH_MAPS;
   ByTe_1 mappath[256];

   Pd = (struct PlotDef *)InFo.PlotDefs + N;      /* plot info struct        */

   if (Pd->OutFmt == 0)                           /* cartesian plot          */
   {                                              /* BEG CARTESIAN           */
      if (Pass == 1)                              /* never draw before data  */
         return;                                  /* leave                   */

      C  = parm.white;                            /* all is drawn in white   */
      Pn = Pd->Pn;                                /* start this plot number  */
      plt_color (-1, C);                          /* line color to white     */
      dr_axis(Pn);                                /* spit out the axis       */
      if (Type < 10)                              /* normal plot             */
      {                                           /* BEG NOT SPEC/SCA PLOT   */
         dr_tic(Pn,4,1,0.0);                      /* ticks along left Y      */
         dr_tic(Pn,6,1,0.0);                      /* ticks along right Y     */
      }                                           /* END NOT SPEC/SCA PLOT   */
      if (Pd->AData[0] != 0)                      /* no time on X            */
      {                                           /* BEG X TICKS             */
         dr_tic(Pn,0,1,0.0);                      /* ticks along bottom X    */
         dr_tic(Pn,2,1,0.0);                      /* ticks along top X       */
      }                                           /* END X TICKS             */
   }                                              /* END CARTESIAN           */
   else                                           /* a map plot              */
   {                                              /* BEG CARTEOGRAPHIC       */
      Wn = Pd->Wn;                                /* start this win number   */
      s1  = &parm.white;                          /* base color              */
      SVcolor = parm.l_color;                     /* save current line color */
      map.dlong = Pd->Map.DLong;                  /* grid longitude deltas   */
      map.dlat  = Pd->Map.DLat;                   /* grid latitude deltas    */
      map.Nlastlat  = Pd->Map.LastNLat;           /* north lat grid exten    */
      map.Slastlat  = Pd->Map.LastSLat;           /* south lat grid exten    */

      if (Pd->Map.Grid == Pass)                   /* output map grid?        */
      {                                           /* BEG DRAW MAP GRID       */
         C = *(s1 + Pd->Map.GColor);              /* grid color              */
         plt_color (0, C);                        /* set it                  */
         proj = Pd->OutFmt;                       /* projection to use       */
         mapgrid (Wn, proj);                      /* draw grids              */
      }                                           /* BEG DRAW MAP GRID       */

      if (Pd->Map.Map == Pass)                    /* need to draw map?       */
      {                                           /* BEG DRAW LAND OUTLINES  */
         res = Pd->Map.MapRes;                    /* map resolution          */
         GPH_MAPS = getenv("GPH_MAPS");           /* maps are here           */
         if(!GPH_MAPS)                            /* no map variable!        */
           g_error("POPUPTPPLOT", "GPH_MAPS env not set", 0);
         else                                     /* everythins is OK        */
         {                                        /* BEG MAP OUTPUT          */
            C = *(s1 + Pd->Map.MColor);           /* map color               */
            plt_color (0, C);                     /* set map color           */
            for (I = 0; I < 4; ++I)               /* loop over maps          */
            {                                     /* BEG MAP LOOP            */
	       sprintf(mappath,"%s/%s", GPH_MAPS, MaPs[I]); /* map file      */
               maplines (Wn, proj, mappath, opts, res);     /* draw map      */
            }                                     /* END MAP LOOP            */
         }                                        /* END MAP OUTPUT          */
      }                                           /* END DRAW LAND OUTLINES  */
      plt_color (0, SVcolor);                     /* return original color   */
   }                                              /* END CARTEOGRAPHIC       */

   if (Pd->CCut != 0 && Pass == 0)                /* contour cut plot        */
   {                                              /* BEG CUTPLOT             */
      cD = (struct CutDef *)Pd->CCut;
      Pn = cD->CutPn;                             /* start this plot number  */
      dr_axis(Pn);                                /* spit out the axis       */

      dr_tic(Pn, 4, 1, 0.0);                      /* ticks along left Y      */
      dr_tic(Pn, 6, 1, 0.0);                      /* ticks along right Y     */
      if ((Pd->AData[0] != 0 && cD->CutPlace == 0) || cD->CutPlace == 1)
      {                                           /* BEG X TICKS             */
         dr_tic(Pn,0,1,0.0);                      /* ticks along bottom X    */
         dr_tic(Pn,2,1,0.0);                      /* ticks along top X       */
      }                                           /* END X TICKS             */
   }                                              /* BEG CUTPLOT             */

   if (Pd->LSCut != 0 && Pass == 0)               /* LShell cut plot         */
   {                                              /* BEG CUTPLOT             */
      cD = (struct CutDef *)Pd->LSCut;
      Pn = cD->CutPn;                             /* start this plot number  */
      dr_axis(Pn);                                /* spit out the axis       */

      dr_tic(Pn, 4, 1, 0.0);                      /* ticks along left Y      */
      dr_tic(Pn, 6, 1, 0.0);                      /* ticks along right Y     */
      if ((Pd->AData[0] != 0 && cD->CutPlace == 0) || cD->CutPlace == 1)
      {                                           /* BEG X TICKS             */
         dr_tic(Pn,0,1,0.0);                      /* ticks along bottom X    */
         dr_tic(Pn,2,1,0.0);                      /* ticks along top X       */
      }                                           /* END X TICKS             */
   }                                              /* BEG CUTPLOT             */
}
