#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "libCfg.h"
#include "PidfStr.h"
#include "PidfAnsi.h"

/*****************************************************************************/
/*  This program puts up a color bar associated with a plot                  */
/*****************************************************************************/

void PopUpCBar (ByTe_4 PNuM)
{
   extern struct UserDefs InFo;
   extern struct config parm;

   struct PlotDef *Pd;

   struct AxisInfo *Ax;
   struct Pidf *P;
   struct PidfUnit *Pu, *Pa;
   struct SrcInfo *S;
   struct CutDef *cD;

   ReaL_4 X1, X2, Y1, Y2, dX, dX2, dY, X, Y, Ty, GrP;
   ReaL_4 Sz[2];

   ByTe_4 N;
   ByTe_2 C;

   ByTe_1 Cmd[10], F[5];
   ByTe_1 L0[50], L1[50], L2[50]; 
   ByTe_1 Pn;

   N = PNuM % InFo.NPDefs;
   GrP = (ByTe_4)(PNuM / InFo.NPDefs);

   Pd = (struct PlotDef *)InFo.PlotDefs + N;        /* plot info struct      */
   Ax = &Pd->Cb;                                    /* color bar axis info   */

   Pn = 2;                                          /* plot # for all Cbar   */
   C = parm.white;                                  /* all labels are white  */
   plt_color (-1, C);                               /* draw in white         */

   window (1, "POPUPCBAR");                         /* ptrs to base window 1 */
   chr_size (Ax->NumSize);
   get_chsz (Sz);

   Ty = Pd->P.Uy - Pd->P.AbsLy * GrP - Pd->P.ToPdY * GrP; 
   Y = (InFo.RtY - InFo.SqY) / 2;                   /* offset to left win  2 */
   dY = (Pd->P.dY + Pd->P.dYp) * Pd->Rows;
   dY += Pd->P.dCb * Pd->Rows;                      /* Tot plot Y axis len   */
   Y1 = (ByTe_4)(Ty + Y - .9 * dY);                 /* min Y for color bar   */
   Y2 = (ByTe_4)(Ty + Y - .1 * dY);                 /* max Y for color bar   */

   X = (InFo.RtX - InFo.SqX) / 2;                   /* offset to left win  2 */
   if (Pd->LSCut) {
      cD = (struct CutDef *)Pd->LSCut;
      if (cD->CutPlace == 1)
         X += 7.0 * Sz[0];
   }

   dX = InFo.RtX - InFo.PXmax - X;
   X1 = (ByTe_4)(InFo.PXmax + X + .12 * dX);        /* min X of colorbar     */ 
   dX2 =  0.025 * InFo.RtX;
   X2 = X1 + dX2;                                   /* max X of colorbar     */ 
   if (X2 > InFo.RtX)
      X2 = X1 + .45 * dX;

   mj_tic_len(Pn, Ax->MjTLen, Ax->MjTLen, 1,        /* major tick length     */
                  Ax->MjTLen, Ax->MjTLen, 1); 

   mn_tic_len(Pn, Ax->MnTLen, Ax->MnTLen, 1,        /* minor tick length     */
                  Ax->MnTLen, Ax->MnTLen, 1);

   mj_tic_fmt(Pn, Ax->MjTFmt, Ax->MjTFmt, 1,        /* major tick format     */
                  Ax->MjTFmt, Ax->MjTFmt, 1); 

   mn_tic_fmt(Pn, Ax->MnTFmt, Ax->MnTFmt, 1,        /* minor tick format     */
                  Ax->MnTFmt, Ax->MnTFmt, 1);

   mj_tics(Pn, Ax->MjTNum, Ax->MjTNum, 0,           /* number of major ticks */
               Ax->MjTNum, Ax->MjTNum, 0);

   mn_tics(Pn, Ax->MnTNum, Ax->MnTNum, 0,           /* number of minor ticks */
               Ax->MnTNum, Ax->MnTNum, 0);

   num_size(Pn, Ax->NumSize, Ax->NumSize, 1,
                Ax->NumSize, Ax->NumSize, 1);       /* number size           */

   num_intlv(Pn, Ax->NumIntlv, Ax->NumIntlv, 0,     /* num autolevel         */
                 Ax->NumIntlv, Ax->NumIntlv, 0);

   num_gap(Pn, Ax->NumGap, Ax->NumGap, 0,           /* number gaps           */
               Ax->NumGap, Ax->NumGap, 0);

   num_offset(Pn, Ax->NumOffset, Ax->NumOffset, 0,  /* number offsets        */
                  Ax->NumOffset, Ax->NumOffset, 0);

   num_spacing(Pn, Ax->NumSpace, Ax->NumSpace, 0,   /* number spacing        */
                  Ax->NumSpace, Ax->NumSpace, 0);

   num_ends(Pn, 0, 0, 0, 0, 0, 0);                  /* label both ends       */
   lab_size(Pn, Ax->LabSize);                       /* label size            */
   lab_spacing (Pn, Ax->LabSpace);                  /* label spacing         */
   lab_offset (Pn, Ax->LabOffset);                  /* label offsets         */

   Cmd[0] = 1;                                      /* omit end colors       */
   Cmd[1] = 4;                                      /* Min/Max format        */
   Cmd[2] = Ax->Sca;                                /* scaling               */
   Cmd[3] = 1;                                      /* vertical colorbar     */
   Cmd[4] = 1;                                      /* draw colorbar         */
   Cmd[5] = 100;                                    /* end of format info    */
  
   color_bar(Pn, 1, X1, Y1, 0., X2, Y2, 0., Cmd, 
                 Ax->Min, Ax->Max, Pd->CInfo);
   dr_axis(Pn);
   dr_tic(Pn, 6, 1, 0.0);
   num_lab(Pn, 6, 0., 0, "", Ax->NumFmt, 0, 1, 0., 0., C);
  
   S = (struct SrcInfo *) Pd->Src;                     /* source structure   */
   ReadPidf (S->Key, InFo.PIDF);                       /* read PIDF          */
   P = (struct Pidf *) InFo.PIDF;                      /* ptr to pidf info   */
   Pu = (struct PidfUnit *)P->Units + S->GetUN;        /* ptr to sen units   */ 
   Pa = (struct PidfUnit *)P->Units + S->AltUN;        /* alt unit info      */
   X = centertxt (Pn, 4);

   if (S->Col.Fmt == 1)                                /* integral value?    */
   {                                                   /* BEG INTG LABEL     */
      F[0] = 0;                                        /* add integ text     */
      F[1] = -1;                                       /* guess at case      */
      int_label (Pu->LDesc, F, L1);                    /* get unit desc      */
      F[0] = 1;                                        /* to upper case      */
      F[1] = 1;                                        /* integ in scan      */
      F[2] = 0;                                        /* no phi integral    */
      F[3] = 0;                                        /* no theta integral  */
      int_units (Pu->ULab, Pa->ULab, F, L2);           /* form unit part     */
      sprintf (L0, "[%s]", L2);                        /* units label        */
   }                                                   /* END INTG LABEL     */
   else                                                /* no integration     */
   {                                                   /* BEG PIDF LABEL     */
      sprintf (L1, "%s", Pu->LDesc);                   /* units desc label   */
      sprintf (L0, "[%s]", Pu->ULab);                  /* units label        */
    }                                                  /* END PIDF LABEL     */

   text_lab(Pn, 6, X, 1, L1, 0, 0, 1, 0, 0, C);        /* dump unit desc     */
   text_lab(Pn, 6, X, 0, L0, 0, 0, 1, 0, 0, C);        /* dump units         */
}
