#include <stdlib.h>
#include <string.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"

void PlotLVals (ByTe_1 wN, ByTe_4 N, ReaL_4 SubPt, struct ToolInfo *Ti)
{
   extern struct UserDefs InFo;
   extern struct config parm;
   extern struct mapinfo map;

   struct PlotDef *Pd;
   struct window *wn, *wna;

   ReaL_4 X, Y, T, R, mP = -70.0, tM = 11.0;
   ReaL_4 P, pB, pE, dP = 1.0;
   ReaL_4 x1, x2, z1, y1, y2, z2;
   ReaL_4 sx, ix, sy, iy;
   ReaL_4 d1, d2;
   ByTe_2 sLc, *s1;
   ByTe_1 sU, nW = 51;

   Pd = (struct PlotDef *)InFo.PlotDefs + N; 
   window (nW, "LSHELLS");

   wn = parm.win;
   xMin = wn->plot[0];
   yMin = wn->plot[1];
   xMax = wn->plot[3];
   yMax = wn->plot[4];
   nR = Pd->Rows;
   nC = Pd->Cols;
   dC = (xMax - xMin) / nC;
   dR = (yMax - yMin) / nR;
   
   sU = parm.univ;
   sLc = parm.l_color;
   parm.univ = 0;

   s1 = &parm.white;
   clip (nW, 1);
   plt_color (0, *(s1 + Ti->Color4));

   X = sine (map.center);
   Y = cosin (map.center);
   pB = SubPt - 180.0;
   pE = SubPt + 180.0;

   for (R = Ti->LRng[0]; R <= Ti->LRng[1]; R += Ti->LRng[2]) {
      T = tM * cosin (pB + mP) + tM * sine(pB + mP);
      x1 = R * cosin (T) * sine(pB + map.rotlong);
      y1 = R * (cosin (T) * cosin (pB + map.rotlong) * X + sine (T) * Y);
      z1 = Y * cosin(T) * cosin(pB)  - X * sine(T);
      d1 = x1 * x1 + y1 * y1;
      for (P = pB + dP; P <= pE; P += dP) {
         T = tM * cosin (P + mP) + tM * sine(P + mP);
         x2 = R * cosin (T) * sine(P + map.rotlong);
         y2 = R * (cosin (T) * cosin (P + map.rotlong) * X + sine (T) * Y);
         z2 = Y * cosin(T) * cosin(P)  - X * sine(T);
         d2 = x2 * x2 + y2 * y2;
         if ((d1 >= 1.0 && d2 >= 1.0) || (z1 >= 0.0 && z2 >= 0.0))
             line (nW, x1, y1, 0., x2, y2, 0.);
         x1 = x2;
         y1 = y2;
         z1 = z2;
         d1 = d2;
      }
   }

   parm.univ = sU;
   plt_color (0, sLc);
}
