#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include <math.h>

/*****************************************************************************/
/*  This program puts up a plot bow in which a contour can be drawn.         */
/*****************************************************************************/

void PlotCut (ByTe_4 N, ByTe_2 When)
{
   extern struct UserDefs InFo;
   extern struct config parm;

   struct PlotDef *Pd;
   struct CutDef *cD;

   register ReaL_4 *f1, *fEnD;
   register ByTe_4 I;

   ReaL_4 X[200], Y[200], V[200];
   ReaL_4 BiG, Max;
   ByTe_2 C, *s1;
   ByTe_1 Pn; 
   ByTe_1 Cmd[4], Wn;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;          /* plot def struct     */
   if (Pd->CCut == 0)                                 /* no contour cuts     */
      return;                                         /* we're gone          */
   cD = (struct CutDef *)Pd->CCut;                    /* pointer to cut info */
   Pn = cD->CutPn;                                    /* cut plot number     */

   s1 = &parm.white;                                  /* ptr to white        */
   for (I = 0; I < cD->CutPlot; ++I)                  /* cut loop            */
   {                                                  /* BEG CUT LOOP        */
      if (((cD->ShowCut[I] % 2 == 1 && When == 0) || 
           (cD->ShowCut[I] % 2 == 0 && When == 1)) && cD->ShowCut[I] != 0)
      {                                               /* BEG SHOW CUT        */
         Wn = Pd->Wn;                                 /* window to plot cut  */
         clip (Wn, 1);                                /* set clip to on      */
         C = (cD->ShowCut[I] > 2) ? *(s1 + cD->PlotCol[I]) : *s1; 
         plt_color (0, C);
         line (Wn, cD->X1[I], cD->Y1[I], 0., cD->X2[I], cD->Y2[I], 0.);
      }                                               /* END SHOW CUT        */

      if (When == 0)
         continue;

      Cmd[0] = cD->PlotFmt[I];                        /* this osplot format  */
      Cmd[1] = 0;

      BiG = Cut1D(X, Y, V, Y, cD->X1[I], cD->Y1[I], cD->X2[I], cD->Y2[I], 100);

      C = *(s1 + cD->PlotCol[I]);
      if (Pd->Cb.Sca == 1)
      {
         f1 = V;
         Max = -1000.0;
         fEnD = V + 100;
         for ( ; f1 < fEnD; ++f1)
            if (*f1 < BiG && *f1 > Max)
                  Max = *f1;
         
         BiG = 3.0 * pow (10.0, (ReaL_8)Max);
         f1 = V;
         fEnD = V + 100;
         for ( ; f1 < fEnD; ++f1)
            *f1 = (*f1 > Max) ? BiG : pow (10.0, (ReaL_8)*f1);
       
         BiG /= 2.0;
         if (cD->CutPlace == 0)
            set_qual (Pn, 'Y', 'G', BiG);
         else
            set_qual (Pn, 'X', 'G', BiG);
      }
      if (cD->CutPlace == 0)
         plot_2d (Pn, 0, 4, 8, X, V, X, 0, 99, Cmd, C);   
      else
         plot_2d (Pn, 0, 4, 8, V, Y, Y, 0, 99, Cmd, C);   
   }                                                  /* END CUT LOOP        */
}
