#include <stdio.h>
#include <math.h>
#include "util_str.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "libbase_udf.h"
#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void OpenDataFiles ()
{
   extern struct UserDefs InFo;

   struct SrcInfo *Sb, *S;
   struct ToolInfo *T;
   struct PlotDef *Pd;
   struct PlaneInfo *Pn;
   struct AxisInfo *Axb, *Ayl, *Ayr;
   struct TiMiNg Tm;

   u_ByTe_4 KeY = 0;
   ByTe_4   I, J;
   ByTe_2   R, *s1; 
   u_ByTe_2 Vr;
   ByTe_1 TheTa;

   R = create_idf_data_structure (&InFo.UDF);     /* create UDF info struct  */
   ErrorRpt ("CREATE_IDF_DATA_STRUCT", R, 1);     /* report any errors       */

   Pd = (struct PlotDef *)InFo.PlotDefs;          /* plot def structures     */
   for (I = 0; I < InFo.NPDefs; ++Pd, ++I) {      /* BEGIN PLOT DEF LOOP     */
      Tm.Yr = -1;
      SortKeys (I);                               /* Sort Data Keys          */
      Sb = (struct SrcInfo *)Pd->Src;             /* Base of UDF structs     */
      s1 = (ByTe_2 *)Pd->SOrder;                  /* source order array      */
      for (J = 0; J < Pd->EmptySrc; ++J, ++s1) {  /* BEG UDF DEF LOOP        */
         S = Sb + *s1;                            /* source                  */
         S->Eg.Yr = -1;
         if (J == 0 || S->Key != KeY) {           /* BEG NEW SOURCE          */
            get_version_number (&S->Ver);         /* assign version number   */
            GetIt (I, S->Key, S->Ver, &Tm);       /* open and pos source     */
            KeY = S->Key;                         /* save key                */
            Vr = S->Ver;                          /* save version number     */
            if (J == 0 && S->OneAll == 3)
               KeY = 0;
         } else {                                 /* BEG DUPLICATE SOURCE    */
            if (S->OneAll == 3)                   /* full matrix             */
               get_version_number (&S->Ver);      /* assign version number   */
            else
               S->Ver = Vr;                       /* duplicate version num   */
         }                                        /* END DUPLICATE SOURCE    */

         GetPidfStuff(S);                         /* get Pidf information    */
         TheTa = GetVidfStuff(S);                 /* get Vidf information    */

         if (Pd->AData[0] != 2 && Pd->AData[1] != 2 && 
             Pd->AData[0] != 9 && Pd->AData[1] != 9 && 
                    S->SType != 2 && S->Col.Fmt  < 0 && S->UDFSrc != 6)
            S->Col.Fmt = 0;

         if (Pd->AData[1] == 5  && TheTa == 0) {
            Pd->YSet = 1;
            S->Col.Fmt = -1;
         } else {
            if (Pd->AData[0] == 5  && TheTa == 0) {
               Pd->YSet = 1;
               S->Col.Fmt = -1;
            }
         }
      }                                           /* END UDF INITS           */

      T = (struct ToolInfo *)Pd->Tools;               /* Tool info structs   */
      Tm.Yr = -1;
      for (J = 0; J < Pd->NTools; ++J, ++T) {         /* BEG PLOT TOOLS LOOP */
         if (T->Src == 1) {                           /* BEG SRC 0 DEFINED   */
            get_version_number (&T->Vs.Ver);          /* assign version num  */
            GetIt (I, T->Vs.Key, T->Vs.Ver, &Tm);     /* open and pos source */
            GetVPidfStuff (&T->Vs);                   /* load up PIDF info   */
         }                                            /* END SRC 0 DEFINED   */
         if (T->Src1 == 1) {                          /* BEG SRC 1 DEFINED   */
            if (T->Vs.Key != T->Vs1.Key) {            /* BEG NEW SOURCE      */
               get_version_number (&T->Vs1.Ver);      /* assign version num  */
               GetIt (I, T->Vs1.Key, T->Vs1.Ver, &Tm);  /* open and pos src  */
            } else                                    /* END NEW SRC         */
               T->Vs1.Ver = T->Vs.Ver;                /* so same version     */
            GetVPidfStuff (&T->Vs1);                  /* load up PIDF info   */
         }                                            /* END SRC 1 DEFINED   */
         if (T->Src2 == 1) {                          /* BEG SRC 2 DEFINED   */
            if (T->Vs2.Key == T->Vs1.Key)             /* same source as 1?   */
               T->Vs2.Ver = T->Vs1.Ver;               /* so same version     */
            else {                                    /* BEG TEST SRC 0      */
              if (T->Vs.Key != T->Vs2.Key) {          /* BEG NEW SOURCE      */
                get_version_number (&T->Vs2.Ver);     /* assign version num  */
                GetIt (I, T->Vs2.Key, T->Vs2.Ver, &Tm); /* open and pos src  */
              } else                                  /* END NEW SRC         */
                 T->Vs2.Ver = T->Vs.Ver;              /* so same version     */
            }                                         /* END TEST SRC 0      */
            GetVPidfStuff (&T->Vs2);                  /* load up PIDF info   */
         }                                            /* END SRC 2 DEFINED   */
      }                                               /* BEG PLOT TOOLS LOOP */

      if (Pd->Plane != 0) {
          Pn = (struct PlaneInfo *)Pd->Plane;
         if (Pn->VecSrc == 1) {                   /* BEG UDF SRC DEFINED     */
            get_version_number (&Pn->Vs.Ver);     /* assign version number   */
            GetIt (I, Pn->Vs.Key, Pn->Vs.Ver, &Tm); /* open and pos source   */
            GetVPidfStuff (&Pn->Vs);              /* load up PIDF info       */
         }                                        /* END UDF SRC DEFINED     */
      }

      Ayl = &Pd->Yl;                                   /* Left Y axis        */
      Axb = &Pd->Xb;                                   /* Bot X axis         */
      Ayr = &Pd->Yr;                                   /* Right Y axis       */

/*
      if (Pd->AData[0] == 3) {
         if (Axb->Min < 0 || Axb->Max < 0) {
            Axb->PMin = -180;
            Axb->PMax = 180;
         } else {
            Axb->PMin = 0;
            Axb->PMax = 360;
         }
      }
      if (Pd->AData[1] == 3) {
         if (Ayl->Min < 0 || Ayl->Max < 0) {
            Ayl->PMin = -180;
            Ayl->PMax = 180;
         } else {
            Ayl->PMin = 0;
            Ayl->PMax = 360;
         }
      }
*/

      if (Pd->AData[0] != 0)
         Pd->Pb.Yr = -1;
   }                                              /* END PLOT DEF LOOP       */
}
