#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include "libbase_udf.h"

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void MenuUDF (struct PlotDef *Pd, ByTe_2 SrcN)
{
   extern struct MeNuS Ms;
   extern struct WorkArea Wa;

   struct PaGe *Pg;
   struct QuEsTiOnS *Qs, *QsEnd;
   struct SrcInfo *S;

   register ByTe_1  *c1, *c2;

   ByTe_4  PN; 
   ByTe_2  R, Src;
   ByTe_1  TmpS[10], *C;

   /************************************************************/
   /*             IDFS INFO MENU TRANSFER                      */
   /*                                                          */
   /* ID[00]:  SENSORS [0=ONE; 1=ALL]                          */
   /* ID[01]:  PROJECT                                         */
   /* ID[02]:  MISSION                                         */
   /* ID[03]:  EXPERIMENT                                      */
   /* ID[04]:  INSTRUMENT                                      */
   /* ID[05]:  VIRTUAL                                         */
   /* ID[06]:  DATA TYPE                                       */
   /* ID[07]:  DATA GROUP                                      */
   /* ID[08]:  COMPONENT (VIDF SENSOR NUMBER)                  */
   /* ID[09]:  SENSOR UNITS                                    */
   /* ID[10]:  SCAN UNITS                                      */
   /* ID[11]:  VALID DATA RANGE  [MinVal, MaxVal]              */
   /* ID[12]:  ANCILLARY DATA                                  */
   /* ID[13]:  ANCILLARY UNITS                                 */
   /* ID[14]:  MODE DATA                                       */
   /* ID[15]:  MODE UNITS                                      */
   /* ID[16]:  QUALITY UNITS                                   */
   /* ID[17]:  PLOT COLOR                                      */
   /* ID[18]:  PLOT FORMAT                                     */
   /************************************************************/

   c1 = (ByTe_1 *)Wa.CStore + Pd->SrcPN;

   Src = -1;
   while (Src < SrcN)
   {
      c2 = TmpS;
      while (*c1 == ' ')
         ++c1;
      while((*c1 != ' ') && (*c1 != 0))
         *c2++ = *c1++;
      *c2 = 0;
      sscanf (TmpS, "%d", &PN);
      ++Src;
   }

   S = (struct SrcInfo *)Pd->Src + Pd->EmptySrc++;
   Pg = (struct PaGe *) Ms.page + PN;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ;

   S->GetUN = -1;
   S->AltUN = -1;
   S->SAltUN = -1;
   S->AltSB = -1;
   S->GetPN = -1;
   S->SenPN = -1;
   S->SAltPN = -1;
   S->SecPN = -1;
   S->Col.Fmt = -1;
   S->Col.NewHdr = 1;
   S->Col.N = 1;
   S->PAxis = 4;
   S->Pri = 0;
   S->Alt = 0;
   S->AddErr = -1;

   for ( ; Qs < QsEnd; ++Qs)
   {
      switch (Qs->ID)
      {
         case 0:
            S->OneAll = Qs->OpReply;
         break;
         case 1:
            S->P = TransFer (Qs->CReply, 1, 0);
         break;
         case 2:
            S->M = TransFer (Qs->CReply, 1, 0);
         break;
         case 3:
            S->E = TransFer (Qs->CReply, 1, 0);
         break;
         case 4:
            S->I = TransFer (Qs->CReply, 1, 0);
         break;
         case 5:
            S->V = TransFer (Qs->CReply, 1, 0);
         break;
         case 6:
            sscanf (Qs->AltVal, "%hd", &S->DType);
         break;
         case 7:
            S->Group = (Qs->state == 1) ? Qs->OpReply : -1;
         break;
         case 8:
            if (Qs->state == 1)
               sscanf (Qs->AltVal, "%hd", &S->SenPN);
            else
               S->SenPN = 0;
         break;
         case 9:
         case 15:
         case 16:
            if (Qs->state == 1)
               sscanf (Qs->AltVal, "%hd", &S->GetUN);
         break;
         case 13:
            if (Qs->state == 1)
            {
               if (Pd->AData[0] == 9 || Pd->AData[1] == 9)
                  sscanf (Qs->AltVal, "%hd", &S->SAltUN);
               else
                  sscanf (Qs->AltVal, "%hd", &S->GetUN);
            }
         break;
         case 10:
            if (Qs->state == 1)
            {
               sscanf (Qs->AltVal, "%hd", &S->AltUN);
               S->AltSB = Qs->OpReply;
            }
         break;
         case 11:
            BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
            sscanf (Qs->CReply, "%f %f", &S->MinValid, &S->MaxValid);
         break;
         case 12:
         case 14:
            if (Qs->state == 1)
            {
               if (Pd->AData[0] == 9 || Pd->AData[1] == 9)
                  sscanf (Qs->AltVal, "%hd", &S->SAltPN);
               else
                  sscanf (Qs->AltVal, "%hd", &S->GetPN);
            }
         break;
         case 17:
            S->PCol = Qs->OpReply;
         break;
         case 18:
            S->LpType = Qs->OpReply;
         break;
         case 19:
            S->PAxis = Qs->OpReply;
            Pd->AxisDef |= (S->PAxis == 4) ? 1 : 2;
         break;
         case 20:
            S->Col.Fmt = (Qs->state == 1) ? Qs->OpReply : -1;
         break;
         case 21:
            sscanf (Qs->CReply, "%f", &S->Col.Start);
         break;
         case 22:
            sscanf (Qs->CReply, "%f", &S->Col.Stop);
         break;
         case 23:
            sscanf (Qs->CReply, "%hd", &S->Col.N);
         break;
         case 24:
            S->Col.Pos = (Qs->state > 0) ? Qs->OpReply : 0;
         break;
         case 25:
            S->Col.Sca = (Qs->state > 0) ? Qs->OpReply : 0;
         break;
         case 26:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%hd", &S->SenCN);
            else
               S->SenCN = 0;
         break;
         case 27:
            if (Qs->state == 1)
               S->ScatSym = TransFer (Qs->CReply, 1, 0);
            else
               S->ScatSym = 0;
         break;
         case 28:
            if (Qs->state == 1)
               S->SymSize = TransFer (Qs->CReply, 1, 0);
         break;
         case 29:
            if (Qs->state == 1)
               S->AddErr = Qs->OpReply;
         break;
         case 30:
            if (Qs->state == 1)
               S->ECol = Qs->OpReply;
         break;
      }
   }

   if (S->DType < 2)
      S->GetPN = S->SenPN;

   C = (ByTe_1 *)Wa.CStore;                  
   R = get_data_key (C + S->P, C + S->M, C + S->E, C + S->I, C + S->V, &S->Key);
   ErrorRpt ("GET_DATA_KEY", R, 1); 

   GrowSrcs (Pd, S->OneAll);
}
