#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void MenuInterface (void)
{
   extern struct MeNuS Ms;
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern ByTe_2 BatchTime[];

   struct PaGe *Pg;
   struct QuEsTiOnS *Qs, *QsEnd;

   ReaL_4 tF;
   ByTe_4  H, M, S, B;
   ByTe_2  N;

   Wa.SStore = 0;
   Wa.CStore = 0;
   Wa.SizeCStore = 0;
   Wa.SizeSStore = 0;
   Wa.NextCStore = 0;
   Wa.NextSStore = 0;

   InFo.PlotDefs = 0;
   InFo.EmptyPd = 0;
   InFo.Dups = 1;
   InFo.DupYb = 0.0;

/*****************************************************************************/
/*                            MAIN MENU                                      */
/*                                                                           */
/* ID[00] OUTPUT DEVICE                                                      */
/* ID[01] COLOR TABLE                                                        */
/* ID[02] BEGINNING TIME    [YY, DD, HH, MM, SS]                             */
/* ID[03] ENDING TIME       [YY, DD, HH, MM, SS]                             */
/* ID[04] SHOW DEFAULT MENU [YES - NO]                                       */
/* ID[05] TIME STAMP        [YES - NO]                                       */
/* ID[06] DEFINE PLOT                                                        */
/* ID[07] PLOT MODE                                                          */
/* ID[08] PLOT OFFSETS                                                       */
/*                                                                           */
/*****************************************************************************/

   Pg = (struct PaGe *) Ms.page;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ; 

   for ( ; Qs < QsEnd; ++Qs)
   {
      switch (Qs->ID)
      {
         case 0:
            InFo.Dev = Qs->OpReply; 
         break;
         case 1:
            InFo.Ctable = TransFer (Qs->AltVal, 1, 0);
         break;
         case 2:
            BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
            sscanf (Qs->CReply, Qs->Fmt, &InFo.TB.Yr, &InFo.TB.Dy, &H, &M, &S);
            if (BatchTime[0] >= 0)
            {
               InFo.TB.Yr = BatchTime[0];
               InFo.TB.Dy = BatchTime[1];
               InFo.TB.Ms = (BatchTime[2] * 3600 + BatchTime[3] * 60 + 
                             BatchTime[4]) * 1000;
            }
            else
               InFo.TB.Ms = (H * 3600 + M * 60 + S) * 1000;
         break;
         case 3:
            BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
            sscanf (Qs->CReply, Qs->Fmt, &InFo.TE.Yr, &InFo.TE.Dy, &H, &M, &S);
            if (BatchTime[0] >= 0)
            {
               InFo.TE.Yr = BatchTime[5];
               InFo.TE.Dy = BatchTime[6];
               InFo.TE.Ms = (BatchTime[7] * 3600 + BatchTime[8] * 60 + 
                             BatchTime[9]) * 1000;
            }
            else
               InFo.TE.Ms = (H * 3600 + M * 60 + S) * 1000;
         break;
         case 4:
            InFo.DefMenu = Qs->OpReply;
         break;
         case 5:
            InFo.TimeStamp = Qs->OpReply;
         break;
         case 6:
           InFo.NPDefs = Qs->NWins;
            InFo.PSrcs = TransFer (Qs->Wins, 1, 0);
            B = InFo.NPDefs * sizeof (struct PlotDef);
            if ((InFo.PlotDefs = realloc (InFo.PlotDefs, B)) == 0)
               exit(-1); 

            for (N=0; N < InFo.NPDefs; ++N)
                MenuPlotDef(N);
         break; 
         case 7:
            InFo.PMode = Qs->OpReply;
         break;
         case 8:
            BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
            sscanf (Qs->CReply, "%f %f %f %f",
                                 &InFo.Xl, &InFo.Xr, &InFo.Yt, &InFo.Yb);
         break;
         case 9:
            InFo.Lm.Fmt = Qs->OpReply;
         break;
         case 10:
            InFo.Lm.LocB = Qs->OpReply;
         break;
         case 11:
            sscanf (Qs->CReply, "%f", &InFo.Lm.XOff);
         break;
         case 12:
            sscanf (Qs->CReply, "%f", &InFo.Lm.YOff);
         break;
         case 13:
            sscanf (Qs->CReply, "%hd", &InFo.Lm.Size);
         break;
         case 14:
            InFo.Lm.Color = Qs->OpReply;
         break;
         case 15:
            if (Qs->state == 1)
               InFo.Lm.UDefLab = TransFer (Qs->CReply, 1, 0);
            else
               InFo.Lm.UDefLab = 0;
         break;
         case 16:
            BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
            sscanf (Qs->CReply, "%f %f", &tF, &InFo.DupYb);
            InFo.Dups = (ByTe_4)tF;
            if (InFo.Dups <= 0)
                InFo.Dups = 1;
         break;
      }
   }
}
