/****************************************************************************/
/*  This routine takes a sweep of data and averages over the scan variable  */
/*  from From to To.  The data bins are centered on the scan values         */
/****************************************************************************/

#include <stdio.h>
#include <math.h>
#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ReaL_4 IntOverX (ByTe_4 PN, ByTe_4 SrcN, ByTe_4 Bn, ByTe_4 *EnDs)
{
   extern struct UserDefs InFo;

   struct PlotDef *Pd;
   struct SrcInfo *S;

   register ReaL_4 *fx, *fy, *fX, *fE; 

   ReaL_4 L, R, Top, Bot, Cen;
   ReaL_4 Lend, Rend;

   ReaL_4 Intg = 0.0;
   ReaL_4 Nrm;
   ByTe_4 N = 0;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;       /* this plot definition  */
   S = (struct SrcInfo *)Pd->Src + SrcN;            /* and this source       */
   EnDs[0] = -1;                                    /* beg step              */
   EnDs[1] = -1;                                    /* end step              */

   GetBinStats (&S->Col, Bn, &Bot, &Top, &Cen, 0);  /* get average limits    */
   fx = S->Alt;                                     /* ptr to 1st in X array */
   fy = S->Pri;                                     /* ptr to 1st in Y array */
   fX = fx + 1;                                     /* ptr to 2nd in X array */
   fE = fx + S->DLen - 1;                           /* ptr to last X value   */

   Lend = *fx - (*(fx + 1) - *fx)/2.0;              /* absolute left edge    */
   Rend = *fE + (*fE - *(fE - 1)) / 2.0;            /* absolute right edge   */

   if (*(fx + 1) > *fx)                             /* increasing X          */
   {
      if (Top <= Lend || Bot >= Rend)               /* rng out of bounds?    */
         return (FILL);                             /* return below all      */
   }
   else
   {
      if (Bot >= Lend || Top <= Rend)               /* rng out of bounds?    */
         return (FILL);                             /* return below all      */
   }

   L = Lend;                                        /* left edge 1st bin     */
  
   do                                               /* all but last bin      */
   {
      R = *fx + (*fX++ - *fx)/2.0;                    /* right edge 1st bin  */
      Nrm = PerCentAge (L, R, Bot, Top);              /* normalization       */
      if (*fy <= S->MaxValid && *fy >= S->MinValid)   /* value in bounds?    */
      {                                               /* BEGIN PROCESS VAL   */
         if (Nrm > 0.0)                             /* data in range         */
         {                                          /* BEG ADD IN DATA       */
            if (EnDs[0] < 0) EnDs[0] = N;           /* this is first bin     */
            EnDs[1] = N;                            /* this is last bin      */
            Intg += *fy * Nrm * (R - L);            /* trapazoidal area      */
         }                                          /* END ADD IN DATA       */
      }                                             /* BEGIN PROCESS VAL     */

      ++fy;
      L = R;                                        /* right edge to left    */

   }  while (++fx < fE);                            /* loop over all data    */

   R = Rend;                                        /* right is end          */
   Nrm = PerCentAge (L, R, Bot, Top);               /* normalization         */
   Intg += *fy * Nrm * (R - L);                     /* trapazoidal area      */

   if (Intg < 0.0)                                  /* scan went big to lit? */
      Intg = -Intg;                                 /* compensate            */
   return (Intg);
}
