#include <stdio.h>
#include <stdlib.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void Gen2DPlots (ByTe_4 PNuM)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern struct config parm;

   struct PlotDef *Pd;
   struct SrcInfo *S;

   register ReaL_4 *Ws;

   void   *Sc, *Ln;
   ReaL_4 *Y, *V, *Y2, *N;
   ReaL_4 X[2], Cen;
   ByTe_4 J, K, TotP, Beg, End, pN, nP, PN;
   ByTe_2 rV;
   ByTe_1 Cmd[3], Ax, SaveU, Gn, New;
   ByTe_1 CanIgn, tBase;

   PN = PNuM % InFo.NPDefs;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;          /* plot def struct    */
   S = (struct SrcInfo *)Pd->Src;                      /* pntr to first src  */
   nP = S->Col.N;                                      /* num of collapses   */
   TotP = Pd->Rows * Pd->Cols - Pd->ExPlots;           /* total plots        */
   PlotInits (PN);                                     /* init plot params   */
   Ln = 0;
   CanIgn = (Pd->AlignPd < PN && Pd->AlignPd >= 0) ?   /* ignore blanks flag */
             0 : (Pd->IgnBlank == 0) ? 1 : 0;

   Cmd[0] = 'y';                                       /* All plots || y     */
   if (Pd->Bx.Fmt == 1) {                              /* BEG USER BIN SETS  */
      Cmd[1] = '0';                                    /* poly output        */
      Ax = 0;                                          /* always lower axis  */
   } else {                                            /* BEG PIXEL BIN SETS */
      Cmd[1] = '0';                                    /* line output        */
      Ax = 2;                                          /* always upper axis  */
   }                                                   /* END PIXEL BIN SETS */
   Cmd[2] = 0;                                         /* end of string      */

   PopUpCBar (PNuM);                                   /* colorbar           */

   K = 0;                                              /* 1st plot in series */
   while (K < TotP)                                    /* loop over plots    */
   {                                                   /* BEG DO ALL PLOTS   */
      TimeAlign (PN, K, 0); 
      rV = BuildPlots (PN);                            /* build plots        */
      TimeAlign (PN, K, 1); 
      if ((Pd->PStat == 0 && rV == 0) || 
            (Pd->PStat == 0 && Pd->More == -1))
         break;                                        /* done               */
          
      if (Pd->PStat == 0 && CanIgn) {                  /* BEG IGNORE EMPTIES */
         Pd->Pb.Yr = S->Bt.Yr;                           /* end yr to beg yr */
         Pd->Pb.Dy = S->Bt.Dy;                           /* end dy to beg dy */
         Pd->Pb.Ms = S->Bt.Ms;                           /* end ms to beg ms */
         IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, Pd->Tm.Sca, 1); /* next plot tms */
         continue;                                          /* try the next  */
      }                                                /* END IGNORE EMPTIES */

      New = 1;                                         /* new tool data      */
      Ws = (ReaL_4 *)Wa.WorkSpace;                     /* ptr to plot data   */
      End = FormEdges (PN, &Sc, 'Y', 1, 0) - 1;        /* form Y bin edges   */
      Y = (ReaL_4 *)Sc;                                /* pointer to edges   */
      for (pN = 0; pN < nP; ++pN)                      /* collapse plot loop */
      {                                                /* BEG PLOT LOOP      */
          V = Ws + 2 * Pd->PlotLen * pN;               /* plot pointer       */
          N = V + Pd->PlotLen;                         /* normal pointer     */
          Normalize (V, N, Pd->PlotLen, 1, 0.0);       /* normalize data     */
          FillGaps (PN, pN, 'X');                      /* fill gaps along X  */
          FillGaps (PN, pN, 'Y');                      /* fill gaps along Y  */
          
          SaveU = parm.univ;                           /* save plot univ     */
          if (Pd->OutFmt == 0)                         /* cartesian output   */
          {                                            /* BEG CARTESIAN      */
             SetUpRecPlot (PNuM, K, 0);                /* set up plot        */
             Gn = Pd->Pn;                              /* plot to plot       */
          }                                            /* END CARTESIAN      */
          else
          {                                            /* BEG CARTEOGRAPHIC  */
             SetUpMapPlot (PNuM, K);                   /* set up plot        */
             Cmd[1] = '0';                             /* poly output        */
             Ax = 0;                                   /* always lower axis  */
             Gn = Pd->Wn;                              /* plot to window     */
             parm.univ = Pd->OutFmt + 8;               /* set new univ       */
          }                                            /* END CARTEOGRAPHIC  */
          if (Pd->LSCut != 0)                          /* LShell plot?       */
             SetUpRecPlot (PNuM, K, 2);                /* set up plot        */

          Beg = 0;                                     /* beg of data        */
          Y2 = 0;                                      /* pixel plotting     */
          PopUpPlot (PN, 1, 0);                        /* plot box and text  */
          if (Pd->PStat == 1) {                        /* BEG NONEMPTY PLOT  */
             for (J = 1; J <= Pd->Bx.N; )              /* plot bin loop      */
             {                                         /* BEG PLOT BIN LOOP  */
                TFerLine (PN, pN, J-1, 'Y', &Ln);      /* xfer one plot line */
                V = (ReaL_4 *)Ln;                      /* ptr to scan line   */
                if (Cmd[1] == '0')
                   GetBinStats (&Pd->Bx, J++ - 1, X, &X[1], &Cen, 0);
                else
                   *X = J++;
                plot_3d (Gn, Ax, 4, 8, X, Y, X, V, Y2, 
                        Beg, End, Cmd, Pd->CInfo, Pd->Cb.Sca);
             }
             parm.univ = SaveU;                        /* restore univ       */
             Tools (PN, 0, 1, New, 0);                 /* vector plot tool   */
             Tools (PN, 0, 3, New, pN);                /* Draw Globe         */
             Tools (PN, 0, 4, New, pN);                /* Draw Object        */
          }                                            /* END NONEMPTY PLOT  */
          parm.univ = SaveU;                           /* restore univ       */
          PopUpPlot (PN, 0, 0);                        /* plot box and text  */
          New = 0;                                     /* hold vector data   */
          PlotText (PNuM, 0, K, 0, 0);                 /* Per Plot Labels    */
          if (Pd->OutFmt == 0)                         /* cartesian output   */
             AxisLabs (PN, K++, 0);                    /* axis labels        */
          else                                         /* carteographic      */
             ++K;                                      /* just advance plot  */
      }                                                /* END PLOT LOOP LOOP */

      ZeroWkSp();                                      /* clear plot arrays  */
      if (CanIgn) {                                    /* BEG RESET TIME     */
         Pd->Pb.Yr = S->Bt.Yr;                         /* end yr to beg yr   */
         Pd->Pb.Dy = S->Bt.Dy;                         /* end dy to beg dy   */
         Pd->Pb.Ms = S->Bt.Ms;                         /* end ms to beg ms   */
      }                                                /* END RESET TIME     */

      if (Pd->Tm.Fmt != 0) {
         if (Pd->Tm.OrigSca == 9) {
            tBase = (CanIgn) ? Pd->Tm.OrigSca : Pd->Tm.Sca;
            IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, tBase, 0);
         } else 
            IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, Pd->Tm.Sca, CanIgn);
      }

      if (Sc != 0)                                     /* edge mem to free?  */
      {                                                /* BEG FREE EDGE MEM  */
         free (Sc);                                    /* let it go          */
         Sc = 0;                                       /* free at last       */
      }                                                /* END FREE EDGE MEM  */

      if (rV == 0)                                     /* out of data        */
         break;                                        /* then done          */
   }                                                   /* END DO ALL PLOTS   */
   if (Ln != 0)                                        /* any edge memory?   */
      free (Ln);                                       /* free it up         */
}

