/*****************************************************************************/
/*  This routine saves the polar coordinates of a scan and the corresponding */
/*  intensities for later conversion to cartesian coordinates for polar      */
/*  plots                                                                    */
/*****************************************************************************/

#include <stdio.h>
#include <math.h>
#include "OpSySInD.h"
#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void FullPolar (ByTe_4 PN, ByTe_4 SrcN)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct ConTouR *Ct;
   struct SrcInfo *S;

   register ReaL_4 *I, *L, *P, *V, *EnD;
   ReaL_4 *X, *Y, *Z, *T;
   ByTe_4 Len;
   ByTe_1 *Cs, *Sp;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;        /* plot definition info */
   S = (struct SrcInfo *)Pd->Src + SrcN;             /* source info          */
   Ct = (struct ConTouR *)Pd->Cont;                  /* contour information  */

   Cs = (ByTe_1 *)Wa.CStore;

   I = (ReaL_4 *)S->Pri;                             /* intensities          */
   L = (ReaL_4 *)S->Alt;                             /* lengths              */
   Sp = Cs + Pd->SecPos + 3;                         /* Sec offsets: spin    */
   P = (ReaL_4 *)S->Sec + *Sp * S->DLen;             /* phase angle          */
   EnD = I + S->DLen;                                /* sweep end            */

   V = (ReaL_4 *)Wa.WorkSpace + Pd->PlotLen;         /* intensity            */
   if (Ct->Method == 0)                              /* 3D data              */
   {                                                 /* BEG 3D               */
      Len = Wa.SizeWork / 7;                         /* length each varaible */
      X = V + 4 * Len;                               /* magnitude            */
      Y = X + Len;                                   /* phi                  */
      Z = Y + Len;                                   /* theta                */
      Sp = Cs + Pd->SecPos + 5;                      /* Sec offsets: spin    */
      T = (ReaL_4 *)S->Sec + *Sp * S->DLen;          /* theta angle          */

      for ( ; I < EnD; )                             /* sweep loop           */
      {                                              /* BEG SWEEP LOOP       */
         *X++ = *L++;                                /* Magnitude            */
         *Y++ = M_PI * *P++ / 180.0;                 /* Phi in Radians       */
         *Z++ = M_PI * *T++ / 180.0;                 /* Theta in Radians     */
         *V++ = *I++;                                /* Intensity            */
      }                                              /* END SWEEP LOOP       */
   }                                                 /* END 3D               */
   else                                              /* normal 2D data       */
   {                                                 /* BEG 2D               */
      Len = Wa.SizeWork/3;                           /* length each varaible */
      X = V + Len;                                   /* magnitude            */
      Y = X + Len;                                   /* phi                  */

      for ( ; I < EnD; )                             /* sweep loop           */
      {                                              /* BEG SWEEP LOOP       */
         *X++ = *L++;                                /* Magnitude            */
         *Y++ = M_PI * *P++ / 180.0;                 /* Phi in Radians       */
         *V++ = *I++;                                /* Intensity            */
      }                                              /* END SWEEP LOOP       */
   }                                                 /* END 2D               */
   Pd->PlotLen += S->DLen;                           /* data array length    */
}
