#include <stdio.h>
#include <math.h>
#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "UDFpltDefs.h"

ReaL_4 FracTm (struct TiMiNg *Bt, struct TiMiNg *Et, struct TiMiNg *Vb,
                struct TiMiNg *Ve, ByTe_1 *FwD)
{
   ReaL_4 Frac;
   ReaL_8 T1, V1, T2, V2;
   ByTe_4 Y, dY;

   *FwD = 0;
   if (Vb->Yr <= 0)                                 /* time not set!         */
       return (0.0);                                /* amscray!              */

   T1 = Bt->Dy * 86400000.0 + Bt->Ms;               /* begin relative msec   */

   dY = 0;                                          /* initialize delta yrs  */
   Y = Bt->Yr;                                      /* 1st yr to begin yr    */
   while (Y < Et->Yr)                               /* loop over years       */
   {                                                /* BEGIN YEAR LOOP       */
     dY += LeaP(Y);                                 /* days in year          */
     ++Y;                                           /* increment current yr  */
   }                                                /* BEGIN YEAR LOOP       */
   T2 = (dY + Et->Dy) * 86400000.0 + Et->Ms;        /* relative msec         */

   dY = 0;                                          /* initialize delta yrs  */
   Y = Vb->Yr;                                      /* beginning vector year */
   while (Y < Et->Yr)                               /* loop over years       */
   {                                                /* BEGIN YEAR LOOP       */
     dY += LeaP(Y);                                 /* days in year          */
     ++Y;                                           /* increment current yr  */
   }                                                /* BEGIN YEAR LOOP       */
   V1 = (dY + Vb->Dy) * 86400000.0 + Vb->Ms;        /* relative beg vec time */

   dY = 0;                                          /* initialize delta yrs  */
   Y = Ve->Yr;                                      /* ending vector year    */
   while (Y < Et->Yr)                               /* loop over years       */
   {                                                /* BEGIN YEAR LOOP       */
     dY += LeaP(Y);                                 /* days in year          */
     ++Y;                                           /* increment current yr  */
   }                                                /* BEGIN YEAR LOOP       */
   V2 = (dY + Ve->Dy) * 86400000.0 + Ve->Ms;        /* relative end vec time */


   if ((V1 >= T2) || (V2 <= T1))                    /* no overlap?           */
   {                                                /* BEG NO OVERLAP        */
      Frac = 0.0;                                   /* set it here           */
      if (T1 >= V2)                                 /* need next record      */
         *FwD = 1;                                  /* yes we do             */
   }                                                /* END NO OVERLAP        */
   else                                             /* some overlap          */
   {                                                /* BEGIN SOME OVERLAP    */
      if ((V1 >= T1) && (V2 <= T2))                 /* total inclusion?      */
      {                                             /* BEG ALL IN THIS REC   */
         Frac = 1.0;                                /* set total overlap     */
         *FwD = 1;                                  /* stay here             */
      }                                             /* END ALL IN THIS REC   */
      else                                          /* partial overlap       */
      {                                             /* BEGIN PARTIAL OVERLAP */
         if (V1 >= T1)                              /* back end out          */
            Frac = (T2 - V1)/(V2 - V1);             /* this is frac          */
         else                                       /* front end out         */
            Frac = (V2 - T1)/(V2 - V1);             /* this is frac          */
         *FwD = (T2 < V2) ? 0 : 1;                  /* end in this rec?      */
      }                                             /* END PARTIAL OVERLAP   */
   }                                                /* END SOME OVERLAP      */

   return (Frac);
}
