/**************************************************************************/
/*  This routine figures out what needs to be malloced and how many bytes */
/*  to allocate for each item.  A great deal of this routine is spent in  */
/*  trying to guess how much data we will need to buffer up.   In essence */
/*  we are trying to allocate enough space to hold either all the data    */
/*  collected or the Mesh space being used.  If a mesh is being used then */
/*  remember to malloc enough space to hold at the one data sweep which   */
/*  is read in before storage.                                            */
/*                                                                        */
/*  The routine will also allocate the amount of space needed for the     */
/*  building of the input contour data                                    */
/*                                                                        */
/**************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "util_str.h"
#include "user_defs.h"
#include "libbase_udf.h"
#include "UDFpltAnsi.h"

void FirstMemGets (struct PlotDef *Pd, ByTe_4 SrcN)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct idf_data  *ExDa;
   struct SrcInfo *S;

   size_t Ba, Bp, Bs = 0, Bytes;
   ByTe_2 Blks, aB;
   ByTe_1 *Cs, *Sp;

   ExDa = (struct idf_data *) InFo.UDF;           /* ptr to data             */
   S = (struct SrcInfo *) Pd->Src + SrcN;         /* source structure        */
   S->Sec = 0;                                    /* no secondary mem - yet  */

   Cs = (ByTe_1 *)Wa.CStore;                      /* 1 byte data storage     */
   Sp = Cs + Pd->SecPos;                          /* Sec data offsets        */
   Blks = *(Sp + DATADEFS);                       /* sec data blocks needed  */

   aB = (Pd->AData[0] == 9 || Pd->AData[1] == 9) ? 5 : 4;
   switch (S->DType)                              /* memory by data type     */ 
   {                                              /* BEG DATA TYPE SWITCH    */
      case 0:                                     /* START SENSOR DATA       */
         S->DSize = ExDa->num_sample;             /* starting data mem size  */
         Bp = 2 * S->DSize * sizeof (ReaL_4);     /* pri bytes needed        */
         Ba = aB * S->DSize * sizeof (ReaL_4);    /* alt bytes needed        */
      break;                                      /* STOP SENSOR DATA        */
      case 1:                                     /* START SCAN DATA         */
         S->DSize = ExDa->num_sample;             /* starting data mem size  */
         Bp = 0;                                  /* pri bytes needed        */
         Ba = 4 * S->DSize * sizeof (ReaL_4);     /* alt bytes needed        */
         Bs = aB * S->DSize * sizeof (ReaL_4);    /* phi angle data          */
      break;                                      /* STOP SCAN/SENSOR DATA   */
      case 2:                                     /* START SCAN DATA         */
         S->DSize = ExDa->num_sample;             /* starting data mem size  */
         Bp = 2 * S->DSize * sizeof (ReaL_4);     /* pri bytes needed        */
         Ba = 4 * S->DSize * sizeof (ReaL_4);     /* alt bytes needed        */
         Bs = aB * S->DSize * sizeof (ReaL_4);    /* phi angle data          */
      break;                                      /* STOP SCAN/SENSOR DATA   */
      case 6:                                     /* START MODE DATA         */
         S->DSize = 1;                            /* starting data mem size  */
         Bp = 2 * S->DSize * sizeof (ReaL_4);     /* pri bytes needed        */
         Ba = 0;                                  /* alt bytes needed        */
      break;                                      /* STOP MODE DATA          */
   }                                              /* END DATA TYPE SWITCH    */
   Bs = Blks * S->DSize * sizeof (ReaL_4);        /* sec data blks needed    */

   S->DSize *= 2;                                 /* pri data size           */
   if (Bp > 0)                                    /* need primary memory?    */
      if ((S->Pri = malloc(Bp)) == 0)             /* memory for sen data     */
            ErrorRpt ("FirstMemGet", 0, 2);       /* oops - error and split  */

   if (Ba > 0) {                                  /* need alternate memory?  */
      if ((S->Alt = malloc(Ba)) == 0)             /* memory for sen data     */
            ErrorRpt ("FirstMemGet", 0, 2);       /* oops - error and split  */
      if ((S->Bins = realloc (S->Bins, 2 * Ba)) == 0) 
            ErrorRpt ("FirstMemGet", 0, 2);
   }

   if (Bs > 0)                                    /* need alternate memory?  */
      if ((S->Sec = malloc(Bs)) == 0)             /* memory for sen data     */
            ErrorRpt ("FirstMemGet", 0, 2);       /* oops - error and split  */

   Wa.SizeScr = 4 * ExDa->num_sample;
   Bytes = sizeof(ReaL_4) * Wa.SizeScr;
   if ((Wa.Scratch = malloc(Bytes)) == 0)
      ErrorRpt ("FirstMemGet", 0, 2);
   
   PixRes (Pd, SrcN);                             /* get pixel resolutions   */
   GetWorkSpace (Pd);                             /* check workspace array   */
}
