#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "gph_opind.h"
#include "gph_shortcut_defs.h"

void DrTerminator (ByTe_4 N, ReaL_4 GsT, struct ToolInfo *Ti)
{
   extern struct UserDefs InFo;
   extern struct config parm;
   extern struct WorkArea Wa;
   extern struct mapinfo map;

   struct PlotDef *Pd;
   struct ToolInfo *TI, *TiEnD;

   ReaL_4 Mag, cGsT, sGsT, Xoff;
   ReaL_4 LaT, LnG, AnG;
   ReaL_4 aR, R;
   ReaL_4 Y1, Z1, gLnGo, gLaTo, gLnGs, gLaTs, gLaT, gLnG;
   ByTe_1 SUniV, Ewn;

   ReaL_4 Ox, Oy, Oz;
   ReaL_4 Ex, Ey, Ez;
   ReaL_4 Sx, Sy, Sz;
   ReaL_4 X, Y, Z;
   ReaL_4 MagE, MagO;
   ReaL_4 Re = 6371.0, A;

   ReaL_4 A11, A12, A13;
   ReaL_4 A21, A22, A23;
   ReaL_4 A31, A32, A33;

   ReaL_4 RToD;
   ByTe_2 *s1, C, SaveCsize, SVcolor;
   ByTe_1 *Cp, pP, DrFmt = -1;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;         /* plot info struct     */

   TI = (struct ToolInfo * ) Pd->Tools;              /* Tool info            */
   TiEnD = TI + Pd->NTools;                          /* End of Tool info     */
   for ( ; TI < TiEnD; ++TI)                         /* loop over tools      */
   {                                                 /* BEG TOOL LOOP        */
      if (TI->Type == 3) {                           /* BEG DO TOOL          */
         DrFmt = TI->GlobeFmt;                       /* globe format         */
         break;                                      /* end loop             */
      }                                              /* END DO TOOL          */
   }                                                 /* END TOOL LOOP        */

   if (DrFmt < 0) return;                            /* no globe - ciao      */ 

   SVcolor = parm.l_color;                           /* current line color   */
   SUniV = parm.univ;                                /* current plot fmt     */
   Cp = (ByTe_1 *)Wa.CStore;                         /* misc char info       */
   SaveCsize = parm.csize;                           /* current char size    */
   RToD = 180.0 / M_PI;                              /* radians to degrees   */
   s1 = &parm.white;                                 /* pointer to white     */
   C = *(s1 + Ti->Color3);                           /* terminator color     */
   plt_color (0, C);                                 /* set color            */

   if (Pd->OutFmt > 0)                               /* map output           */
      parm.univ = Pd->OutFmt + 8;                    /* carteographic fmt    */
   else                                              /* normal plot          */
      set_axis (Pd->Pn, 0, 4, 8);                    /* set to scaled axes   */

   MagE = sqrt (Ti->Avg[0] * Ti->Avg[0] + Ti->Avg[1] * Ti->Avg[1] + 
             Ti->Avg[2] * Ti->Avg[2]);               /* Earth/Sat Distance   */
   Ex = Ti->Avg[0] / MagE;                           /* Unit GCI S/C  X      */
   Ey = Ti->Avg[1] / MagE;                           /* Unit GCI C/C  Y      */
   Ez = Ti->Avg[2] / MagE;                           /* Unit GCI S/C  Z      */

   Mag = sqrt (Ti->Avg1[0] * Ti->Avg1[0] + Ti->Avg1[1] * Ti->Avg1[1] 
               + Ti->Avg1[2] * Ti->Avg1[2]);         /* Mag Spin Axis Vector */
   Sx = Ti->Avg1[0]/Mag;                             /* Unit GCI Spin Axis X */
   Sy = Ti->Avg1[1]/Mag;                             /* Unit GCI Spin Axis Y */
   Sz = Ti->Avg1[2]/Mag;                             /* Unit GCI Spin Axis Z */

   MagO = sqrt (Ti->Avg2[0] * Ti->Avg2[0] + Ti->Avg2[1] * Ti->Avg2[1] 
               + Ti->Avg2[2] * Ti->Avg2[2]);         /* Mag Object Vector    */
   Ox = Ti->Avg2[0]/MagO;                            /* Unit GCI Object X    */
   Oy = Ti->Avg2[1]/MagO;                            /* Unit GCI Object Y    */
   Oz = Ti->Avg2[2]/MagO;                            /* Unit GCI Object Z    */

   A = atan2 (1.0, MagE/Re) * RToD;                  /* Ang radius of Earth  */
   cGsT = cos (GsT);                                 /* Cos Grnwich Sider Tm */
   sGsT = sin (GsT);                                 /* Sin Grnwich Sider Tm */

   X = cGsT * Ox + sGsT * Oy;                        /* Object Geo X         */
   Y = -sGsT * Ox + cGsT * Oy;                       /* Object Geo Y         */
   gLnGo = atan2 (Y, X) * RToD;                      /* Object Geo Longitude */
   gLaTo = atan2 (Oz, sqrt(X * X + Y * Y)) * RToD;   /* Object Geo Latitude  */

   /**************************************************************************/
   /* Compute the equivalent geographic latitude and longitude of the object */
   /* and the satellite spin axis.                                           */
   /**************************************************************************/

   X = cGsT * Ex + sGsT * Ey;                          /* X proj onto earth  */
   Y = -sGsT * Ex + cGsT * Ey;                         /* Y proj onto earth  */
   gLnG = atan2 (Y, X) * RToD;                         /* Object Longitude   */
   gLaT = atan2 (Ez, sqrt(X * X + Y * Y)) * RToD;      /* Object Latitude    */

   X = cGsT * Sx + sGsT * Sy;                          /* X proj Spin axis   */
   Y = -sGsT * Sx + cGsT * Sy;                         /* Y proj Spin axis   */
   gLnGs = atan2 (Y, X) * RToD;                        /* Spin axis Long     */
   gLaTs = atan2 (Sz, sqrt(X * X + Y * Y)) * RToD;     /* Spin axis Lat      */

   /**************************************************************************/
   /* Set up mapping type and Establish a window to draw the terminator in.  */
   /* Clipping is set to ON                                                  */
   /**************************************************************************/

   parm.univ = 15;
   Ewn = EarthWin (N, Ti, &Ti->Avg1[0], A, gLaT, gLnG, gLaTs, gLnGs);
   clip (Ewn, 2);

   /**************************************************************************/
   /* Determine the angular radius of the terminator From that determine     */
   /* how far the center of the terminator circle is offset from the center  */
   /* of the earth and the radius to use when drawing the terminator         */
   /**************************************************************************/

    aR = atan2 (Re, sqrt(MagO * MagO - Re * Re)) * RToD;
    Xoff = Re * sine(aR);
    R = Re * cosin(aR);

   /**************************************************************************/
   /* Set up a rotation matrix which will rotate the object to the           */
   /**************************************************************************/

    A11 = cosin (gLnGo) * cosin (gLaTo);
    A12 = sine (gLnGo) * cosin (gLaTo);
    A13 = sine (gLaTo);
    A21 = -sine (gLnGo);
    A22 = cosin (gLnGo);
    A23 = 0.0;
    A31 = -cosin (gLnGo) * sine (gLaTo);
    A32 = -sine (gLnGo) * sine (gLaTo);
    A33 = cosin (gLaTo);

   /**************************************************************************/
   /* Draw the terminator                                                    */
   /**************************************************************************/

    for (pP = 0, AnG = 0.0; AnG <= 360.0; AnG += 1.0, pP = 1)
    {
       A = AnG / RToD;
       Y1 = R * cos(A);
       Z1 = R * sin(A);
       X = A11 * Xoff + A21 * Y1 + A31 * Z1;
       Y = A12 * Xoff + A22 * Y1 + A32 * Z1;
       Z = A13 * Xoff + A23 * Y1 + A33 * Z1;
       LnG = atan2(Y, X) * RToD;
       LaT = atan2(Z, sqrt(X*X + Y*Y)) * RToD;
       mv_n_drw (Ewn, LnG, LaT, 0.0, pP, 0);
    }
    mv_n_drw (Ewn, 0.0, 0.0, 0.0, 0, 2);
   
   /**************************************************************************/
   /* Return original settings                                               */
   /**************************************************************************/

    parm.univ = SUniV;                              
    parm.csize = SaveCsize;                        
    plt_color (0, SVcolor);
}
