#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "util_str.h"

ByTe_2 DoBins (ByTe_4 N, ByTe_1 Axis, ByTe_4 *W, ReaL_4 *F)
{
   extern struct UserDefs InFo;

   struct PlotDef *Pd;

   register struct Binning *B;

   ReaL_4 FT, Rng;
   ByTe_4 FP, LP;
   ByTe_4 WT, dW;
   ByTe_2 MoD;
   ByTe_2 DSrc;
   ByTe_1 Cyc = 0;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;          /* the plot def struct */
   if (Axis < 4)                                      /* X axis              */
   {                                                  /* BEG X AXIS SETS     */
      DSrc = Pd->AData[0];                            /* axis data source    */
      B = &Pd->Bx;                                    /* X binning info      */
   }                                                  /* END X AXIS SETS     */
   else                                               /* one of the Y axis   */
   {                                                  /* BEG Y AXIS SETS     */
      if (Axis < 6)                                   /* left Y axis         */
      {                                               /* BEG LEFT Y AXIS     */
         DSrc = Pd->AData[1];                         /* axis data source    */
         B = &Pd->Byl;                                /* Y binning info      */
      }                                               /* END LEFT Y AXIS     */
      else                                            /* need right y info   */
      {                                               /* BEG RIGHT Y AXIS    */
         DSrc = Pd->AData[2];                         /* axis data source    */
         B = &Pd->Byr;                                /* Y binning info      */
      }                                               /* END RIGHT Y AXIS    */
   }                                                  /* BEG Y AXIS SETS     */
   MoD = B->N;                                        /* set max mod         */

   if (DSrc == 3)                                     /* cyclic data?        */
   {                                                  /* BEG MAYBE CYCLIC    */
      Rng = abs(B->Stop - B->Start);                  /* binning range       */
      Cyc = (Rng > 359.99 && Rng < 360.01) ? 1 : 0;   /* cyclic data         */
      if (Cyc)                                        /* chk for cyclic data */
      {                                               /* BEG TIS CYCLIC      */
         if (W[1] > W[0] && B->Dir < 0)               /* fell off edge       */
         {
            dW = W[1] - W[0];
            if (dW > B->N/2)
               W[0] += B->N;                          /* correct lower end   */
         }
         else if (W[1] < W[0] && B->Dir > 0)          /* fell off other edge */
         {
            dW = W[0] - W[1];
            if (dW > B->N/2)
               W[1] += B->N;                          /* correct lower end   */
         }
      }                                               /* END TIS CYCLIC      */
      else                                            /* not cyclic          */
      {
         if (W[0] < 0)
            W[0] = W[1];
         else
         {
            if (W[1] < 0)
               W[1] = W[0];
         }
      }
   }                                                  /* END MAYBE CYCLIC    */

   if (W[0] > W[1])                                   /* not forward?        */
   {                                                  /* BEG FORCE FORWARD   */
      WT = W[0];                                      /* hold first bin      */
      W[0] = W[1];                                    /* swap 1st and 2nd    */
      W[1] = WT;                                      /* 1st to last         */
      FT = F[0];                                      /* hold first bin      */
      F[0] = F[1];                                    /* swap 1st and 2nd    */
      F[1] = FT;                                      /* 1st to last         */
   }                                                  /* BEG FORCE FORWARD   */

   if (DSrc != 3 || !Cyc)                             /* cyclic axis         */
   {                                                  /* BEG NON-CYCLIC      */
      FP = 0;                                         /* 1st valid pixel #   */
      LP = B->N - 1;                                  /* last valid pixel #  */
      if (W[1] < FP || W[0] > LP)                     /* not in plot         */
         MoD = 0;                                     /* naught to do        */
      else                                            /* other test cases    */
      {                                               /* BEG NEXT TEST       */
         FP = 0;                                      /* First Pixel in Plot */
         LP = B->N - 1;                               /* Last Pixel in Plot  */
         if (W[0] < FP)                               /* start at beg        */
         {                                            /* BEG START AT FX     */ 
            W[0] = FP;                                /* start at beginning  */
            F[0] = 1.0;                               /* full pixel          */
         }                                            /* END START AT FX     */ 
         if (W[1] > LP)                               /* go to end           */
         {                                            /* BEG END AT LX       */ 
            W[1] = LP;                                /* start at beginning  */
            F[1] = 1.0;                               /* full pixel          */
         }                                            /* END END AT LX       */ 
      }                                               /* END NEXT TEST       */
   }                                                  /* END NON-CYCLIC      */

   return (MoD);
}
