/**************************************************************************/
/*  This routine figures out what needs to be malloced and how many bytes */
/*  to allocate for each item                                             */
/**************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "UDFpltStr.h"
#include "util_str.h"
#include "user_defs.h"
#include "libbase_udf.h"
#include "UDFpltAnsi.h"

void CheckMem (struct PlotDef *Pd, ByTe_4 SrcN)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct idf_data  *ExDa;
   struct SrcInfo   *S;

   size_t Bp, Ba, Bytes;
   ByTe_4 Len;

   /**************************************************************************/
   /* Set pointer to the structure which holds all the information which     */
   /* was obtained in the read.                                              */
   /**************************************************************************/

   ExDa = (struct idf_data *) InFo.UDF;           /* ptr to data             */
   S = (struct SrcInfo *) Pd->Src + SrcN;         /* source structure        */
   if (S->PrevRead == 1)                          /* already did this        */
      return;                                     /* no double dipping       */

   if (S->Pri == 0)                               /* no memory allocated?    */
      FirstMemGets (Pd, SrcN);                    /* allocate memory         */
   else
   {
      Len = 4 * ExDa->num_sample;
      if (Len > Wa.SizeScr) {
         Wa.SizeScr = Len;
         Bytes = sizeof(ReaL_4) * Wa.SizeScr;
         if ((Wa.Scratch = realloc (Wa.Scratch, Bytes)) == 0)
            ErrorRpt ("CheckMem", 0, 2);
      }

      switch (S->DType)                           /* length by data type     */ 
      {                                           /* BEG DATA TYPE SWITCH    */
         case 0:                                  /* START SENSOR DATA       */
            Len = ExDa->num_sample;               /* scan length             */
            Bp = Len * sizeof (ReaL_4);           /* pri bytes needed        */
            Ba = 4 * Len * sizeof (ReaL_4);       /* alt bytes needed        */
         break;                                   /* STOP SENSOR DATA        */
         case 1:                                  /* START SCAN DATA         */
            Len = ExDa->num_sample;               /* is this many elements   */
            Bp = 0;                               /* pri bytes needed        */
            Ba = 4 * Len * sizeof (ReaL_4);       /* alt bytes needed        */
         break;                                   /* STOP SCAN/SENSOR DATA   */
         case 6:                                  /* START MODE DATA         */
            Len = 1;                              /* one sample              */
            Bp = 2 * Len * sizeof (ReaL_4);       /* pri bytes needed        */
            Ba = 0;                               /* alt bytes needed        */
         break;                                   /* STOP MODE DATA          */
      }                                           /* END DATA TYPE SWITCH    */

      if (Len > S->DSize)                          /* more size required?    */
      {                                            /* BEG ADD MEMORY         */
         if (Bp > 0)                               /* need primary memory?   */
            if ((S->Pri = realloc (S->Pri, Bp)) == 0)  /* primary data       */
                ErrorRpt ("FirstMemGet", 0, 2);        /* oops - error       */
 
         if (Ba > 0) {                             /* need alternate memory? */
            if ((S->Alt = realloc (S->Alt, Ba)) == 0)  /* alternate data     */
                ErrorRpt ("CheckMem", 0, 2);           /* oops - error       */
            if ((S->Bins = realloc (S->Bins, 2 * Ba)) == 0) 
                ErrorRpt ("CheckMem", 0, 2);           /* oops - error       */
         }

         S->DSize = Len;                           /* reset malloc size      */
      }                                            /* END ADD MEMORY         */
   }
}
