#include <stdio.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "util_str.h"

ByTe_2 BuildXYPlot (ByTe_4 PN, ByTe_1 *PStat)
{
   extern struct UserDefs InFo;

   struct idf_data  *ExDa;
   struct PlotDef *Pd;
   struct SrcInfo *S, *Sb;

   ByTe_4   N, End, SrcN, Lim[2];
   ByTe_4   Bn, pN, LastCN;
   ByTe_2   R, *s1, BegKey = 0, NumSrcs, BegS;
   ByTe_2   MCntr;
   ByTe_1   Go, Fwd, DoNorms = 1, New, NeedFwd, DoAll, Mx;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;          /* plot def struct    */
   while (Go)                                          /* accumulation loop  */
   {                                                   /* BEG BUILD PLOT     */
      pN = 0;                                          /* plot counter       */
      s1 = (ByTe_2 *)Pd->SOrder + BegS;                /* source order array */
      New = 1;                                         /* tools need data    */
      R = FetchData (PN, 0, Fwd);                      /* pick up the data   */

      if (Pd->Pb.Yr < 0)
      {
         Pd->Pb.Yr = S->Bt.Yr;
         Pd->Pb.Dy = S->Bt.Dy;
         Pd->Pb.Ms = S->Bt.Ms;
         Pd->Pb.Ns = S->Bt.Ns;
      }
      Tools (PN, SrcN, 0, New);                        /* flow removal       */
      New = 0;                                         /* hold flow          */
      if (S->DPres == 0)                               /* no data picked up  */
         continue;                                     /* to next source     */
   
      if (S->Col.Fmt == 0)
         X = AvgOverX (PN, 0, 0, Lim); 
      else 
         if (S->Col.Fmt == 1)   
            X = IntOverX (PN, 0, 0, Lim); 

      do 
      {
          R = FetchData (PN, 1, Fwd);
          if (







      if (DoNorms)                                     /* need to set norms? */
      {                                                /* BEG SET NORMS      */
         DoNorms = 0;                                  /* set to done        */
         *PStat = 0;                                   /* no data in plot    */
      }











      if (!DoAll || S->SenCN == 0)            /* do time check      */
               {                                       /* BEG TIME CHECK     */
                  if (CmpTm (&Pd->Pe, &S->Bt) == 0)    /* bet time in plot?  */
                  {
                     if (Pd->Tm.Sca == 9)
                        Pd->More = 0;
                     else
                        break;                         /* no - to next src   */
                  }
               }                                       /* END TIME CHECK     */

               if (Pd->AData[0] == 8)                  /* Contour Data       */
                  FullPolar (PN, SrcN);                /* load arrays        */
               else                                    /* gridded data       */
               {                                       /* BEG GRIDDED DATA   */
                  if (Mx)
                  {
                     if (S->OneAll == 3 && Pd->DoSrcs == 0)
                        pN = 0;                        /* current plot       */
                  }
                  else
                     pN = (Pd->DoSrcs == 1) ? SrcN : 0; /* current plot      */

                  for (Bn = 0; Bn < S->Col.N; ++Bn, ++pN) /* collapse loop   */
                  {                                    /* BEG COLLAPSES      */
                     if (S->Col.Fmt == 0)              /* need to avg data?  */
                        S->ColD = AvgOverX (PN, SrcN, Bn, Lim); 
                     else                              /* maybe  integrate?  */
                        if (S->Col.Fmt == 1)           /* do integral?       */
                           S->ColD = IntOverX (PN, SrcN, Bn, Lim); 

                     XPix (PN, SrcN, pN, Lim);         /* Stuff pixels       */
                  }                                    /* BEG COLLAPSES      */
               }                                       /* BEG GRIDDED DATA   */

               S->PrevRead = 0;                        /* data stored        */
               *PStat = 1;                             /* some data in plot  */

               if (S->OneAll == 3)                     /* all columns        */
               {                                       /* BEG ALL COL SETS   */
                  ++S->SenCN;                          /* next column        */
                  if (S->SenCN == LastCN && NeedFwd)   /* need to forward?   */
                     Fwd = 1;                          /* forward            */
               }                                       /* END ALL COL SETS   */

            } while (S->SenCN <= LastCN);              /* END COLUMN LOOP    */
         }                                             /* END SOURCE LOOP    */

         ++MCntr;                                      /* number of grabs    */
         if (R == 0)                                   /* out of data        */
         {                                             /* BEG EOF FOUND      */
            Go = 0;                                    /* no more data       */
            Pd->More = -1;                             /* check for end time */
         }                                             /* END EOF FOUND      */
         else                                          /* keep on truckin'   */
         {                                             /* BEG STILL DATA     */
            S = (struct SrcInfo *)Pd->Src + BegS;      /* pntr to first src  */
            if (!DoAll)
               Go = CmpTm (&Pd->Pe, &S->Et);           /* check for end time */
            else
            {
               if (Pd->Tm.Sca == 9) 
               {
                  if (Pd->Tm.R <= MCntr)
                  {
                     Go = 0;
                     Pd->Pe.Yr = S->Et.Yr;
                     Pd->Pe.Dy = S->Et.Dy;
                     Pd->Pe.Ms = S->Et.Ms;
                     Pd->Pe.Ns = S->Et.Ns;
                     MCntr = 0;
                  }
                  else
                     Go = 1;
               }
               else
                  Go = 0;
            }
         }                                             /* END STILL DATA     */
      }                                                /* END BUILD PLOT     */
   }                                                   /* END KEY GROUP      */

   if (Pd->More == 1)
      Pd->More = CmpTm (&InFo.TE, &S->Et);             /* check for end time */

   if (Pd->Tm.OrigSca == 8)                            /* Timed by spin rate */
   {                                                   /* BEG RESET TIME RES */
       Pd->Tm.R = Pd->Tm.OrigR * ExDa->spin_rate;      /* reset resolution   */
       if (Pd->Tm.R < 0.0)                             /* reverse spin?      */
          Pd->Tm.R = - Pd->Tm.R;                       /* make resolution +  */ 
   }                                                   /* BEG RESET TIME RES */

   return (R);
}
