#include <stdio.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "util_str.h"

ByTe_2 BuildPlots (ByTe_4 PN)
{
   extern struct UserDefs InFo;

   struct idf_data  *ExDa;
   struct PlotDef *Pd;
   struct SrcInfo *S, *Sb;

   ReaL_8   TmpR, dT;
   ByTe_4   N, End, SrcN;
   ByTe_4   pN, LastCN;
   ByTe_2   R, *s1, BegKey = 0, nSrcs, BegS;
   ByTe_2   MCntr;
   ByTe_2   ActiveSrc;
   ByTe_1   Go, Fwd, DoNorms = 1, New, NeedFwd, DoAll, Mx;
   ByTe_1   BegIn = 1, EndIn = 1, Omit, Gap, UseIn, TmOK;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;        /* plot def struct      */
   End = Pd->EmptySrc - 1;                           /* last source number   */
   Sb = (struct SrcInfo *)Pd->Src;                   /* pntr to first src    */
   ExDa = (struct idf_data *) InFo.UDF;              /* UDF read info        */

   MCntr = 0;
   Gap = 0;
   while ((nSrcs = BegEndSrc (PN, BegKey)) > 0) {    /* BEG KEY GROUP        */
      BegS = BegKey;                                 /* first source         */
      End = nSrcs - 1;                               /* last source          */
      BegKey = BegKey + nSrcs;                       /* next key             */
      Go = 1;                                        /* gather data          */

      while (Go) {                                   /* BEG BUILD PLOT       */
         pN = 0;                                     /* plot counter         */
         s1 = (ByTe_2 *)Pd->SOrder + BegS;           /* source order array   */
         New = 1;                                    /* tools need data      */
         Omit = 1;                                   /* no data in time flg  */
         ActiveSrc = -1;                             /* No active source     */
         for (N = 0; N <= End; ++N) {                /* BEG SOURCE LOOP      */
            SrcN = *s1++;                            /* the src number       */
            S = Sb + SrcN;                           /* current source       */
            UseIn = (Pd->Tm.OrigSca == 9) ? EndIn : BegIn;
            Fwd = ((N == End) && UseIn) ? 1 : 0;     /* fwd next new src     */
            NeedFwd = Fwd;                           /* set Need To Fwd      */

            if (S->OneAll == 3) {                    /* BEG ALL COL SETS     */
               S->SenCN = 0;                         /* start at beginning   */
               Fwd = 0;                              /* no forward           */
               DoAll = (Pd->PType == 0) ? 0 : 1;     /* do full matrix       */
            }                                        /* END ALL COL SETS     */
            else                                       /* not full matrix    */
               DoAll = (Pd->Tm.OrigSca == 9) ? 1 : 0;  /* chk read by read   */

            Mx = (S->SType == 3 && 
                (Pd->AData[0] == 1 || Pd->AData[1] == 1)) ? 1 : 0;

            do  {                                      /* BEG COLUMN LOOP    */
               R = FetchData (PN, SrcN, Fwd);          /* pick up the data   */
               if (S->OneAll == 3) {                   /* BEG ALL COL CHK    */ 
                  LastCN = ExDa->TotCols - 1;          /* last column number */
                  if (LastCN == 0 && NeedFwd)          /* needed forward?    */
                     R = FetchData (PN, SrcN, 1);      /* Do forward         */
               }                                       /* END ALL COL CHK    */ 
               else                                    /* getting one        */
                  LastCN = -1;                         /* make sure          */

               if (Pd->Pb.Yr < 0) {                    /* BEG SET PLOT TIME  */
                  Pd->Pb.Yr = S->Bt.Yr;                /* Year to data year  */
                  Pd->Pb.Dy = S->Bt.Dy;                /* Day to data day    */
                  Pd->Pb.Ms = S->Bt.Ms;                /* Msec to data msec  */
                  Pd->Pb.Ns = S->Bt.Ns;                /* Ns to data Ns      */
               }                                       /* END SET PLOT TIME  */

               Tools (PN, SrcN, 0, New, 0);            /* flow removal       */
               New = 0;                                /* hold flow          */

/*****************************************************************************/
/*  If there is no data or if the time end time of the data is not greater   */
/*  that the start time of the plot then don't process this data pickup      */
/*****************************************************************************/

               if (S->DPres == 1) {                    /* BEG DATA HERE      */
                  TmOK = CmpTm (&Pd->Pb, &S->Et, 0);   /* check time         */
                  if (ActiveSrc < 0)                   /* no src with data?  */
                      ActiveSrc = SrcN;                /* pick this one      */
               } else                                  /* BEG NO DATA        */
                 TmOK = 1;                             /* force no data      */
                   
               TmOK = (S->DPres == 1) ? CmpTm (&Pd->Pb, &S->Et, 0) : 1; 
               if (S->DPres == 0 || TmOK ) 
               {                                       /* BEG NO DATA        */
                  if (S->OneAll == 3) {                /* BEG ALL COL SETS   */
                     ++S->SenCN;                       /* next column        */
                     if (S->SenCN == LastCN && NeedFwd)   /* need to fwd?    */
                        Fwd = 1;                       /* forward            */
                  }                                    /* END ALL COL SETS   */
                  S->PrevRead = 0;                     /* say its processed  */
                  continue;                            /* to next source     */
               } else 
                 Omit = 0;                             /* data is ok         */

/*****************************************************************************/
/* First time through we need to reset the plot normalization array.  Should */
/* also set the plot resolution if it is based on spin period.               */
/*****************************************************************************/

               if (DoNorms) {                          /* BEG SET NORMS      */
                  SetBaseNorm (PN);                    /* norms to -1        */
                  DoNorms = 0;                         /* set to done        */
                  Pd->PStat = 0;                       /* no data in plot    */
                  if (Pd->Pb.Yr < 0) {                 /* BEG NEED SET START */
                     Pd->Pb.Yr = S->Bt.Yr;             /* start year         */
                     Pd->Pb.Dy = S->Bt.Dy;             /* start day          */
                     Pd->Pb.Ms = S->Bt.Ms;             /* start msec         */
                     Pd->Pb.Ns = S->Bt.Ns;             /* start nsec         */
                  }                                    /* END NEED SET START */
                  if (Pd->Tm.OrigSca == 8) {
                     TmpR = Pd->Tm.OrigR * ExDa->spin_rate; 
                     if (TmpR < 0.0)
                        TmpR = - TmpR;
                     if (Pd->Tm.R != TmpR) {
                        Pd->Tm.R = TmpR;
                        dT = Pd->Tm.R - TmpR;
                        Pd->Pe.Ms += dT;
                     } 
                  } 
               }

/*****************************************************************************/
/* Time checks occur only once per read for normal data but if getting a     */
/* whole matrix then only once per matrix at column number 0.                */
/*                                                                           */
/* BegIn is 1 if the data start time is less than the plot end time          */
/* EndIn is 1 if the data stop time is less or equal to the plot end time    */
/*****************************************************************************/

               if (!DoAll || S->SenCN == 0) {          /* BEG DO TIME CHECK  */
                  BegIn = CmpTm (&Pd->Pe, &S->Bt, 0);  /* beg time check     */
                  EndIn = CmpTm (&Pd->Pe, &S->Et, 1);  /* end time check     */

/*****************************************************************************/
/* If we are plotting by measurements and the end time is outside the plot   */
/* then if we are plotting the last measurement OK otherwise mark this       */
/* as a gap in the plot.  Don't process this data point and go on            */
/*****************************************************************************/

                  if (Pd->Tm.OrigSca == 9 && !EndIn) 
                  {
                      if (Pd->Tm.OrigR == (MCntr + 1))
                         EndIn = 1;
                      else {
                         MCntr = Pd->Tm.OrigR;
                         Gap = 1;
                         break;
                      }
                  }

/*****************************************************************************/
/* If the beginning measurement is out of the plot then we need to go on     */
/* unless we are plotting by measurement in which we chug on until the       */
/* the requested number of measurements has been processed.  The plot end    */
/* time is set after the plot is concluded for "by measurement" plots.       */
/*****************************************************************************/

                  if (!BegIn && Pd->Tm.OrigSca != 9)   /* BEG TIME CHECK     */
                        break;                         /* on to next src     */
               }                                       /* END DO TIME CHECK  */

               Pd->PStat = AssemPlot (PN, SrcN, Mx, N); /* load data in plot */
               if (EndIn && Pd->Tm.OrigSca == 9)
                  S->PrevRead = 0;                     /* data stored        */
               else {
                  if (Pd->Tm.OrigSca != 9)
                     S->PrevRead = 0; 
               }

               if (S->OneAll == 3)                     /* all columns        */
               {                                       /* BEG ALL COL SETS   */
                  ++S->SenCN;                          /* next column        */
                  if (S->SenCN == LastCN && NeedFwd)   /* need to forward?   */
                     Fwd = 1;                          /* forward            */
               }                                       /* END ALL COL SETS   */

            } while (S->SenCN <= LastCN);              /* END COLUMN LOOP    */
         }                                             /* END SOURCE LOOP    */

         if (!Omit)
            ++MCntr;                                   /* number of grabs    */
         if (R == 0)                                   /* out of data        */
         {                                             /* BEG EOF FOUND      */
            Go = 0;                                    /* no more data       */
            Pd->More = -1;                             /* check for end time */
         }                                             /* END EOF FOUND      */
         else                                          /* keep on truckin'   */
         {                                             /* BEG STILL DATA     */
            S = (struct SrcInfo *)Pd->Src + ActiveSrc; /* ptr to active src  */
            if (!DoAll)
               Go = CmpTm (&Pd->Pe, &S->Bt, 0);        /* check for end time */
            else
            {
               if (Pd->Tm.OrigSca == 9) 
               {
                  if (Pd->Tm.OrigR <= MCntr)
                  {
                     Go = 0;
                     if (!Gap) {
                        Pd->Pe.Yr = S->Et.Yr;
                        Pd->Pe.Dy = S->Et.Dy;
                        Pd->Pe.Ms = S->Et.Ms;
                        Pd->Pe.Ns = S->Et.Ns;
                     } else {
                        Pd->Pe.Yr = S->Bt.Yr;
                        Pd->Pe.Dy = S->Bt.Dy;
                        Pd->Pe.Ms = S->Bt.Ms;
                        Pd->Pe.Ns = S->Bt.Ns;
                     }
                     MCntr = 0;
                  }
                  else
                     Go = 1;
               }
               else
                  Go = 0;
            }
         }                                             /* END STILL DATA     */
      }                                                /* END BUILD PLOT     */
   }                                                   /* END KEY GROUP      */

   S = (struct SrcInfo *)Pd->Src + ActiveSrc;          /* ptr to active src  */
   if (Pd->More == 1)
      Pd->More = CmpTm (&InFo.TE, &S->Et, 1);          /* check for end time */

   if (Pd->Tm.OrigSca == 8) {                          /* BEG RESET TIME RES */
       Pd->Tm.R = Pd->Tm.OrigR * ExDa->spin_rate;      /* reset resolution   */
       if (Pd->Tm.R < 0.0)                             /* reverse spin?      */
          Pd->Tm.R = - Pd->Tm.R;                       /* make resolution +  */ 
   }                                                   /* BEG RESET TIME RES */

   return (R);
}
