#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"

/****************************************************************************/
/*  This program puts up all labels associated with a given plot            */
/****************************************************************************/

void AxisText (ByTe_4 N, ByTe_1 Axis, ByTe_4 RelPn, ByTe_1 PType)
{
   extern struct UserDefs InFo;
   extern struct config parm;

   struct PlotDef *Pd;
   struct Pidf *P;
   struct PidfUnit *Pu, *Pa;
   struct AxisInfo *Ax;
   struct CutDef *cD, *cDs;

   register struct SrcInfo *S, *SEnD;

   ReaL_4 Pos;
   ByTe_2 Co, LabP, Ln, Lr, R, Lc, C, AxDef;
   ByTe_1 L0[50], L1[50], L2[150], AxL; 
   ByTe_1 F[5], Lp, Pn, An;
   ByTe_1 OSrc;
   ByTe_1 BCut = 0, RCut = 0;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;            /* plot info struct  */
   S = (struct SrcInfo *)Pd->Src;                       /* first plotted src */
   C = parm.white;                                      /* white label color */

   if (Pd->CCut != 0) {
      cD = (struct CutDef *)Pd->CCut;
      if (cD->CutPlace == 0)
         BCut = 1;
      else 
         RCut = 1;
   }
   if (Pd->LSCut != 0) {
      cDs = (struct CutDef *)Pd->LSCut;
      if (cDs->CutPlace == 0)  
         BCut = 1;
      else
         RCut = 1;
   }

   if (Axis == 0) {                                    /* BEG X AXIS SETS    */
      AxL = 'X';                                       /* axis label         */
      Lr = Pd->Rows - 1;                               /* last row number    */
      Ln = InFo.EmptyPd - 1;                           /* last plot def      */
      Lc = Pd->Cols / 2;                               /* middle col number  */
      if (Pd->TimeDir == 1) {                          /* time across        */
         R = RelPn / Pd->Cols;                         /* current row number */
         Co = RelPn % Pd->Cols;                        /* current col number */
      } else {                                         /* BEG INCREMENT      */
         R = RelPn % Pd->Rows;                         /* current row number */
         Co = RelPn / Pd->Rows;                        /* current col number */
      }                                                /* END INCREMENT      */

      An = 0;                                           /* axis number       */
      Lp = ((Pd->Cols % 2 == 0) && !RCut) ? 'B' : 'C';  /* label center      */
      switch (PType) {                                  /* Plot specific     */
         default:
            Pn = Pd->Pn;
            Ax = &Pd->Xb;
            OSrc = Pd->AData[1];
            AxDef = Pd->AData[(ByTe_4)Axis];            /* label by plottype */ 
         break;
         case -1:
            Pn = cD->CutPn;
            Ax = &cD->Ax;
            OSrc = 7;
            AxDef = 8;
         break;
         case -2:
            Pn = cDs->CutPn;
            Ax = &cDs->Ax;
            OSrc = 7;
            AxDef = 90;
         break;
      }
   } else {                                             /* BEG Y AXIS SETS   */
      AxL = 'Y';                                        /* axis label        */
      LabP = (Pd->TimeDir == 0) ? Pd->Rows / 2 : (Pd->Rows / 2) * Pd->Cols; 
      if (LabP != RelPn)                                /* is this the row   */
         return;                                        /* wrong plot        */

      Lp = (Pd->Rows % 2 == 0) ? 'T' : 'C';             /* label center      */
      switch (PType) {                                  /* Plot specific     */
         default:
            if (Axis == 1) {                            /* Left Y axis       */
              Ax = &Pd->Yl;                             /* left y axis info  */
              An = 4;                                   /* axis number       */
            } else {                                    /* END LEFT Y SETS   */
              Ax = &Pd->Yr;                             /* left y axis info  */
              An = 6;                                   /* axis number       */
            }                                           /* END RIGHT Y SETS  */
            Pn = Pd->Pn;
            OSrc = Pd->AData[1];
            AxDef = Pd->AData[(ByTe_4)Axis];            /* label by plottype */ 
         break;
         case -1:
            Pn = cD->CutPn;
            Ax = &cD->Ay;
            OSrc = 7;
            AxDef = 1;
         break;
         case -2:
            Pn = cDs->CutPn;
            Ax = &cDs->Ay;
            OSrc = 7;
            AxDef = 90;
         break;
      }
   }                                                    /* END Y AXIS SETS   */

   if (Ax->DoLabs == 0 || Ax->DoLabs == 2)              /* do labels?        */
      return;                                           /* not this axis     */

   if (Pd->AData[(ByTe_4)Axis] == 1 && OSrc != 7)       /* need src info?    */
   {                                                    /* BEG GET SRC INFO  */
      SEnD = S + Pd->EmptySrc;                          /* last source       */
      while (S < SEnD && S->PAxis != An)                /* find src on axis  */
         ++S;                                           /* try next src      */

      if (S >= SEnD)                                    /* found a source    */
         return;                                        /* no source - rats  */
   }                                                    /* END GET SRC INFO  */

   if (Lp == 'C')                                       /* label axis center */
      Pos = centertxt (Pn, An);                         /* axis center       */
   else                                                 /* which axis?       */
      Pos = (Lp == 'T') ? Ax->Max : Ax->Min;            /* top/bot left Y    */

   lab_size (Pn, Ax->LabSize);                          /* set text size     */
   lab_offset (Pn, Ax->LabOffset);                      /* set text offset   */
   lab_spacing (Pn, Ax->LabSpace);                      /* set line spacing  */
   L0[0] = 0;                                           /* no L0 label       */
   L1[0] = 0;                                           /* no L1 label       */
   L2[0] = 0;                                           /* no L2 label       */
   switch (AxDef)                                       /* label by plottype */ 
   {                                                    /* BEG MAKE LABEL    */
      case 1:                                           /* START VALUE       */
         if (S->LpType < 10)                            /* not spectroscalar */ 
         {                                              /* BEG NORMAL LABS   */
            ReadPidf(S->Key, InFo.PIDF);                /* Get PIDF info     */
            P = (struct Pidf *) InFo.PIDF;              /* pointer to info   */
            Pu = (struct PidfUnit *)P->Units + S->GetUN; /* pri unit info    */
            Pa = (struct PidfUnit *)P->Units + S->AltUN; /* sec unit info    */
         
            if (S->Col.Fmt == 1)                        /* integral value?   */
            {                                           /* BEG INTG LABEL    */
               F[0] = 0;                                /* add integ text    */
               F[1] = -1;                               /* guess at case     */
               int_label (Pu->LDesc, F, L1);            /* get unit desc     */
               F[0] = 1;                                /* to upper case     */
               F[1] = 1;                                /* integ in scan     */
               F[2] = 0;                                /* no phi integral   */
               F[3] = 0;                                /* no theta integral */
               int_units (Pu->ULab, Pa->ULab, F, L2);   /* form unit part    */
               sprintf (L0, "[%s]", L2);                /* units label       */
            }                                           /* END INTG LABEL    */
            else                                        /* no integration    */
            {                                           /* BEG PIDF LABEL    */
               sprintf (L1, "%s", Pu->LDesc);           /* units desc label  */
               sprintf (L0, "[%s]", Pu->ULab);          /* units label       */
             }                                          /* END PIDF LABEL    */
         }                                              /* END NORMAL LABS   */
      break;                                            /* STOP VALUE        */
      case 2:                                           /* START SCAN        */
         ReadPidf(S->Key, InFo.PIDF);                   /* Get PIDF info     */
         P = (struct Pidf *) InFo.PIDF;                 /* pointer to info   */
         Pa = (struct PidfUnit *)P->Units + S->AltUN;   /* sec unit info     */
         sprintf (L1, "%s", Pa->LDesc);                 /* units desc label  */
         sprintf (L0, "[%s]", Pa->ULab);                /* units label       */
      break;                                            /* STOP SCAN         */
      case 3:                                           /* START SPIN ANGLE  */
         sprintf (L1, "Phase");                         /* units desc label  */
         sprintf (L0, "[Degrees]");                     /* units label       */
      break;                                            /* STOP SPIN ANGLE   */
      case 5:                                           /* START THETA       */
         sprintf (L1, "Elevation");                     /* units desc label  */
         sprintf (L0, "[Degrees]");                     /* units label       */
      break;                                            /* STOP THETA        */
      case 6:                                           /* START THETA       */
         if (S->SType == 3)                             /* matrix sensor     */
            sprintf (L1, "Matrix Column");              /* units desc label  */
         else                                           /* non-matrix        */
            sprintf (L1, "Sensor Number");              /* units desc label  */
         sprintf (L0, "[Integer]");                     /* units label       */
      break;                                            /* STOP THETA        */
      case 7:                                           /* START THETA       */
         sprintf (L1, "Occurrances");                   /* units desc label  */
         L0[0] = 0;                                     /* units label       */
      break;                                            /* STOP THETA        */
      case 8:                                           /* START CONTOUR     */
         ReadPidf(S->Key, InFo.PIDF);                   /* Get PIDF info     */
         P = (struct Pidf *) InFo.PIDF;                 /* pointer to info   */
         Pa = (struct PidfUnit *)P->Units + S->AltUN;   /* sec unit info     */
         sprintf (L1, "%c %s", AxL, Pa->LDesc);         /* units desc label  */
         sprintf (L0, "[%s]", Pa->ULab);                /* units label       */
      break;                                            /* STOP SCAN         */
      case 9:                                           /* START ALT SCAN    */
         ReadPidf(S->Key, InFo.PIDF);                   /* Get PIDF info     */
         P = (struct Pidf *) InFo.PIDF;                 /* pointer to info   */
         Pa = (struct PidfUnit *)P->Units + S->SAltUN;  /* sec unit info     */
         sprintf (L1, "%s", Pa->LDesc);                 /* units desc label  */
         sprintf (L0, "[%s]", Pa->ULab);                /* units label       */
      break;                                            /* STOP ALT SCAN     */
      case 90:                                          /* LShell            */
         sprintf (L1, "MLT");                           /* units desc label  */
         sprintf (L0, "[Hr]");                          /* units label       */
      break;                                            /* STOP ALT SCAN     */
   }                                                    /* END MAKE LABEL    */

   if (An < 4)                                          /* label X axis      */
   {                                                    /* BEG X LABS        */
      if (Pd->XLabStyle == 0)
      {
         sprintf (L2, "%s  %s", L1, L0);                /* units label       */
         text_lab(Pn, An, Pos, 0, L2, 0, 0, 1, 0., 0., C); /* dump label     */
      }
      else
      {
         text_lab(Pn, An, Pos, 1, L0, 0, 0, 1, 0., 0., C); /* dump label     */
         text_lab(Pn, An, Pos, 0, L1, 0, 0, 1, 0., 0., C); /* dump label     */
      }
   } else {                                             /* BEG Y LABS        */
      if (Pd->YLLabStyle == 0)
      {
         sprintf (L2, "%s  %s", L1, L0);                /* units label       */
         text_lab(Pn, An, Pos, 0, L2, 0, 0, 1, 0., 0., C); /* dump label     */
      }
      else
      {
         text_lab(Pn, An, Pos, 1, L1, 0, 0, 1, 0., 0., C); /* dump label     */
         text_lab(Pn, An, Pos, 0, L0, 0, 0, 1, 0., 0., C); /* dump label     */
      }
   }                                                    /* END Y LABS        */
}
