/****************************************************************************/
/*  This routine takes a sweep of data and averages over the scan variable  */
/*  from From to To.  The data bins are centered on the scan values         */
/****************************************************************************/

#include <stdio.h>
#include <math.h>
#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ReaL_4 AvgOverX (ByTe_4 PN, ByTe_4 SrcN, ByTe_4 Bn, ByTe_4 *EnDs)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;                                                   

   struct PlotDef *Pd;
   struct SrcInfo *S;

   register ReaL_4 *fl, *fr, *fy, *fE; 

   ReaL_4 Top, Bot, Cen;

   ReaL_4 Avg = 0.0;
   ReaL_4 Norm = 0.0;
   ReaL_4 Nrm;

   ByTe_4 *l1, *l2;
   ByTe_2 N = 0;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;       /* this plot definition  */
   S = (struct SrcInfo *)Pd->Src + SrcN;            /* and this source       */
   EnDs[0] = -1;                                    /* beg step              */
   EnDs[1] = -1;                                    /* end step              */

   GetBinStats (&S->Col, Bn, &Bot, &Top, &Cen, S->Col.Sca); 

   fl = (ReaL_4 *)S->Bins;
   fr = (ReaL_4 *)S->Bins + S->DLen;
   fy = (ReaL_4 *)S->Pri;
   l1 = (ByTe_4 *)Wa.Scratch;
   l2 = l1 + 1;
   fE = fr;
  
   *l1 = 0;
   for ( ; fl < fE; ++fl, ++fr, ++N) {
      Nrm = PerCentAge (*fl, *fr, Bot, Top); 
      if (*fy <= S->MaxValid && *fy >= S->MinValid) {
         if (Nrm > 0.0) {
            *l2++ = N;
            if (EnDs[0] < 0) EnDs[0] = N;
            EnDs[1] = N;
            Norm += Nrm;
            Avg += Nrm * *fy;
            ++(*l1);
         }
      }
      ++fy;
   }

   Avg = (Norm > 0.0) ? Avg / Norm : FILL;

   return (Avg);
}
