/****************************************************************************/
/*  This routine takes a sweep of data and averages over the scan variable  */
/*  from From to To.  The data bins are centered on the scan values         */
/****************************************************************************/

#include <stdio.h>
#include <math.h>
#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ReaL_4 AvgOverX (ByTe_4 PN, ByTe_4 SrcN, ByTe_4 Bn, ByTe_4 *EnDs)
{
   extern struct UserDefs InFo;

   struct PlotDef *Pd;
   struct SrcInfo *S;

   register ReaL_4 *fx, *fy, *fX, *fE; 

   ReaL_4 L, R, Top, Bot, Cen;
   ReaL_4 Lend, Rend;

   ReaL_4 Avg = 0.0;
   ReaL_4 Norm = 0.0;
   ReaL_4 Nrm;

   ByTe_2 N = 0;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;       /* this plot definition  */
   S = (struct SrcInfo *)Pd->Src + SrcN;            /* and this source       */
   EnDs[0] = -1;                                    /* beg step              */
   EnDs[1] = -1;                                    /* end step              */

   fx = S->Alt;                                     /* ptr to 1st X array    */
   fy = S->Pri;                                     /* ptr to 1st Y array    */
   fX = fx + 1;                                     /* ptr to 2nd X val      */
   fE = fx + S->DLen - 1;                           /* ptr to last X value   */

   GetBinStats (&S->Col, Bn, &Bot, &Top, &Cen, 0);  /* get average limits    */
   Lend = *fx - (*(fx + 1) - *fx)/2.0;              /* absolute left edge    */
   Rend = *fE + (*fE - *(fE - 1)) / 2.0;            /* absolute right edge   */

   if (*(fx + 1) > *fx)                             /* increasing X          */
   {
      if (Top <= Lend || Bot >= Rend)               /* rng out of bounds?    */
         return (FILL);                             /* return below all      */
   }
   else
   {
      if (Bot >= Lend || Top <= Rend)               /* rng out of bounds?    */
         return (FILL);                             /* return below all      */
   }

   L = Lend;                                        /* left edge 1st bin     */
  
   do                                               /* all but last bin      */
   {
      R = *fx + (*fX++ - *fx)/2.0;                  /* right edge 1st bin    */
      Nrm = PerCentAge (L, R, Bot, Top);            /* normalization         */
      if (*fy <= S->MaxValid && *fy >= S->MinValid)   /* value in bounds?    */
      {                                               /* BEGIN PROCESS VAL   */
         if (Nrm > 0.0)                             /* data in range         */
         {                                          /* BEG ADD IN DATA       */
            if (EnDs[0] < 0) EnDs[0] = N;           /* this is first bin     */
            EnDs[1] = N;                            /* this is last bin      */
            Norm += Nrm;                            /* total normalization   */
            Avg += Nrm * *fy;                       /* percentage of value   */
         }                                          /* END ADD IN DATA       */
      }                                             /* BEGIN PROCESS VAL     */
      ++fy;
      ++N;                                          /* next bin              */
      L = R;                                        /* right edge to left    */

   }  while (++fx < fE);                            /* loop over all data    */

   R = Rend;                                        /* right is end          */
   Nrm = PerCentAge (L, R, Bot, Top);               /* normalization         */
   Norm += Nrm;                                     /* total normalization   */
   Avg += Nrm * *fy++;                              /* percentage of value   */

   Avg = (Norm > 0.0) ? Avg / Norm : FILL;          /* idiot's check         */

   return (Avg);
}
