#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ByTe_1 XYStat (struct TiMiNg *X1, struct TiMiNg *X2, struct TiMiNg *Y1, 
               struct TiMiNg *Y2, ReaL_4 *F)
{
   ReaL_8  YBase; 
   ReaL_8  dTxb, dTxe, dTyb, dTye;
   ByTe_1 S;

   YBase = (X1->Yr < Y1->Yr) ? X1->Yr : Y1->Yr;
   *F = 0.0;

   dTxb = X1->Dy;
   if ((X1->Yr - YBase) > 0)
      dTxb += ((X1->Yr % 4 == 0 && X1->Yr % 100 != 0) || X1->Yr % 400 == 0) ?
              366 : 365
   dTxb *= 86400;
   dTxb += X1.Ms / 1000.0 + X1.Ns/1000000.0; 

   dTxe = X2->Dy;
   if ((X2->Yr - YBase) > 0)
      dTxb += ((X2->Yr % 4 == 0 && X2->Yr % 100 != 0) || X2->Yr % 400 == 0) ?
              366 : 365
   dTxe *= 86400;
   dTxe += X2.Ms / 1000.0 + X2.Ns/1000000.0; 
   
   dTyb = Y1->Dy;
   if ((Y1->Yr - YBase) > 0)
      dTxb += ((Y1->Yr % 4 == 0 && Y1->Yr % 100 != 0) || Y1->Yr % 400 == 0) ?
              366 : 365
   dTyb *= 86400;
   dTyb += Y1.Ms / 1000.0 + Y1.Ns/1000000.0; 

   dTye = Y2->Dy;
   if ((Y2->Yr - YBase) > 0)
      dTxb += ((Y2->Yr % 4 == 0 && Y2->Yr % 100 != 0) || Y2->Yr % 400 == 0) ?
              366 : 365
   dTye *= 86400;
   dTye += Y2.Ms / 1000.0 + Y2.Ns/1000000.0; 

   if (dTyb >= dTxe)
      S = 0;
   else
   {
      if (dTye <= dTxb)
         S = 1;
      else
      {
         if (dTyb <= dTxb) 
         {
            if (dTye >= dTxe) 
            {
               S = 0;
               *F = 1.0;
            }
            else
            {
               S = 1;
               *F = (dTye - dTxb) /(dTxe - dTxb);
            }
         }
         else
         {
            if (dTye <= dTxe) 
            {
               S = 1;
               *F = (dTye - dTyb) /(dTxe - dTxb);
            }
            else
            {
               S = 0;
               *F = (dTxe - dTyb) /(dTxe - dTxb);
            }
         }
      }
   }
   return (S);
}
