#include <stdio.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "util_str.h"

void XPix (ByTe_4 PN, ByTe_4 SrcN, ByTe_4 pN, ByTe_4 *Lims)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct SrcInfo *S;

   register ReaL_4 *P, *N;
   register ByTe_4 I, J, K;

   ReaL_4 Fx[2], Fy[2], V, F; 
   ReaL_4 *Px, *Nr, Fr;
   ByTe_4 L, Wx[2], Wy[2], Row, StarT, *l1;
   ByTe_2 XMoD, YMoD, EnD, XBins;
   ByTe_1 OmiT;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;      /* the plot def struct    */
   S = (struct SrcInfo *)Pd->Src + SrcN;           /* pointer to source      */

   l1 = (ByTe_4 *)Wa.Scratch;
   if (S->Col.Fmt < 0 ) {
      StarT = 0;
      EnD = (Pd->YSet == 1) ? S->DLen : 1;
      for ( I = 0; I < S->DLen; ++I) { *l1++ = I; } 
      l1 = (ByTe_4 *)Wa.Scratch;
   } else {
      StarT = 0;
      EnD = *l1++;
   }

/*
   if (Lims[0] >= 0)
   {
      StarT = Lims[0];
      EnD = Lims[1];
   }
   else
   {
      StarT = 0;
      EnD = (Pd->YSet == 1) ? S->DLen - 1 : 0;
   }
*/

   XBins = (Pd->AData[1] == 1 ||
           (Pd->AData[0] == 7 || Pd->AData[1] == 7) ) ? 1.0 : Pd->Byl.N;

/*
   for (K = StarT; K <= EnD; ++K, ++l1)
*/
   for (K = StarT; K < EnD; ++K, ++l1)
   {                                               /* BEG PIXEL FILLIN LOOP  */
      Bins (PN, SrcN, 0, *l1, Wx, Fx);             /* beg & end X pixels     */ 
      if ((XMoD = DoBins (PN, 0, Wx, Fx)) == 0)    /* order X bins           */
          continue;                                /* bins out of range      */

      Bins (PN, SrcN, S->PAxis, *l1, Wy, Fy);      /* beg & end Y pixels     */ 
      if ((YMoD = DoBins (PN, S->PAxis, Wy, Fy)) == 0)    /* order Y bins    */
          continue;                                /* bins out of range      */

      L = 2 * pN * Pd->PlotLen;                    /* start offset           */
      Px = (ReaL_4 *)Wa.WorkSpace + L;             /* base plot position     */
      Nr = Px + Pd->PlotLen;                       /* base norm position     */

      OmiT = 0;
      if (Pd->AData[0] == 7 || Pd->AData[1] == 7) {
         V = 1.0;
      } else {
         if (S->Col.Fmt >= 0) { 
             V = S->ColD; 
         } else {
             V = *((ReaL_4 *)S->Pri + *l1);
             if (V > S->MaxValid || V < S->MinValid) { OmiT = 1; }
         }
      }
 
      if ((Pd->ZeroInc == 1 && V == 0.0) || OmiT ) /* 0 data and excluding?  */
         continue;                                 /* try next point         */

      for (I = Wx[0]; I <= Wx[1]; ++I) {           /* BEG Y LOOP             */
         P = Px + (I % XMoD) * XBins;              /* start of pixel column  */
         N = Nr + (I % XMoD) * XBins;              /* start of normal column */
         F = (I == Wx[0]) ? Fx[0] : (I == Wx[1]) ? Fx[1] : 1.0;
         for (J = Wy[0]; J <= Wy[1]; ++J) {        /* BEG Y LOOP             */
            Fr = (J == Wy[0]) ? F * Fy[0] : (J == Wy[1]) ? F * Fy[1] : F;
            Row = J % YMoD;                        /* row number             */
            *(P + Row) += V * Fr;                  /* stuff data             */
            if ( *(N + Row) < 0.0)                 /* uninitialized norm?    */
               *(N + Row) = Fr;                    /* set normalization      */
            else                                   /* value there            */
              *(N + Row) += Fr;                    /* add normalization      */
         }                                         /* BEG Y LOOP             */
      }                                            /* BEG X LOOP             */
   }                                               /* END PIXEL FILLIN LOOP  */
}
