#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "gph_opind.h"

ByTe_2 DyInMo[12] =  {   31,    28,    31,    30,    31,    30,
                         31,    31,    30,    31,    30,    31};

ReaL_8 TransDate (ByTe_4 Ms, ByTe_2 dy, ByTe_2 mo, ByTe_2 yr, 
                ByTe_2 *Dy, ByTe_2 *Mo, ByTe_1 Fmt)
{
    register ByTe_2 *s1, *sEnD;

    ReaL_8 V = 0.0;

    s1 = DyInMo;
    DyInMo[1] = ((yr % 4 == 0 && yr % 100 != 0) || yr % 400 == 0) ? 29 : 28; 

    switch (Fmt)
    {
       case 0:                                 /* Day/Month/Yr -> Day No    */
          *Dy = 0;
          sEnD = s1 + mo - 1;
          for ( ; s1 < sEnD; )
              *Dy += *s1++;
          *Dy += dy;
       break;
       case 1:                                 /* Day No -> Day/Month/Yr     */
          *Mo = 1;
          *Dy = dy;
          while ( *Dy > *s1 )
          {
             ++(*Mo);
             *Dy -= *(s1++);
          }
       break;
       case 2:                                 /* Day/Month/Yr -> Julian Day */
          V = 367.0 * yr - (ByTe_4)(7 * (yr + (ByTe_4) ((mo + 9 )/12)) / 4)
              - (ByTe_4)(3 * ((ByTe_4)((yr + (mo - 9)/7)/ 100) + 1) / 4 )
              + (ByTe_4) (275 * mo / 9 ) + dy + 1721028.5 + Ms/86400000.0;
       break;
       case 3:                                 /* Day No -> Julian Day       */
          *Mo = 1;
          *Dy = dy;
          while ( *Dy > *s1 )
          {
             ++(*Mo);
             *Dy -= *(s1++);
          }
          V = 367.0 * yr - (ByTe_4)(7 * ( yr + (ByTe_4) ((*Mo + 9 )/12)) / 4)
              - (ByTe_4)(3 * ((ByTe_4)((yr + (*Mo - 9)/7)/ 100) + 1) / 4 )
              + (ByTe_4) (275 * *Mo / 9 ) + *Dy + 1721028.5 + Ms/86400000.0;
       break;
       case 4:                                 /* Day/Month/Yr -> MJD       */
          V = 367.0 * yr - (ByTe_4)(7 * ( yr + (ByTe_4) ((mo + 9 )/12)) / 4)
              - (ByTe_4)(3 * ((ByTe_4)((yr + (mo - 9)/7)/ 100) + 1) / 4 )
              + (ByTe_4) (275 * mo / 9 ) + dy + 1721028.5 + Ms/86400000.0;
          V = V - 2400000.5;
       break;
       case 5:                                 /* Day No -> MJD             */
          *Mo = 1;
          *Dy = dy;
          while ( *Dy > *s1 )
          {
             ++(*Mo);
             *Dy -= *(s1++);
          }
          V = 367.0 * yr
              - (ByTe_4)(7 * ( yr + (ByTe_4) ((*Mo + 9 )/12)) / 4)
              - (ByTe_4)(3 * ((ByTe_4)((yr + (*Mo - 9)/7)/ 100) + 1) / 4 )
              + (ByTe_4) (275 * *Mo / 9 ) + *Dy;
          V += 1721028.5 + Ms/86400000.0;
          V = V - 2400000.5;
       break;
    }

    return (V);
}
