/****************************************************************************/
/*  This routine converts data into cartesian coordinates ready for         */
/*  the contour program                                                     */
/****************************************************************************/

#include <stdio.h>
#include <math.h>
#include "OpSySInD.h"
#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void PolarToCartesian (ByTe_4 PN, ByTe_1 New)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct ConTouR *Ct;
   struct PlaneInfo *Pn;

   register ReaL_4 *V, *T, *P, *EnD;
   register ReaL_4 *X, *Y, *Z;
   ReaL_4 CT, ST, x, y, z, xy, Mag, Phi;
   ByTe_4 Len;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;        /* plot definition info */
   Ct = (struct ConTouR *)Pd->Cont;                  /* contour information  */

   if (Ct->Method == 0)                              /* 3D data              */
   {                                                 /* BEG 3D               */
      Pn = (struct PlaneInfo *)Pd->Plane;            /* contour plane info   */
      if (Pn->VecSrc == 1 && New)                    /* need vector data     */
      {                                                /* BEG GET VEC DATA   */
         VecData (&Pn->Vs, &Pd->Pb, &Pd->Pe, Pn->Avg); /* get vector         */
         x = Pn->Avg[0];                               /* x Len              */
         y = Pn->Avg[1];                               /* y Len              */
         z = Pn->Avg[2];                               /* z Len              */
         xy = x * x + y * y;                           /* square of xy len   */
         Pn->Avg[0] = sqrt (xy + z*z);                 /* magnitude          */
         xy = sqrt (xy);                               /* xy length          */
         Pn->Avg[1] = atan2 (y, x) * 180.0 / M_PI;     /* phi                */
         Pn->Avg[2] = atan2 (z, xy) * 180.0 / M_PI;    /* theta              */
         switch (Pn->RotateTo)                       /* final axis switch    */
         {                                           /* BEG FINAL AXIS MODS  */
            case 1:                                  /* +Y axis              */
               Pn->Avg[1] -= 90.0;                   /* modify phi           */
            break;
            case 2:                                  /* +Z axis              */
               Pn->Avg[2] -= 90.0;                   /* modify theta         */
            break;
            case 3:                                  /* -X axis              */
               Pn->Avg[1] -= 180;                    /* modify phi           */
            break;
            case 4:                                  /* -Y axis              */
               Pn->Avg[1] -= 270;                    /* modify phi           */
            break;
            case 5:                                  /* -Z axis              */
               Pn->Avg[2] += 90.0;                   /* modify theta         */
            break;
         }                                           /* END FINAL AXIS MODS  */
      }                                              /* END GET VEC DATA     */

      Len = Wa.SizeWork / 7;                         /* length each varaible */
      V = (ReaL_4 *)Wa.WorkSpace + 4 * Len;          /* Magnitude            */
      EnD = V + Pd->PlotLen;                         /* end of magnitudes    */
      P = V + Len;                                   /* Phi                  */
      T = P + Len;                                   /* Theta                */
      X = (ReaL_4 *)Wa.WorkSpace + Len;              /* X                    */
      Y = X + Len;                                   /* Y                    */
      Z = Y + Len;                                   /* Z                    */

      for ( ; V < EnD; )                             /* sweep loop           */
      {                                              /* BEG SWEEP LOOP       */
          CT = cos (*T);                             /* cos theta            */
          ST = sin (*T++);                           /* sin theta            */
          *X++ = *V * cos (*P) * CT;                 /* X                    */
          *Y++ = *V * sin (*P++) * CT;               /* Y                    */
          *Z++ = *V++ * ST;                          /* Z                    */
      }                                              /* END SWEEP LOOP       */
   }                                                 /* END 3D               */
   else                                              /* normal 2D data       */
   {                                                 /* BEG 2D               */
      Len = Wa.SizeWork/3;                           /* length each varaible */
      V = (ReaL_4 *)Wa.WorkSpace + Len;              /* Magnitude            */
      EnD = V + Pd->PlotLen;                         /* end of magnitudes    */
      P = V + Len;                                   /* Phi                  */
      X = (ReaL_4 *)Wa.WorkSpace + Len;              /* X                    */
      Y = X + Len;                                   /* Y                    */

      for ( ; V < EnD; )                             /* sweep loop           */
      {                                              /* BEG SWEEP LOOP       */
          Mag = *V++;                                /* magnitude            */
          Phi = *P++;                                /* phi                  */
          *X++ = Mag * cos (Phi);                    /* X                    */
          *Y++ = Mag * sin (Phi);                    /* Y                    */
      }                                              /* END SWEEP LOOP       */
   }                                                 /* END 2D               */
}

