#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void MenuCut (struct PlotDef *Pd, ByTe_2 N)
{
   extern struct MeNuS Ms;

   struct PaGe *Pg;
   struct QuEsTiOnS *Qs, *QsEnd;
   struct CutDef *cD;

   ByTe_4 L;

   /*************************************************************************/
   /*   CUT MENU  - TRANSFER:                                               */
   /*                                                                       */
   /* ID[00]:   PLOT PLACEMENT    [0-BOTTOM;  1-RIGHT SIDE                ] */
   /* ID[01]:   % OF PLOT                                                   */
   /* ID[02]:   NUMBER OF CUTS                                              */
   /* ID[03]:   CUT 1 END POINTS  [BEG X][BEG Y][END X][END Y]              */
   /* ID[04]:   CUT 1 PLOT COLOR  [WHITE, RED, YEL, GRN, CYAN, BLUE, PURP ] */
   /* ID[05]:   CUT 1 PLOT FORMAT [HISTOGRAM, SCATTER, LINE  BAR          ] */
   /* ID[06]:   CUT 1 SHOW CUT    [NO, UND(W), OVER(W), UND(C), OVER(C)   ] */
   /* ID[07]:   CUT 2 END POINTS  [BEG X][BEG Y][END X][END Y]              */
   /* ID[08]:   CUT 2 PLOT COLOR  [WHITE, RED, YEL, GRN, CYAN, BLUE, PURP ] */
   /* ID[09]:   CUT 2 PLOT FORMAT [HISTOGRAM, SCATTER, LINE  BAR          ] */
   /* ID[10]:   CUT 2 SHOW CUT    [NO, UND(W), OVER(W), UND(C), OVER(C)   ] */
   /* ID[11]:   CUT 3 END POINTS  [BEG X][BEG Y][END X][END Y]              */
   /* ID[12]:   CUT 3 PLOT COLOR  [WHITE, RED, YEL, GRN, CYAN, BLUE, PURP ] */
   /* ID[13]:   CUT 3 PLOT FORMAT [HISTOGRAM, SCATTER, LINE  BAR          ] */
   /* ID[14]:   CUT 3 SHOW CUT    [NO, UND(W), OVER(W), UND(C), OVER(C)   ] */
   /* ID[15]:   CUT 4 END POINTS  [BEG X][BEG Y][END X][END Y]              */
   /* ID[16]:   CUT 4 PLOT COLOR  [WHITE, RED, YEL, GRN, CYAN, BLUE, PURP ] */
   /* ID[17]:   CUT 4 PLOT FORMAT [HISTOGRAM, SCATTER, LINE  BAR          ] */
   /* ID[18]:   CUT 4 SHOW CUT    [NO, UND(W), OVER(W), UND(C), OVER(C)   ] */
   /*************************************************************************/

   if ((Pd->CCut = malloc (sizeof (struct CutDef))) == 0)
      exit(-1); 

   cD = (struct CutDef *)Pd->CCut;
   Pg = (struct PaGe *) Ms.page + N;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ; 

   for ( ; Qs < QsEnd; ++Qs)
   {
      switch (Qs->ID)
      {
         case 0:
            cD->CutPlace = Qs->OpReply; 
         break;
         case 1:
            sscanf (Qs->CReply,"%f", &cD->CutSpace); 
            cD->CutSpace /= 100.0;
         break;
         case 2:
            cD->CutPlot = Qs->OpReply; 
         break;
         case 3:
         case 7:
         case 11:
         case 15:
            L = (Qs->ID - 3)/4;
            if (Qs->state == 1)
            {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply,"%f %f %f %f", 
                             &cD->X1[L], &cD->Y1[L], &cD->X2[L], &cD->Y2[L]); 
            }
         break;
         case 4:
         case 8:
         case 12:
         case 16:
            L = (Qs->ID - 4)/4;
            if (Qs->state == 1)
               cD->PlotCol[L] = Qs->OpReply;
         break;
         case 5:
         case 9:
         case 13:
         case 17:
            L = (Qs->ID - 5)/4;
            if (Qs->state == 1)
               cD->PlotFmt[L] = Qs->OpReply;
         break;
         case 6:
         case 10:
         case 14:
         case 18:
            L = (Qs->ID - 6)/4;
            if (Qs->state == 1)
               cD->ShowCut[L] = Qs->OpReply;
         break;
      }
   }
}
