#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "libbase_udf.h"
#include "UDFpltAnsi.h"

void GetWorkSpace (struct PlotDef *Pd)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct SrcInfo  *S, *SEnD;
   struct idf_data  *ExDa;
   struct ConTouR *Ct;

   ByTe_4 B, Elem, dT, SpPSpn;
   ByTe_2 Np = 0;

   ExDa = (struct idf_data *) InFo.UDF;            /* ptr to UDF data        */
   S = (struct SrcInfo *) Pd->Src;                 /* source structure       */
   SEnD = S + Pd->EmptySrc;                        /* end source structure   */

   if (Pd->AData[0] == 1 && Pd->AData[1] == 1)     /* value vs value?        */
      Np = 1;                                      /* then only one plot     */
   else                                            /* the harder cases       */
   {                                               /* begin mixed plots      */
      if (Pd->DoSrcs == 1)                         /* sources not merged?    */
      {                                            /* BEG SEPARATE SOURCES   */
         for ( ; S < SEnD; ++S )                   /* loop over sources      */
            if (S->SType == 3 && (Pd->AData[0] == 1 || Pd->AData[1] == 1)) 
               Np += (S->OneAll == 3) ? ExDa->TotCols : 1;
            else
               Np += (S->Col.Fmt < 0) ? 1 : S->Col.N;     /* graphs per plot */
      }                                            /* END SEPARATE SOURCES   */
      else                                         /* plots are merged       */
         Np += S->Col.N;                           /* 1 plot/collapse        */
   }
   Pd->nGL = Np;                                   /* save subplots          */

   if (Pd->AData[0] == 1 && Pd->AData[1] == 1)     /* discrete X and Y axis  */
      Elem = Pd->Bx.N * Pd->Byl.N;                 /* total elements needed  */
   else                                            /* 1 axis non-descrete    */
   {                                               /* BEG ONE NON-DESCRETE   */
      if (Pd->AData[0] == 8)                       /* contour plot           */
      {                                            /* BEG CONTOUR PLOT       */
         Ct = (struct ConTouR *)Pd->Cont;          /* contour information    */
         dT = ExDa->emilli - ExDa->bmilli;         /* one sweep              */
         if (dT < 0) dT += 86400000;               /* cross day correction   */
         SpPSpn = ExDa->spin_rate /dT;             /* Spectra Per Spin + 4   */ 
         if (SpPSpn < 0) SpPSpn = -SpPSpn;         /* account for neg spin   */
         Elem = SpPSpn + 4;                        /* add some slop          */
         Elem *= ExDa->num_sample * Pd->EmptySrc;  /* total elements w/slop  */ 
         Elem *= (Ct->Method == 0) ? 7 : 3;        /* 4 or 3 dimension data  */
      }                                            /* END CONTOUR PLOT       */
      else                                         /* non-contour plot       */
      {                                            /* BEG GRIDDED PLOT       */
         if (Pd->AData[0] != 1)                    /* is X non-descrete      */
         {                                         /* BEG NON_DESCRETE X     */
            if (Pd->AData[1] == 1)                 /* is Y descrete          */
               Elem = Pd->Bx.N;                    /* total elements needed  */
            else                                   /* both non-descrete      */
               Elem = Pd->Bx.N * Pd->Byl.N;        /* total elements needed  */
         }                                         /* END NON_DESCRETE X     */
         else                                      /* x axis is descrete     */
         {
            if (Pd->AData[1] == 7)                 /* is Y descrete          */
               Elem = Pd->Bx.N;                    /* total elements needed  */
            else
               Elem = Pd->Byl.N;                   /* total elements needed  */
         }
         Pd->PlotLen = Elem;                       /* elements per plot      */
         Elem *= Np * 2;                           /* total elems: 2 is norm */
      }                                            /* END GRIDDED PLOT       */
   }                                               /* END ONE NON-DESCRETE   */

   if (Elem > Wa.SizeWork)                         /* Need more WorkSpace?   */
   {                                               /* BEG ADD SPACE          */
      Wa.SizeWork = Elem;                          /* new work area size     */
      B = Wa.SizeWork * sizeof (ReaL_4);           /* total bytes needed     */
      if ((Wa.WorkSpace = realloc(Wa.WorkSpace, B)) == 0)  /* work space     */
         ErrorRpt ("GetWorkSpace", 0, 2);          /* EGADS! an error        */
      ZeroWkSp();                                  /* zero out workspace     */
   }                                               /* END ADD SPACE          */
}
