/*****************************************************************************/
/*                                                                           */
/*   The following are the recognized time bases from which to compute the   */
/*   time elapsed since the start of the plot and from there to compute the  */
/*   the current pixel(s)                                                    */
/*                                                                           */
/*   YEARS         0                                                         */
/*   DAYS          1                                                         */
/*   HOURS         2                                                         */
/*   MINUTES       3                                                         */
/*   SECONDS       4                                                         */
/*   MILLISECONDS  5                                                         */
/*   MICROSECONDS  6                                                         */
/*   NANOSECONDS   7                                                         */
/*                                                                           */
/*****************************************************************************/

#include <stdlib.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void GetPiXeL (ByTe_4 N, struct TiMiNg *T, ByTe_1 Axis, ByTe_1 PLoc, 
                 ByTe_4 *PixN, ReaL_4 *PixF)
{
   extern struct UserDefs InFo;

   struct PlotDef *Pd;
   struct Binning *Bn;

   ReaL_8 dT, AddLeap;
   ReaL_8 dY, dD, dM;
   ReaL_4 Pix; 
   ByTe_4 Y;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;         /* plot info struct     */
   Bn = (Axis < 4) ? &Pd->Bx : &Pd->Byl;  

   dY = T->Yr - Pd->Pb.Yr;                           /* diff of years        */
   dD = T->Dy - Pd->Pb.Dy;                           /* diff of days         */
   dM = T->Ms - Pd->Pb.Ms;                           /* diff of msec         */

   switch (Bn->Sca)                                  /* switch by time base  */
   {                                                 /* BEG TIME BASE SWITCH */
      case 1:                                        /* START DAY BASE TIME  */
         dT = dY * 365.0 + dD;                       /* base days            */
         if (dM < 0)                                 /* neg msec?            */
         {                                           /* BEG NEG MSEC COR     */
            dT -= 1.0;                               /* borrow a day         */
            dM += 86400000.0;                        /* give it to msec      */
         }                                           /* END NEG MSEC COR     */
         dT += dM/86400000.0;                        /* add left over time   */
         AddLeap = 1;                                /* add 1 day per leap   */
      break;                                         /* STOP DAY BASE TIME   */

      case 4:                                        /* START DAY SEC TIME   */
         dT = dY * 31536000.0 + dD * 86400.0;        /* base sec             */
         if (dM < 0)                                 /* neg msec?            */
         {                                           /* BEG NEG MSEC COR     */
            dT -= 86400.0;                           /* borrow a day         */
            dM += 86400000.0;                        /* give it to msec      */
         }                                           /* END NEG MSEC COR     */
         dT += dM / 1000;                            /* add left over time   */
         AddLeap = 86400.0;                          /* day in seconds       */
      break;                                         /* STOP DAY SEC TIME    */

      case 5:                                        /* START DAY MSEC TIME  */
         dT = dD * 86400000.0 + dM;                  /* base msec            */
         dT += T->Ns * 1.0e-6;                       /* left over time       */
         AddLeap = 0.0;                              /* no change in year    */
      break;                                         /* STOP DAY MSEC TIME   */
   }                                                 /* END TIME BASE SWITCH */

   for (Y = Pd->Pb.Yr; Y < T->Yr; ++Y)               /* leap year loop       */
   {                                                    /* BEG LEAP LOOP     */
      if ((Y % 4 == 0 && Y % 100 != 0) || Y % 400 == 0) /* Leap Year?        */
         dT += AddLeap;                                 /* Add a day         */
   }                                                    /* END LEAP LOOP     */

   if (dT >= 0)                                      /* valid time?          */
   {                                                 /* BEG VALID TIME       */
      Pix = dT / Bn->R;                              /* float pixel number   */
      *PixN = (ByTe_4)Pix;                           /* int pixel number     */
      *PixF = Pix - *PixN;                           /* frac pixel number    */
      if (PLoc == 0) *PixF = 1.0 - *PixF;            /* this is start pixel  */
   }                                                 /* BEG VALID TIME       */
   else                                              /* time outside rng     */
   {                                                 /* BEG VALS TO DEFAULT  */
      *PixN = -1;                                    /* pix to -1            */
      *PixF = 0.0;                                   /* no frac              */
   }                                                 /* BEG VALS TO DEFAULT  */
}
