#include <math.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void GiveEdges (ReaL_4 *C, ReaL_4 *W, ReaL_4 *E, ByTe_4 N, ByTe_4 bP,
                ByTe_1 Sca, ByTe_1 Fmt)
{
   register ReaL_4 *f1, *f2, *f3, *f4, *fEnD;
   ReaL_4 V1, V2;
   ByTe_4 I;

   f1 = C;
   f2 = W;
   f3 = E;
   f4 = E + N;
   if (Fmt != 'N') {
      fEnD = C + N;
      switch (Fmt) {
         case 'L':
           for ( ; f1 < fEnD; ) {
              *f3++ = *f1;
              *f4++ = *f1++ + *f2++;
           }
         break;
         case 'C':
           for ( ; f1 < fEnD; ) {
              *f3++ = *f1 - *f2 / 2.0;
              *f4++ = *f1++ + *f2++ / 2.0;
           }
         break;
         case 'U':
           for ( ; f1 < fEnD; ) {
              *f3++ = *f1 - *f2++;
              *f4++ = *f1++;
           }
         break;
      }
   } else {
      fEnD = C + N - 1;
      if (Sca == 0) {                                /* BEG LINEAR SCALING  */ 
         for ( I = 0; f1 < fEnD; ++f1, ++I) {
           if (I != bP) {
              *f3++ = *f1 - (*(f1 + 1) - *f1)/2.0;
              *f4++ = *f1 + (*(f1 + 1) - *f1)/2.0;
            } else {
              *f3++ = *f1 - (*f1 - *(f1 - 1))/2.0;
              *f4++ = *f1 + (*f1 - *(f1 - 1))/2.0;
            }
         }
         *f3 = *f1 - (*f1 - *(f1 - 1))/2.0;
         *f4 = *f1 + (*f1 - *(f1 - 1))/2.0;
      } else {
         for ( I = 0; f1 < fEnD; ++f1, ++I) {
           if (I != bP) {
              V1 = log (*f1);
              V2 = log (*(f1 + 1));
              *f3++ = V1 - (V2 - V1)/2.0;
              *f4++ = V1 + (V2 - V1)/2.0;
            } else {
              V1 = log (*f1);
              V2 = log (*(f1 - 1));
              *f3++ = V1 - (V1 - V2)/2.0;
              *f4++ = V1 + (V1 - V2)/2.0;
            }
         }
         *f3 = V1 - (V1 - V2)/2.0;
         *f4 = V1 + (V1 - V2)/2.0;
      }
   }                                               /* END LOG SCALING        */ 
}
