#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"

void DoInitializes ()
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   
   register struct SrcInfo *S, *Send;
   struct PlotDef *Pd, *PdEnd;

   register ByTe_1 *c1, *cEnD;
   ByTe_1 SPos[20], Cnt;
   ByTe_2 N;

   InFo.PYmax = -1;
   InFo.PYmin = 10000000;
   InFo.PXmax = -1;
   InFo.PXmin = 10000000;

   Pd = (struct PlotDef *)InFo.PlotDefs;
   PdEnd = Pd + InFo.NPDefs;
   for ( ; Pd < PdEnd; ++Pd)
   {                                              /* BEGIN PLOT DEF LOOP    */
      Pd->NegYr = 0;
      Pd->Pb.Yr = InFo.TB.Yr;
      Pd->Pb.Dy = InFo.TB.Dy;
      Pd->Pb.Ms = InFo.TB.Ms;
      Pd->Pb.Ns = InFo.TB.Ns;
      Pd->Pe.Yr = InFo.TE.Yr;
      Pd->Pe.Dy = InFo.TE.Dy;
      Pd->Pe.Ms = InFo.TE.Ms;
      Pd->Pe.Ns = InFo.TE.Ns;
      Pd->SrcsYL = 0;
      Pd->SrcsYR = 0;
      Pd->FSrcYL = -1;
      Pd->nGL = 0;
      Pd->nGR = 0;
      Pd->More = 1;
      Pd->AxisDef = 0;
      Pd->PlotLen = 0;

/*****************************************************************************/
/*     PType definitions                                                     */
/*      0 - Time based:  X-axis is time                                      */
/*      1 - Scan based: One axis is scan other is not time or value          */
/*      2 - Any plot not fit into another category                           */
/*      3 - Pregridded Contour Plot                                          */
/*      4 - Contour Plot:                                                    */
/*      5 - Value Plot: One axis is a 1D quantity                            */ 
/*****************************************************************************/

      if (Pd->AData[0] == 0)                           /* Time Plot          */
      {                                                /* BEG TIME SETS      */
         Pd->PType = 0;                                /* time based plot    */
         Pd->YSet = (Pd->AData[1] == 1) ? -1 : 1;      /* no bins if value   */
      }                                                /* END TIME SETS      */
      else                                             /* not a time plot    */
      {                                                /* BEG NOT TIME BASED */
         Pd->Pb.Yr = -1;                               /* time to 1st data   */
         if (Pd->AData[0] == 2 || Pd->AData[1] == 2    
            || Pd->AData[0] == 9 || Pd->AData[1] == 9) /* one axis is scan?  */
         {                                             /* BEG HAS SCAN AXIS  */
            Pd->YSet = 1;                              /* Y no bins if value */
            Pd->PType = (Pd->AData[0] == 1 || Pd->AData[1] == 1) ? 5 : 1; 
         }                                             /* END HAS SCAN AXIS  */
         else                                          /* generic plot       */
         {                                             /* BEG GENERIC PLOT   */
            if (Pd->AData[0] == 8)                     /* contour?           */
               Pd->PType = 4;                          /* full contour plot  */
            else                                       /* default all others */
            {                                          /* BEG GENERIC PLOT   */
               if (Pd->AData[0] == 1 || Pd->AData[1] == 1)
               {
                  Pd->PType = 5;                       /* generic 1D plot    */
                  Pd->YSet = 0;                        /* bins along Y       */
               }
               else
               {
                  Pd->PType = 2;                       /* set generic plot   */
                  Pd->YSet = 0;                        /* bins along Y       */
              }
            }                                          /* BEG GENERIC PLOT   */
         }                                             /* BEG GENERIC PLOT   */
      }                                                /* END NOT TIME BASED */

      if (Pd->IncCont == 1 && Pd->AData[0] != 8)       /* pregrid contour    */
         Pd->PType = 3;                                /* flag it            */

      c1 = SPos;
      cEnD = c1 + DATADEFS;
      for ( ; c1 < cEnD; )
         *c1++ = -1;

      Cnt = 0;
      if (Pd->AData[0] == 3 || Pd->AData[1] == 3 || Pd->AData[0] == 8)
      {
         SPos[3] = Cnt;
         Cnt += 2;
      }
      if (Pd->AData[0] == 4 || Pd->AData[1] == 4)
         SPos[4] = Cnt++;
      if (Pd->AData[0] == 5 || Pd->AData[1] == 5 || Pd->AData[0] == 8)
      {
         SPos[5] = Cnt;
         Cnt += 2;
      }

      for (N = 6; N < DATADEFS; ++N)
         if (Pd->AData[0] == N || Pd->AData[1] == N)
            SPos[N] = Cnt++;

      N = DATADEFS + 1;
      SPos[DATADEFS] = Cnt;
      Pd->SecPos = TransFer (SPos, 1, N);

      if (Pd->EmptySrc > 0)                          /* initialize any srcs */
      {                                              /* BEGIN SOURCE INITS  */
         S = (struct SrcInfo *)Pd->Src;
         Send = S + Pd->EmptySrc;
         for ( ; S < Send; ++S )
         {
            S->Bt.Yr = -1;
            S->PrevRead = 0;
            S->Pri = 0;
            S->Alt = 0;
            S->Bins = 0;
            if (S->PAxis == 4)
            {
               if (Pd->FSrcYL < 0)
                  Pd->FSrcYL = N;
               ++Pd->SrcsYL; 
            } 
            else
               if (S->PAxis == 6)
                  ++Pd->SrcsYR; 
         }
      }                                              /* END SOURCE INITS    */
      Pd->ExPlots = RowCol (Pd);
   }                                                 /* BEGIN PLOT DEF LOOP */

   Wa.SizeWork = 0;
   Wa.WorkSpace = 0;
   Wa.SizeScr = 0;
   Wa.Scratch = 0;
   Wa.Num = 0;
}
